/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.GrupoPontoPK;
import br.com.fiorilli.sip.persistence.entity.PermissoesPerfilGrupoPonto;
import br.com.fiorilli.sip.persistence.entity.PontoMes;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="GRUPO_PONTO")
@Audited(insert=false)
public class GrupoPonto
implements Serializable,
GenericEntity,
Filterable {
    public static final String FIND_FOR_FILTER = "SELECT g FROM GrupoPonto g where g.grupoPontoPK.entidade = :entidadeCodigo AND concat(g.grupoPontoPK.codigo, g.nome) LIKE concat('%', :param, '%') ";
    public static final String FIND_ALL = "SELECT g FROM GrupoPonto g ORDER BY g.nome ";
    public static final String FIND_BY_NOME = "SELECT g FROM GrupoPonto g WHERE g.nome LIKE :nome";
    public static final String FIND_BY_ENTIDADE = "SELECT g FROM GrupoPonto g WHERE g.grupoPontoPK.entidade = :entidadeCodigo";
    @EmbeddedId
    protected GrupoPontoPK grupoPontoPK;
    @SearchNome
    @FilterConfig(label="Nome", order=2, condition=FilterCondition.CONTENHA)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="grupoPonto")
    private List<Trabalhador> trabalhadorList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="grupoPonto")
    private List<PontoMes> pontoMesList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="grupoPonto")
    private List<PermissoesPerfilGrupoPonto> permissoesPerfilGrupoPontoList;

    public String getItemId() {
        return String.valueOf(this.grupoPontoPK.getCodigo());
    }

    public String getItemLabel() {
        return this.nome;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrupoPonto grupoPonto = (GrupoPonto)o;
        return Objects.equals(this.grupoPontoPK, grupoPonto.grupoPontoPK);
    }

    public int hashCode() {
        return Objects.hash(this.grupoPontoPK);
    }

    public String toString() {
        return "GrupoPonto{grupoPontoPK=" + this.grupoPontoPK + ", nome='" + this.nome + '\'' + '}';
    }

    public GrupoPontoPK getGrupoPontoPK() {
        return this.grupoPontoPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public List<Trabalhador> getTrabalhadorList() {
        return this.trabalhadorList;
    }

    public void setTrabalhadorList(List<Trabalhador> trabalhadorList) {
        this.trabalhadorList = trabalhadorList;
    }

    public List<PontoMes> getPontoMesList() {
        return this.pontoMesList;
    }

    public void setPontoMesList(List<PontoMes> pontoMesList) {
        this.pontoMesList = pontoMesList;
    }

    public List<PermissoesPerfilGrupoPonto> getPermissoesPerfilGrupoPontoList() {
        return this.permissoesPerfilGrupoPontoList;
    }

    public void setPermissoesPerfilGrupoPontoList(List<PermissoesPerfilGrupoPonto> permissoesPerfilGrupoPontoList) {
        this.permissoesPerfilGrupoPontoList = permissoesPerfilGrupoPontoList;
    }
}

