/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.LocalPublicacao;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="GRADE_SUBSTITUICAO")
@Audited
public class GradeSubstituicao
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_GRADESUBSTITUICAO";
    public static final String GET_FETCHED = "SELECT gs FROM GradeSubstituicao gs LEFT JOIN FETCH gs.localPublicacao LEFT JOIN FETCH gs.tipoLegal where gs.id = :id";
    @Id
    private int id;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PUBLICACAO")
    private Date dataPublicacao;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_TERMINO_VIGENCIA")
    private Date dataTerminoVigencia;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATADOC")
    private Date dataDocumento;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Type(type="BooleanTypeSip")
    @Column(name="GATILHO_AFASTAMENTO")
    private Boolean gatilhoAfastamento;
    @Type(type="BooleanTypeSip")
    @Column(name="GATILHO_FERIAS")
    private Boolean gatilhoFerias;
    @Type(type="BooleanTypeSip")
    @Column(name="GATILHO_LICPREM")
    private Boolean gatilhoLicencaPremio;
    @ManyToOne
    @JoinColumn(name="LOCAL_PUBLICACAO", referencedColumnName="CODIGO")
    private LocalPublicacao localPublicacao;
    @Column(name="NUMDOC", length=16)
    private String numeroDocumento;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private TipoDocumentoLegal tipoLegal;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDataPublicacao() {
        return this.dataPublicacao;
    }

    public void setDataPublicacao(Date dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    public Date getDataTerminoVigencia() {
        return this.dataTerminoVigencia;
    }

    public void setDataTerminoVigencia(Date dataTerminoVigencia) {
        this.dataTerminoVigencia = dataTerminoVigencia;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String empresa) {
        this.entidade = empresa;
    }

    public Boolean getGatilhoAfastamento() {
        return this.gatilhoAfastamento;
    }

    public void setGatilhoAfastamento(Boolean gatilhoAfastamento) {
        this.gatilhoAfastamento = gatilhoAfastamento;
    }

    public Boolean getGatilhoFerias() {
        return this.gatilhoFerias;
    }

    public void setGatilhoFerias(Boolean gatilhoFerias) {
        this.gatilhoFerias = gatilhoFerias;
    }

    public Boolean getGatilhoLicencaPremio() {
        return this.gatilhoLicencaPremio;
    }

    public void setGatilhoLicencaPremio(Boolean gatilhoLicencaPremio) {
        this.gatilhoLicencaPremio = gatilhoLicencaPremio;
    }

    public LocalPublicacao getLocalPublicacao() {
        return this.localPublicacao;
    }

    public void setLocalPublicacao(LocalPublicacao localPublicacao) {
        this.localPublicacao = localPublicacao;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipolegal) {
        this.tipoLegalCodigo = tipolegal != null ? tipolegal.getCodigo() : null;
        this.tipoLegal = tipolegal;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }
}

