/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Form;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="FORMS_CONTEXTO")
@Audited
public class FormsContexto
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "SELECT c FROM FormsContexto c order by c.contextoPai, c.ordem, c.codigo";
    public static final String QUERY_FIND_PRINCIPALS = "SELECT c FROM FormsContexto c where c.contextoPai is null order by c.ordem";
    public static final String QUERY_FIND_SUBCONTEXTOS = "SELECT c FROM FormsContexto c where c.contextoPai = :contextoPai";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Size(max=60)
    @Column(name="NOME_CONTEXTO")
    private String nome;
    @Column(name="ORDEM_CONTEXTO")
    private Short ordem;
    @OneToMany(mappedBy="contexto", fetch=FetchType.LAZY)
    private List<Form> formsList;
    @OneToMany(mappedBy="contextoPai", fetch=FetchType.LAZY)
    private List<FormsContexto> formsContextoList;
    @JoinColumn(name="CONTEXTO_PAI", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private FormsContexto contextoPai;
    @Transient
    private String indent;
    @Transient
    private String arvore;

    public FormsContexto() {
    }

    public FormsContexto(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Short getOrdem() {
        return this.ordem;
    }

    public void setOrdem(Short ordem) {
        this.ordem = ordem;
    }

    public List<Form> getFormsList() {
        return this.formsList;
    }

    public void setFormsList(List<Form> formsList) {
        this.formsList = formsList;
    }

    public List<FormsContexto> getFormsContextoList() {
        return this.formsContextoList;
    }

    public void setFormsContextoList(List<FormsContexto> formsContextoList) {
        this.formsContextoList = formsContextoList;
    }

    public FormsContexto getContextoPai() {
        return this.contextoPai;
    }

    public void setContextoPai(FormsContexto contextoPai) {
        this.contextoPai = contextoPai;
    }

    public String getIndent() {
        if (this.indent == null) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.getOrdem().toString());
            FormsContexto pai = this.getContextoPai();
            if (pai != null) {
                result.add(result.size() - 1, pai.getIndent() + ".");
            }
            StringBuilder sb = new StringBuilder();
            for (String s : result) {
                sb.append(s);
            }
            this.indent = sb.toString();
        }
        return this.indent;
    }

    public String getArvore() {
        if (this.arvore == null) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.getNome());
            FormsContexto pai = this.getContextoPai();
            if (pai != null) {
                result.add(result.size() - 1, pai.getNome() + "/");
            }
            StringBuilder sb = new StringBuilder();
            for (String s : result) {
                sb.append(s);
            }
            this.arvore = sb.toString();
        }
        return this.arvore;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FormsContexto)) {
            return false;
        }
        FormsContexto other = (FormsContexto)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return this.getIndent() + " - " + this.getNome();
    }
}

