/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.FeriasMovimento;
import br.com.fiorilli.sip.persistence.entity.SiplogAction;
import br.com.fiorilli.sipweb.vo.FrequenciaVO;
import br.com.fiorilli.sipweb.vo.TipoAusencia;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MOVTOFERIAS_LIXEIRA")
public class FeriasMovimentoLixeira
implements Serializable {
    public static String SQL_FIND_FREQUENCIA_VO_BY_PERIOD = "SELECT DISTINCT new " + FrequenciaVO.class.getCanonicalName() + "(" + "l.entidade, " + "l.registro, " + "l.gozoInicio, " + "l.gozoFim, " + "'" + TipoAusencia.FERIAS.getId() + "', " + "(l.entidade || '-' || l.ferias || '-' || l.item || '-' || l.registro), " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "l.dataExclusao) " + "FROM FeriasMovimentoLixeira l " + "LEFT JOIN l.feriasMovimento m " + "LEFT JOIN m.trabalhador t " + "WHERE l.entidade = :entidadeCodigo AND l.dataExclusao BETWEEN :periodoInicio AND :periodoFim AND l.gozoInicio IS NOT NULL ";
    public static String SQL_NATIVE_FIND_FREQUENCIA_VO_BY_PERIOD = "SELECT DISTINCT l.EMPRESA, l.REGISTRO, l.GOZOINI, l.GOZOFIM, '" + TipoAusencia.FERIAS.getId() + "', " + "(l.EMPRESA || '-' || l.FERIAS || '-' || l.ITEM || '-' || l.REGISTRO), " + "t.MATRICULA, " + "t.CONTRATO, " + "t.CPF, " + "CAST(l.DATA_EXCLUSAO AS DATE)," + "'' AS LOGTEXT," + "COALESCE(" + "(SELECT MAX(sl.LOGHOUR) " + "   FROM SIPLOG sl " + "   INNER JOIN SIPLOG_TABLE st ON st.CODIGO = sl.TABLEID " + "   WHERE sl.LOGDATE = CAST(l.DATA_EXCLUSAO AS DATE) " + "       AND sl.ACTIONID = " + SiplogAction.EXCLUIU.ordinal() + " " + "       AND st.NOME = 'MOVTOFERIAS' " + "       AND sl.LOGTEXT LIKE '%EMPRESA=' || l.EMPRESA || '%' " + "       AND sl.LOGTEXT LIKE '%REGISTRO=' || l.REGISTRO || '%' " + "       AND sl.LOGTEXT LIKE '%FERIAS=' || l.FERIAS || '%' " + "       AND sl.LOGTEXT LIKE '%ITEM=' || l.ITEM || '%'), " + "CAST(l.DATA_EXCLUSAO AS TIME)) AS LOGHOUR " + "FROM MOVTOFERIAS_LIXEIRA l " + "LEFT JOIN MOVTOFERIAS m ON m.EMPRESA = l.EMPRESA AND m.REGISTRO = l.REGISTRO AND m.FERIAS = l.FERIAS AND m.ITEM = l.ITEM " + "LEFT JOIN TRABALHADOR t ON t.EMPRESA = l.EMPRESA AND t.REGISTRO = l.REGISTRO " + "WHERE l.EMPRESA = :entidadeCodigo AND l.DATA_EXCLUSAO BETWEEN :periodoInicio AND :periodoFim AND l.GOZOINI IS NOT NULL ";
    @Id
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Column(name="FERIAS")
    private Short ferias;
    @Basic(optional=false)
    @NotNull
    @Column(name="ITEM")
    private Short item;
    @Size(max=2)
    @Column(name="PAGTOMES")
    private String mesPagamento;
    @Size(max=4)
    @Column(name="PAGTOANO")
    private String anoPagamento;
    @Column(name="GOZOINI")
    @Temporal(value=TemporalType.DATE)
    private Date gozoInicio;
    @Column(name="GOZOFIM")
    @Temporal(value=TemporalType.DATE)
    private Date gozoFim;
    @Column(name="DIASABONO")
    private Short diasAbono;
    @Type(type="BooleanTypeSip")
    @Column(name="APENASABONO")
    private Boolean apenasAbono;
    @Column(name="REFERENCIA_PAGTO")
    private Integer referenciaPagto;
    @Column(name="PAGTODIAS")
    private Short pagamentoDias;
    @Type(type="BooleanTypeSip")
    @Column(name="APENASTERCO")
    private Boolean apenasTerco;
    @Type(type="BooleanTypeSip")
    @Column(name="SOMENTE_RECIBO")
    private Boolean somenteRecibo;
    @Column(name="DTPREVPAG")
    @Temporal(value=TemporalType.DATE)
    private Date dataPagamentoPrevidencia;
    @Type(type="BooleanTypeSip")
    @Column(name="CALCULAR_AVOS")
    private Boolean calcularAvos;
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO_FERIAS")
    private Integer codigoFerias;
    @Type(type="BooleanTypeSip")
    @Column(name="CALCULAR_UMTERCO_ABONO")
    private Boolean calcularUmtercoAbono;
    @Type(type="BooleanTypeSip")
    @Column(name="ADTO13SAL")
    private Boolean adiantamento13Salario;
    @Column(name="DTRETORNO")
    @Temporal(value=TemporalType.DATE)
    private Date dataRetorno;
    @Column(name="DATA_EXCLUSAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataExclusao;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false), @JoinColumn(name="FERIAS", referencedColumnName="FERIAS", insertable=false, updatable=false), @JoinColumn(name="ITEM", referencedColumnName="ITEM", insertable=false, updatable=false)})
    private FeriasMovimento feriasMovimento;

    public FeriasMovimentoLixeira() {
    }

    public FeriasMovimentoLixeira(Integer codigo, String entidade, String registro, Short ferias, Short item, String mesPagamento, String anoPagamento, Date gozoInicio, Date gozoFim, Short diasAbono, Boolean apenasAbono, Integer referenciaPagto, Short pagamentoDias, Boolean apenasTerco, Boolean somenteRecibo, Date dataPagamentoPrevidencia, Boolean calcularAvos, Integer codigoFerias, Boolean calcularUmtercoAbono, Boolean adiantamento13Salario, Date dataRetorno, Date dataExclusao) {
        this.codigo = codigo;
        this.entidade = entidade;
        this.registro = registro;
        this.ferias = ferias;
        this.item = item;
        this.mesPagamento = mesPagamento;
        this.anoPagamento = anoPagamento;
        this.gozoInicio = gozoInicio;
        this.gozoFim = gozoFim;
        this.diasAbono = diasAbono;
        this.apenasAbono = apenasAbono;
        this.referenciaPagto = referenciaPagto;
        this.pagamentoDias = pagamentoDias;
        this.apenasTerco = apenasTerco;
        this.somenteRecibo = somenteRecibo;
        this.dataPagamentoPrevidencia = dataPagamentoPrevidencia;
        this.calcularAvos = calcularAvos;
        this.codigoFerias = codigoFerias;
        this.calcularUmtercoAbono = calcularUmtercoAbono;
        this.adiantamento13Salario = adiantamento13Salario;
        this.dataRetorno = dataRetorno;
        this.dataExclusao = dataExclusao;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Short getFerias() {
        return this.ferias;
    }

    public void setFerias(Short ferias) {
        this.ferias = ferias;
    }

    public Short getItem() {
        return this.item;
    }

    public void setItem(Short item) {
        this.item = item;
    }

    public String getMesPagamento() {
        return this.mesPagamento;
    }

    public void setMesPagamento(String mesPagamento) {
        this.mesPagamento = mesPagamento;
    }

    public String getAnoPagamento() {
        return this.anoPagamento;
    }

    public void setAnoPagamento(String anoPagamento) {
        this.anoPagamento = anoPagamento;
    }

    public Date getGozoInicio() {
        return this.gozoInicio;
    }

    public void setGozoInicio(Date gozoInicio) {
        this.gozoInicio = gozoInicio;
    }

    public Date getGozoFim() {
        return this.gozoFim;
    }

    public void setGozoFim(Date gozoFim) {
        this.gozoFim = gozoFim;
    }

    public Short getDiasAbono() {
        return this.diasAbono;
    }

    public void setDiasAbono(Short diasAbono) {
        this.diasAbono = diasAbono;
    }

    public Boolean getApenasAbono() {
        return this.apenasAbono;
    }

    public void setApenasAbono(Boolean apenasAbono) {
        this.apenasAbono = apenasAbono;
    }

    public Integer getReferenciaPagto() {
        return this.referenciaPagto;
    }

    public void setReferenciaPagto(Integer referenciaPagto) {
        this.referenciaPagto = referenciaPagto;
    }

    public Short getPagamentoDias() {
        return this.pagamentoDias;
    }

    public void setPagamentoDias(Short pagamentoDias) {
        this.pagamentoDias = pagamentoDias;
    }

    public Boolean getApenasTerco() {
        return this.apenasTerco;
    }

    public void setApenasTerco(Boolean apenasTerco) {
        this.apenasTerco = apenasTerco;
    }

    public Boolean getSomenteRecibo() {
        return this.somenteRecibo;
    }

    public void setSomenteRecibo(Boolean somenteRecibo) {
        this.somenteRecibo = somenteRecibo;
    }

    public Date getDataPagamentoPrevidencia() {
        return this.dataPagamentoPrevidencia;
    }

    public void setDataPagamentoPrevidencia(Date dataPagamentoPrevidencia) {
        this.dataPagamentoPrevidencia = dataPagamentoPrevidencia;
    }

    public Boolean getCalcularAvos() {
        return this.calcularAvos;
    }

    public void setCalcularAvos(Boolean calcularAvos) {
        this.calcularAvos = calcularAvos;
    }

    public Integer getCodigoFerias() {
        return this.codigoFerias;
    }

    public void setCodigoFerias(Integer codigoFerias) {
        this.codigoFerias = codigoFerias;
    }

    public Boolean getCalcularUmtercoAbono() {
        return this.calcularUmtercoAbono;
    }

    public void setCalcularUmtercoAbono(Boolean calcularUmtercoAbono) {
        this.calcularUmtercoAbono = calcularUmtercoAbono;
    }

    public Boolean getAdiantamento13Salario() {
        return this.adiantamento13Salario;
    }

    public void setAdiantamento13Salario(Boolean adiantamento13Salario) {
        this.adiantamento13Salario = adiantamento13Salario;
    }

    public Date getDataRetorno() {
        return this.dataRetorno;
    }

    public void setDataRetorno(Date dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    public Date getDataExclusao() {
        return this.dataExclusao;
    }

    public void setDataExclusao(Date dataExclusao) {
        this.dataExclusao = dataExclusao;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeriasMovimentoLixeira that = (FeriasMovimentoLixeira)o;
        return Objects.equals(this.codigo, that.codigo);
    }

    public int hashCode() {
        return Objects.hash(this.codigo);
    }
}

