/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.FeriasMovimento;
import br.com.fiorilli.sip.persistence.entity.FeriasMovimentoColetivo;
import br.com.fiorilli.sip.persistence.entity.FeriasMovimentoColetivoItensPK;
import br.com.fiorilli.sipweb.vo.FrequenciaVO;
import br.com.fiorilli.sipweb.vo.TipoAusencia;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="MOVTOFERIAS_COLETIVO_ITENS")
public class FeriasMovimentoColetivoItens
implements Serializable {
    public static String SQL_FIND_FREQUENCIA_VO_BY_PERIOD = "SELECT DISTINCT new " + FrequenciaVO.class.getCanonicalName() + "(" + "i.pk.entidade, " + "i.pk.registro, " + "c.gozoInicio, " + "c.gozoFim, " + "'" + TipoAusencia.FERIAS.getId() + "', " + "(i.pk.entidade || '-' || i.pk.itemFerias || '-' || i.pk.itemMovto || '-' || i.pk.registro), " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "c.dhinclusao) " + "FROM FeriasMovimentoColetivoItens i " + "INNER JOIN i.feriasMovimentoColetivo c " + "LEFT JOIN i.feriasMovimento m " + "LEFT JOIN m.trabalhador t " + "WHERE i.pk.entidade = :entidadeCodigo AND c.dhinclusao BETWEEN :periodoInicio AND :periodoFim AND c.gozoInicio IS NOT NULL";
    public static String SQL_FIND_FREQUENCIA_VO_BY_PERIOD_NATIVE = "SELECT DISTINCT i.EMPRESA, i.REGISTRO, c.GOZOINI, c.GOZOFIM, '" + TipoAusencia.FERIAS.getId() + "', " + "(i.EMPRESA || '-' || i.ITEM_FERIAS || '-' || i.ITEM_MOVTO || '-' || i.REGISTRO), " + "t.MATRICULA, " + "t.CONTRATO, " + "t.CPF, " + "CAST(c.DHINCLUSAO AS DATE)," + "'' AS LOGTEXT," + "CAST(c.DHINCLUSAO AS TIME) AS LOGHOUR " + "FROM MOVTOFERIAS_COLETIVO_ITENS i " + "INNER JOIN MOVTOFERIAS_COLETIVO c ON c.CODIGO = i.ID_COLETIVO " + "LEFT JOIN MOVTOFERIAS m ON m.EMPRESA = i.EMPRESA AND m.REGISTRO = i.REGISTRO AND m.ITEM = i.ITEM_MOVTO AND m.FERIAS = i.ITEM_FERIAS " + "LEFT JOIN TRABALHADOR t ON t.EMPRESA = m.EMPRESA AND t.REGISTRO = m.REGISTRO " + "WHERE i.EMPRESA = :entidadeCodigo AND c.DHINCLUSAO BETWEEN :periodoInicio AND :periodoFim AND c.GOZOINI IS NOT NULL";
    @EmbeddedId
    private FeriasMovimentoColetivoItensPK pk;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLETIVO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private FeriasMovimentoColetivo feriasMovimentoColetivo;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false), @JoinColumn(name="ITEM_FERIAS", referencedColumnName="FERIAS", insertable=false, updatable=false), @JoinColumn(name="ITEM_MOVTO", referencedColumnName="ITEM", insertable=false, updatable=false)})
    private FeriasMovimento feriasMovimento;

    public FeriasMovimentoColetivoItens() {
    }

    public FeriasMovimentoColetivoItens(FeriasMovimentoColetivoItensPK pk) {
        this.pk = pk;
    }

    public FeriasMovimentoColetivoItensPK getPk() {
        return this.pk;
    }

    public void setPk(FeriasMovimentoColetivoItensPK pk) {
        this.pk = pk;
    }

    public FeriasMovimentoColetivo getFeriasMovimentoColetivo() {
        return this.feriasMovimentoColetivo;
    }

    public void setFeriasMovimentoColetivo(FeriasMovimentoColetivo feriasMovimentoColetivo) {
        this.feriasMovimentoColetivo = feriasMovimentoColetivo;
    }

    public FeriasMovimento getFeriasMovimento() {
        return this.feriasMovimento;
    }

    public void setFeriasMovimento(FeriasMovimento feriasMovimento) {
        this.feriasMovimento = feriasMovimento;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeriasMovimentoColetivoItens that = (FeriasMovimentoColetivoItens)o;
        return Objects.equals(this.pk, that.pk);
    }

    public int hashCode() {
        return Objects.hash(this.pk);
    }
}

