/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CancelaFerias;
import br.com.fiorilli.sip.persistence.entity.Ferias;
import br.com.fiorilli.sip.persistence.entity.FeriasMovimentoColetivoItens;
import br.com.fiorilli.sip.persistence.entity.FeriasMovimentoLixeira;
import br.com.fiorilli.sip.persistence.entity.FeriasMovimentoPK;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sipweb.vo.FrequenciaVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MOVTOFERIAS")
@Audited
public class FeriasMovimento
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String WHERE_FIND_PERIODO = "((m.gozoInicio between :primeiro_dia and :ultimo_dia) or (m.gozoFim between :primeiro_dia and :ultimo_dia) or (m.gozoInicio < :primeiro_dia and m.gozoFim > :ultimo_dia))";
    public static final String FIND_BY_TRABALHADOR_FOR_MOVIMENTOVO = "SELECT NEW br.com.fiorilli.sipweb.vo.MovimentoVo('1', '', '', '', m.gozoInicio, m.gozoFim, CONCAT('Gozo de F\u00e9rias', CASE WHEN COALESCE(m.pagamentoDias, 0) > 0 THEN CONCAT('/Dias Pagto:', m.pagamentoDias) ELSE '' END, CASE WHEN COALESCE(m.diasAbono, 0) > 0 THEN CONCAT('Dias Abono:', m.diasAbono) ELSE '' END, CASE WHEN m.apenasAbono = 'S' THEN ' (Apenas Abono:Sim)' ELSE '(Apenas Abono:N\u00e3o)' END, CASE WHEN m.apenasTerco = 'S' THEN ' (Apenas 1/3: Sim)' ELSE ' (Apenas 1/3: N\u00e3o)' END), '',  CONCAT('Per\u00edodo Aquisitivo: ', YEAR(f.aquisitivoInicio), ' - ',  YEAR(f.aquisitivoFim)), 0, '', m.tipoLegal, m.numeroDocumento, m.dataDocumento) FROM FeriasMovimento m LEFT JOIN m.ferias f WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK and ((m.gozoInicio between :periodoInicio and :periodoFim) or (m.gozoFim between :periodoInicio and :periodoFim) or (m.gozoInicio < :periodoInicio and m.gozoFim > :periodoFim))";
    public static final String IS_TRABALHADOR_EM_FERIAS = "SELECT CASE WHEN COALESCE(COUNT(m.feriasMovimentoPK.registro), 0) > 0 THEN TRUE ELSE FALSE END FROM FeriasMovimento m where m.trabalhador.documentosPessoais.cpf = :cpf AND CURRENT_DATE BETWEEN m.gozoInicio AND m.gozoFim";
    public static final String FIND_BY_TRABALHADOR_FERIAS = "select m from FeriasMovimento m where m.trabalhador.trabalhadorPK = :trabalhadorPK and m.feriasMovimentoPK.ferias = :feriasCodigo order by m.gozoInicio";
    public static final String GET_NEXT_ITEM = "SELECT COALESCE(MAX(m.feriasMovimentoPK.item), 0) + 1 FROM FeriasMovimento m WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK AND m.feriasMovimentoPK.ferias = :feriasCodigo";
    public static final String FIND_BY_DATA = "SELECT m.gozoInicio, m.dataRetorno FROM FeriasMovimento m LEFT JOIN m.cancelaFeriasList c WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK AND (:data >= m.gozoInicio AND :data < COALESCE(c.dataRetorno, m.dataRetorno)) AND NOT COALESCE(c.tipo, 0) IN (3, 1) ";
    public static final String FIND_BY_PERIODO = "select m.gozoInicio as gozoInicio, coalesce(c.dataRetorno, m.gozoFim) as gozoFim, coalesce(c.tipoGozo, 'NORMAL') as tipoGozo from FeriasMovimento m left join m.cancelaFeriasList c where m.trabalhador.trabalhadorPK = :trabalhadorPK and not coalesce(c.tipo, 0) in (3, 1) and ((m.gozoInicio between :primeiro_dia and :ultimo_dia) or (m.gozoFim between :primeiro_dia and :ultimo_dia) or (m.gozoInicio < :primeiro_dia and m.gozoFim > :ultimo_dia))and ((c.dataRetorno between :primeiro_dia and :ultimo_dia) or c.dataRetorno is null)";
    @EmbeddedId
    protected FeriasMovimentoPK feriasMovimentoPK;
    @Size(max=2)
    @Column(name="PAGTOMES")
    private String mesPagamento;
    @Size(max=4)
    @Column(name="PAGTOANO")
    private String anoPagamento;
    @Column(name="GOZOINI")
    @Temporal(value=TemporalType.DATE)
    private Date gozoInicio;
    @Column(name="GOZOFIM")
    @Temporal(value=TemporalType.DATE)
    private Date gozoFim;
    @Column(name="DIASABONO")
    private Short diasAbono;
    @Type(type="BooleanTypeSip")
    @Column(name="APENASABONO")
    private Boolean apenasAbono;
    @Column(name="PAGTODIAS")
    private Short pagamentoDias;
    @Type(type="BooleanTypeSip")
    @Column(name="APENASTERCO")
    private Boolean apenasTerco;
    @Type(type="BooleanTypeSip")
    @Column(name="SOMENTE_RECIBO")
    private Boolean somenteRecibo;
    @Column(name="DTPREVPAG")
    @Temporal(value=TemporalType.DATE)
    private Date dataPagamentoPrevidencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Type(type="BooleanTypeSip")
    @Column(name="CALCULAR_AVOS")
    private Boolean calcularAvos;
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO_FERIAS")
    private Integer codigoFerias;
    @Type(type="BooleanTypeSip")
    @Column(name="CALCULAR_UMTERCO_ABONO")
    private Boolean calcularUmtercoAbono;
    @Column(name="GOZODIAS")
    private Integer gozoDias;
    @Type(type="BooleanTypeSip")
    @Column(name="ADTO13SAL")
    private Boolean adiantamento13Salario;
    @Column(name="DTRETORNO")
    @Temporal(value=TemporalType.DATE)
    private Date dataRetorno;
    @Type(type="BooleanTypeSip")
    @Column(name="EXCLUINDO")
    private Boolean excluindo;
    @OneToOne(mappedBy="feriasMovimento", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, optional=false)
    private FeriasMovimentoColetivoItens feriasMovimentoColetivoItens;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="feriasMovimento", fetch=FetchType.EAGER)
    private List<CancelaFerias> cancelaFeriasList;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", updatable=false, insertable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @JoinColumn(name="REFERENCIA_PAGTO", referencedColumnName="CODIGO", updatable=false, insertable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Referencia referenciaPagamento;
    @Column(name="REFERENCIA_PAGTO")
    private Integer referenciaPagamentoCodigo;
    @JoinColumns(value={@JoinColumn(name="CODIGO_FERIAS", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Ferias ferias;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @OneToOne(mappedBy="feriasMovimento", fetch=FetchType.LAZY, optional=false)
    private FeriasMovimentoLixeira feriasMovimentoLixeira;
    @Transient
    private CancelaFerias cancelaFerias;

    public FeriasMovimento() {
    }

    public FeriasMovimento(FeriasMovimentoPK movtoferiasPK) {
        this.feriasMovimentoPK = movtoferiasPK;
    }

    public FeriasMovimento(FeriasMovimentoPK movtoferiasPK, int codigoFerias) {
        this.feriasMovimentoPK = movtoferiasPK;
        this.codigoFerias = codigoFerias;
    }

    public FeriasMovimento(String entidade, String registro, short ferias, short item) {
        this.feriasMovimentoPK = new FeriasMovimentoPK(entidade, registro, ferias, item);
    }

    public FeriasMovimentoPK getFeriasMovimentoPK() {
        if (this.feriasMovimentoPK == null) {
            this.feriasMovimentoPK = new FeriasMovimentoPK();
        }
        return this.feriasMovimentoPK;
    }

    public void setFeriasMovimentoPK(FeriasMovimentoPK movtoferiasPK) {
        this.feriasMovimentoPK = movtoferiasPK;
    }

    public String getMesPagamento() {
        return this.mesPagamento;
    }

    public void setMesPagamento(String pagtomes) {
        this.mesPagamento = pagtomes;
    }

    public String getAnoPagamento() {
        return this.anoPagamento;
    }

    public void setAnoPagamento(String pagtoano) {
        this.anoPagamento = pagtoano;
    }

    public Date getGozoInicio() {
        return this.gozoInicio;
    }

    public void setGozoInicio(Date gozoInicio) {
        this.gozoInicio = gozoInicio;
    }

    public Date getGozoFim() {
        return this.gozoFim;
    }

    public void setGozoFim(Date gozoFim) {
        this.gozoFim = gozoFim;
    }

    public Short getDiasAbono() {
        return this.diasAbono;
    }

    public void setDiasAbono(Short diasabono) {
        this.diasAbono = diasabono;
    }

    public Short getPagamentoDias() {
        return this.pagamentoDias;
    }

    public void setPagamentoDias(Short pagtodias) {
        this.pagamentoDias = pagtodias;
    }

    public Boolean getApenasAbono() {
        return this.apenasAbono;
    }

    public void setApenasAbono(Boolean apenasabono) {
        this.apenasAbono = apenasabono;
    }

    public Boolean getApenasTerco() {
        return this.apenasTerco;
    }

    public void setApenasTerco(Boolean apenasterco) {
        this.apenasTerco = apenasterco;
    }

    public Boolean getSomenteRecibo() {
        return this.somenteRecibo;
    }

    public void setSomenteRecibo(Boolean somenteRecibo) {
        this.somenteRecibo = somenteRecibo;
    }

    public Boolean getCalcularAvos() {
        return this.calcularAvos;
    }

    public void setCalcularAvos(Boolean calcularAvos) {
        this.calcularAvos = calcularAvos;
    }

    public Boolean getCalcularUmtercoAbono() {
        return this.calcularUmtercoAbono;
    }

    public void setCalcularUmtercoAbono(Boolean calcularUmtercoAbono) {
        this.calcularUmtercoAbono = calcularUmtercoAbono;
    }

    public Boolean getAdiantamento13Salario() {
        return this.adiantamento13Salario;
    }

    public void setAdiantamento13Salario(Boolean adto13sal) {
        this.adiantamento13Salario = adto13sal;
    }

    public Date getDataPagamentoPrevidencia() {
        return this.dataPagamentoPrevidencia;
    }

    public void setDataPagamentoPrevidencia(Date dtprevpag) {
        this.dataPagamentoPrevidencia = dtprevpag;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    public Integer getCodigoFerias() {
        return this.codigoFerias;
    }

    public void setCodigoFerias(Integer codigoFerias) {
        this.codigoFerias = codigoFerias;
    }

    public Integer getGozoDias() {
        return this.gozoDias;
    }

    public void setGozoDias(Integer gozodias) {
        this.gozoDias = gozodias;
    }

    public List<CancelaFerias> getCancelaFeriasList() {
        return this.cancelaFeriasList;
    }

    public void setCancelaFeriasList(List<CancelaFerias> cancelaFeriasList) {
        this.cancelaFeriasList = cancelaFeriasList;
    }

    public Referencia getReferenciaPagamento() {
        return this.referenciaPagamento;
    }

    public void setReferenciaPagamento(Referencia referenciaPagto) {
        this.referenciaPagamento = referenciaPagto;
        this.referenciaPagamentoCodigo = referenciaPagto == null ? null : this.referenciaPagamento.getCodigo();
    }

    public Ferias getFerias() {
        return this.ferias;
    }

    public void setFerias(Ferias ferias1) {
        this.ferias = ferias1;
        if (ferias1 != null) {
            this.getFeriasMovimentoPK().setFerias(ferias1.getItem());
            this.setCodigoFerias(ferias1.getCodigo());
        } else {
            this.getFeriasMovimentoPK().setFerias(null);
            this.setCodigoFerias(null);
        }
    }

    public FeriasMovimentoColetivoItens getFeriasMovimentoColetivoItens() {
        return this.feriasMovimentoColetivoItens;
    }

    public FeriasMovimentoLixeira getFeriasMovimentoLixeira() {
        return this.feriasMovimentoLixeira;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.feriasMovimentoPK != null ? this.feriasMovimentoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FeriasMovimento)) {
            return false;
        }
        FeriasMovimento other = (FeriasMovimento)object;
        return (this.feriasMovimentoPK != null || other.feriasMovimentoPK == null) && (this.feriasMovimentoPK == null || this.feriasMovimentoPK.equals(other.feriasMovimentoPK));
    }

    public String toString() {
        return "entity.Movtoferias[ movtoferiasPK=" + this.feriasMovimentoPK + " ]";
    }

    public CancelaFerias getCancelaFerias() {
        if (this.getCancelaFeriasList() != null && this.getCancelaFeriasList().size() > 0) {
            this.cancelaFerias = this.getCancelaFeriasList().get(0);
        }
        return this.cancelaFerias;
    }

    public void setCancelaFerias(CancelaFerias cancelaFerias) {
        this.cancelaFerias = cancelaFerias;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.getFeriasMovimentoPK().setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.getFeriasMovimentoPK().setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.getFeriasMovimentoPK().setEntidade(null);
            this.getFeriasMovimentoPK().setRegistro(null);
        }
    }

    public Date getDataRetorno() {
        return this.dataRetorno;
    }

    public void setDataRetorno(Date dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    public Integer getReferenciaPagamentoCodigo() {
        return this.referenciaPagamentoCodigo;
    }

    public void setReferenciaPagamentoCodigo(Integer referenciaPagamentoCodigo) {
        this.referenciaPagamentoCodigo = referenciaPagamentoCodigo;
    }

    public Boolean getExcluindo() {
        return this.excluindo;
    }

    public void setExcluindo(Boolean excluindo) {
        this.excluindo = excluindo;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = this.tipoLegal != null ? value.getCodigo() : null;
        this.tipoLegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.dataDocumento;
    }

    @Override
    public void setData(Date value) {
        this.dataDocumento = value;
    }

    public static class FeriasMovimentoSql {
        public static final String FIND_BY_ENTIDADE_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "m.feriasMovimentoPK.entidade, " + "m.feriasMovimentoPK.registro, " + "m.gozoInicio, " + "COALESCE(CASE COALESCE(c.tipo, 0) WHEN 2 THEN COALESCE(c.dataRetorno, m.dataRetorno) ELSE m.dataRetorno END - 1, m.gozoFim), " + "'1', " + "'', " + "m.feriasMovimentoPK.entidade||'-'||m.feriasMovimentoPK.ferias||'-'||m.feriasMovimentoPK.item||'-'||m.feriasMovimentoPK.registro, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "0, " + "'') " + "FROM FeriasMovimento m " + "INNER JOIN m.trabalhador t " + "LEFT JOIN m.cancelaFeriasList c " + "where m.feriasMovimentoPK.entidade = :entidadeCodigo " + "AND (m.feriasMovimentoPK.registro = :registro or :registro = '000000') " + "AND ((m.gozoInicio between :periodoInicio and :periodoFim) " + "  or (m.gozoFim between :periodoInicio and :periodoFim) " + "  or (m.gozoInicio < :periodoInicio and m.gozoFim > :periodoFim))" + "AND COALESCE(c.tipo, 0) NOT IN (3, 1) " + "AND ((COALESCE(c.tipo, 0) <> 2) OR ((COALESCE(c.tipo, 0) = 2) AND ((COALESCE(c.dataRetorno, c.datadoc) - 1) > m.gozoInicio))) ";
        public static final String FIND_BY_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "m.feriasMovimentoPK.entidade, " + "m.feriasMovimentoPK.registro, " + "m.gozoInicio, " + "COALESCE(CASE COALESCE(c.tipo, 0) WHEN 2 THEN COALESCE(c.dataRetorno, m.dataRetorno) ELSE  m.dataRetorno END - 1, m.gozoFim), " + "'1', " + "'', " + "m.feriasMovimentoPK.entidade||'-'||m.feriasMovimentoPK.ferias||'-'||m.feriasMovimentoPK.item||'-'||m.feriasMovimentoPK.registro, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "0, " + "'') " + "FROM FeriasMovimento m " + "INNER JOIN m.trabalhador t " + "LEFT JOIN m.cancelaFeriasList c " + "WHERE (m.feriasMovimentoPK.registro = :registro or :registro = '000000') " + "AND ((m.gozoInicio between :periodoInicio and :periodoFim) " + "  or (m.gozoFim between :periodoInicio and :periodoFim) " + "  or (m.gozoInicio < :periodoInicio and m.gozoFim > :periodoFim))" + "AND COALESCE(c.tipo, 0) NOT IN (3, 1) " + "AND ((COALESCE(c.tipo, 0) <> 2) OR ((COALESCE(c.tipo, 0) = 2) AND ((COALESCE(c.dataRetorno, c.datadoc) - 1) > m.gozoInicio))) ";
        public static final String FIND_BY_ENTIDADE_MATRICULA_CONTRATO_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "m.feriasMovimentoPK.entidade, " + "m.feriasMovimentoPK.registro, " + "m.gozoInicio, " + "COALESCE(CASE COALESCE(c.tipo, 0) WHEN 2 THEN COALESCE(c.dataRetorno, m.dataRetorno) ELSE  m.dataRetorno END - 1, m.gozoFim), " + "'1', " + "'', " + "m.feriasMovimentoPK.entidade||'-'||m.feriasMovimentoPK.ferias||'-'||m.feriasMovimentoPK.item||'-'||m.feriasMovimentoPK.registro, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "0, " + "'') " + "FROM FeriasMovimento m " + "INNER JOIN m.trabalhador t " + "LEFT JOIN m.cancelaFeriasList c " + "where m.feriasMovimentoPK.entidade = :entidadeCodigo " + "AND t.matricula = :matricula " + "AND t.contrato = :contrato " + "AND ((m.gozoInicio between :periodoInicio and :periodoFim) " + "  or (m.gozoFim between :periodoInicio and :periodoFim) " + "  or (m.gozoInicio < :periodoInicio and m.gozoFim > :periodoFim))" + "AND COALESCE(c.tipo, 0) NOT IN (3, 1) " + "AND ((COALESCE(c.tipo, 0) <> 2) OR ((COALESCE(c.tipo, 0) = 2) AND ((COALESCE(c.dataRetorno, c.datadoc) - 1) > m.gozoInicio))) ";
    }
}

