/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.FeriasMovimento;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="FERIAS")
@Audited
public class Ferias
implements Serializable {
    public static final String FIND_BY_TRABALHADOR = "SELECT f FROM Ferias f JOIN FETCH f.trabalhador LEFT JOIN FETCH f.movimentoList WHERE f.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY f.aquisitivoInicio DESC";
    public static final String FIND_BY_DATE = "SELECT f FROM Ferias f where f.trabalhador = :trabalhador and :data between f.aquisitivoInicio and f.aquisitivoFim";
    public static final String GENERATOR = "GEN_FERIAS";
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="ITEM")
    private Short item;
    @Column(name="AQUISINI")
    @Temporal(value=TemporalType.DATE)
    private Date aquisitivoInicio;
    @Column(name="AQUISFIM")
    @Temporal(value=TemporalType.DATE)
    private Date aquisitivoFim;
    @Column(name="VENCIDO")
    @Type(type="BooleanTypeSip")
    private Boolean vencido;
    @Column(name="PAGO")
    @Type(type="BooleanTypeSip")
    private Boolean pago;
    @Column(name="AVOS")
    private Short avos;
    @Column(name="FALTAS")
    private Short faltas;
    @Column(name="DIASDIREITO")
    private Short diasDireito;
    @Type(type="BooleanTypeSip")
    @Column(name="PAGAR_AFAST")
    private Boolean pagarAfast;
    @Column(name="DIASGOZADOS")
    private Short diasgozados;
    @Column(name="DIASPAGOS")
    private Short diaspagos;
    @Column(name="DIASPAGTORESTANTE")
    private Short diaspagtorestante;
    @Column(name="DIASGOZORESTANTE")
    private Short diasgozorestante;
    @Column(name="AFAST_01O_MES")
    private Short afast01oMes;
    @Column(name="AFAST_02O_MES")
    private Short afast02oMes;
    @Column(name="AFAST_03O_MES")
    private Short afast03oMes;
    @Column(name="AFAST_04O_MES")
    private Short afast04oMes;
    @Column(name="AFAST_05O_MES")
    private Short afast05oMes;
    @Column(name="AFAST_06O_MES")
    private Short afast06oMes;
    @Column(name="AFAST_07O_MES")
    private Short afast07oMes;
    @Column(name="AFAST_08O_MES")
    private Short afast08oMes;
    @Column(name="AFAST_09O_MES")
    private Short afast09oMes;
    @Column(name="AFAST_10O_MES")
    private Short afast10oMes;
    @Column(name="AFAST_11O_MES")
    private Short afast11oMes;
    @Column(name="AFAST_12O_MES")
    private Short afast12oMes;
    @Column(name="DIASAFAST", updatable=false)
    private Short diasAfastamento;
    @Type(type="BooleanTypeSip")
    @Column(name="CANCELADO")
    private Boolean cancelado;
    @Type(type="BooleanTypeSip")
    @Column(name="EXCLUINDO")
    private Boolean exclusao;
    @Size(max=512)
    @Column(name="OBS")
    private String obs;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Column(name="EMPRESA")
    private String entidade;
    @Column(name="REGISTRO")
    private String registro;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="ferias", fetch=FetchType.LAZY)
    private List<FeriasMovimento> movimentoList;

    public Ferias() {
    }

    public Ferias(int codigo) {
        this.codigo = codigo;
    }

    public int getAvosFromFields() {
        int result = 0;
        if (this.getAfast01oMes() <= 15) {
            ++result;
        }
        if (this.getAfast02oMes() <= 15) {
            ++result;
        }
        if (this.getAfast03oMes() <= 15) {
            ++result;
        }
        if (this.getAfast04oMes() <= 15) {
            ++result;
        }
        if (this.getAfast05oMes() <= 15) {
            ++result;
        }
        if (this.getAfast06oMes() <= 15) {
            ++result;
        }
        if (this.getAfast07oMes() <= 15) {
            ++result;
        }
        if (this.getAfast08oMes() <= 15) {
            ++result;
        }
        if (this.getAfast09oMes() <= 15) {
            ++result;
        }
        if (this.getAfast10oMes() <= 15) {
            ++result;
        }
        if (this.getAfast11oMes() <= 15) {
            ++result;
        }
        if (this.getAfast12oMes() <= 15) {
            ++result;
        }
        return result;
    }

    public Date getAquisitivoInicio() {
        return this.aquisitivoInicio;
    }

    public void setAquisitivoInicio(Date aquisitivoInicio) {
        this.aquisitivoInicio = aquisitivoInicio;
    }

    public Date getAquisitivoFim() {
        return this.aquisitivoFim;
    }

    public void setAquisitivoFim(Date aquisitivoFim) {
        this.aquisitivoFim = aquisitivoFim;
    }

    public Boolean getVencido() {
        return this.vencido;
    }

    public void setVencido(Boolean vencido) {
        this.vencido = vencido;
    }

    public Boolean getPago() {
        return this.pago;
    }

    public void setPago(Boolean pago) {
        this.pago = pago;
    }

    public Short getAvos() {
        return this.avos;
    }

    public void setAvos(Short avos) {
        this.avos = avos;
    }

    public Short getFaltas() {
        return this.faltas;
    }

    public void setFaltas(Short i) {
        this.faltas = i;
    }

    public Short getDiasDireito() {
        return this.diasDireito;
    }

    public void setDiasDireito(Short diasdireito) {
        this.diasDireito = diasdireito;
    }

    public Boolean getPagarAfast() {
        return this.pagarAfast;
    }

    public void setPagarAfast(Boolean pagarAfast) {
        this.pagarAfast = pagarAfast;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Short getDiasgozados() {
        return this.diasgozados;
    }

    public void setDiasgozados(Short diasgozados) {
        this.diasgozados = diasgozados;
    }

    public Short getDiaspagos() {
        return this.diaspagos;
    }

    public void setDiaspagos(Short diaspagos) {
        this.diaspagos = diaspagos;
    }

    public Short getDiaspagtorestante() {
        return this.diaspagtorestante;
    }

    public void setDiaspagtorestante(Short diaspagtorestante) {
        this.diaspagtorestante = diaspagtorestante;
    }

    public Short getDiasgozorestante() {
        return this.diasgozorestante;
    }

    public void setDiasgozorestante(Short diasgozorestante) {
        this.diasgozorestante = diasgozorestante;
    }

    public Short getAfast01oMes() {
        return this.afast01oMes;
    }

    public void setAfast01oMes(Short afast01oMes) {
        this.afast01oMes = afast01oMes;
    }

    public Short getAfast02oMes() {
        return this.afast02oMes;
    }

    public void setAfast02oMes(Short afast02oMes) {
        this.afast02oMes = afast02oMes;
    }

    public Short getAfast03oMes() {
        return this.afast03oMes;
    }

    public void setAfast03oMes(Short afast03oMes) {
        this.afast03oMes = afast03oMes;
    }

    public Short getAfast04oMes() {
        return this.afast04oMes;
    }

    public void setAfast04oMes(Short afast04oMes) {
        this.afast04oMes = afast04oMes;
    }

    public Short getAfast05oMes() {
        return this.afast05oMes;
    }

    public void setAfast05oMes(Short afast05oMes) {
        this.afast05oMes = afast05oMes;
    }

    public Short getAfast06oMes() {
        return this.afast06oMes;
    }

    public void setAfast06oMes(Short afast06oMes) {
        this.afast06oMes = afast06oMes;
    }

    public Short getAfast07oMes() {
        return this.afast07oMes;
    }

    public void setAfast07oMes(Short afast07oMes) {
        this.afast07oMes = afast07oMes;
    }

    public Short getAfast08oMes() {
        return this.afast08oMes;
    }

    public void setAfast08oMes(Short afast08oMes) {
        this.afast08oMes = afast08oMes;
    }

    public Short getAfast09oMes() {
        return this.afast09oMes;
    }

    public void setAfast09oMes(Short afast09oMes) {
        this.afast09oMes = afast09oMes;
    }

    public Short getAfast10oMes() {
        return this.afast10oMes;
    }

    public void setAfast10oMes(Short afast10oMes) {
        this.afast10oMes = afast10oMes;
    }

    public Short getAfast11oMes() {
        return this.afast11oMes;
    }

    public void setAfast11oMes(Short afast11oMes) {
        this.afast11oMes = afast11oMes;
    }

    public Short getAfast12oMes() {
        return this.afast12oMes;
    }

    public void setAfast12oMes(Short afast12oMes) {
        this.afast12oMes = afast12oMes;
    }

    public Short getDiasAfastamento() {
        return this.diasAfastamento;
    }

    public void setDiasAfastamento(Short diasafast) {
        this.diasAfastamento = diasafast;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
            this.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
        } else {
            this.setRegistro(null);
            this.setEntidade(null);
        }
    }

    public List<FeriasMovimento> getMovimentoList() {
        return this.movimentoList;
    }

    public void setMovimentoList(List<FeriasMovimento> movtoferiasList) {
        this.movimentoList = movtoferiasList;
    }

    public Short getItem() {
        return this.item;
    }

    public void setItem(Short item) {
        this.item = item;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ferias other = (Ferias)obj;
        return this.codigo == other.codigo;
    }

    public String toString() {
        return "Ferias [codigo=" + this.codigo + "]";
    }

    public Boolean getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    public Boolean getExclusao() {
        return this.exclusao;
    }

    public void setExclusao(Boolean exclusao) {
        this.exclusao = exclusao;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }
}

