/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="FERIADOS")
@Audited
public class Feriado
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_FERIADOS";
    public static final String FIND_ALL = "SELECT f FROM Feriado f ORDER BY f.mes, f.dia";
    public static final String FIND_BY_PERIODO = "SELECT f FROM Feriado f WHERE (f.mes >= :mesInicial AND f.dia >= :diaInicial) OR (f.mes <= :mesFinal AND f.dia <= :diaFinal) ORDER BY f.mes, f.dia";
    public static final String COUNT_BY_PERIODO = "SELECT COALESCE(COUNT(f), 0) FROM Feriado f WHERE concat(f.mes, f.dia) between concat(:mesInicial, :diaInicial) and concat(:mesFinal, :diaFinal) ";
    public static final String FIND_BY_DIA_MES = "SELECT f FROM Feriado f WHERE f.dia = :dia AND f.mes = :mes ";
    @Id
    @Column(name="ID")
    private int id;
    @FilterConfig(label="M\u00eas", inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigEnum(enumClass=MesNomeEnum.class, enumId="codigo", itemLabel="nome")
    @Basic(optional=false)
    @NotNull
    @Column(name="MES")
    private String mes;
    @FilterConfig(label="Dia", inputType=FilterInputType.NUMBER)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="DIA")
    private String dia;
    @FilterConfig(label="Motivo", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="MOTIVO")
    private String motivo;

    public Feriado() {
    }

    public Feriado(int codigo) {
        this.id = codigo;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int codigo) {
        this.id = codigo;
    }

    public MesNomeEnum getMes() {
        if (this.mes == null) {
            return null;
        }
        return MesNomeEnum.of(this.mes);
    }

    public void setMes(MesNomeEnum mes) {
        this.mes = mes == null ? null : mes.getCodigo();
    }

    public String getDia() {
        return this.dia;
    }

    public void setDia(String dia) {
        this.dia = dia;
    }

    public Integer getMesAsInteger() {
        return StringUtils.isEmpty((CharSequence)this.mes) ? null : Integer.valueOf(Integer.parseInt(this.mes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feriado other = (Feriado)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "Feriado(id=" + this.id + ", mes=" + this.mes + ", dia=" + this.dia + ", motivo=" + this.motivo + ")";
    }
}

