/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.FaltaTipo;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="FALTAS_DEVOLUCAO")
@Audited
public class FaltaDevolucao
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_EVENTUAIS";
    @Id
    @Column(unique=true, nullable=false)
    private Integer codigo;
    @FilterConfig(label="Ano Pagamento", mask="9999", order=1)
    @Column(name="ANO_PAGTO", length=4)
    private String anoPagamento;
    @FilterConfig(label="Data Fim", inputType=FilterInputType.CALENDAR, condition=FilterCondition.MAIOR_IGUAL, order=4)
    @Temporal(value=TemporalType.DATE)
    @Column(name="DTFIM", nullable=false)
    private Date dataFim;
    @FilterConfig(label="Data In\u00edcio", inputType=FilterInputType.CALENDAR, condition=FilterCondition.MAIOR_IGUAL, order=3)
    @Temporal(value=TemporalType.DATE)
    @Column(name="DTINICIO", nullable=false)
    private Date dataInicio;
    @Column(name="EMPRESA", nullable=false, length=3)
    private String entidadeCodigo;
    @Column(name="EVENTO", length=3)
    private String eventoCodigo;
    @FilterConfig(label="M\u00eas Pagamento", mask="99", order=2)
    @Column(name="MES_PAGTO", length=2)
    private String mesPagamento;
    @Column(length=256)
    private String motivo;
    @Column(nullable=false, length=6)
    private String registro;
    @Column(name="TIPO_FALTA", nullable=false)
    private Integer tipoFalta;
    @Column(name="VALOR")
    private Double valor;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento evento;

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getAnoPagamento() {
        return this.anoPagamento;
    }

    public void setAnoPagamento(String anoPagamento) {
        this.anoPagamento = anoPagamento;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String empresa) {
        this.entidadeCodigo = empresa;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String evento) {
        this.eventoCodigo = evento;
    }

    public String getMesPagamento() {
        return this.mesPagamento;
    }

    public void setMesPagamento(String mesPagamento) {
        this.mesPagamento = mesPagamento;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public FaltaTipo getTipoFalta() {
        return FaltaTipo.get(this.tipoFalta);
    }

    public void setTipoFalta(FaltaTipo tipoFalta) {
        this.tipoFalta = tipoFalta.getCodigo();
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FaltaDevolucao other = (FaltaDevolucao)obj;
        return this.codigo == other.codigo;
    }

    public String toString() {
        return "FaltaDevolucao [codigo=" + this.codigo + "]";
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
            this.entidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
        } else {
            this.registro = null;
            this.entidadeCodigo = null;
        }
        this.trabalhador = trabalhador;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.evento = evento;
    }
}

