/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.MesAno;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sipweb.vo.FrequenciaVO;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;

@Entity
@Table(name="FALTAS")
@FilterConfigType(autoFilter=true, rootEntityAlias="fa", query="SELECT $R{[fa.id], [fa]} FROM Falta fa LEFT JOIN FETCH fa.evento ev LEFT JOIN FETCH fa.trabalhador tr WHERE $P{[evento], [ev], [:evento]}    AND $P{[trabalhador], [tr], [:trabalhador]}    AND $P{[cargo], [tr.cargoAtual], [:cargo]}    AND $P{[data], [fa.data], [:data]} ", displayField=4)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Trabalhador.class, id="trabalhador", label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo", order=3), @FilterConfigParameter(fieldClass=Evento.class, id="evento", label="Evento", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome", order=2), @FilterConfigParameter(fieldClass=Cargo.class, id="cargo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome", order=4), @FilterConfigParameter(fieldClass=Date.class, id="data", label="Data", condition=FilterCondition.INTERVALO, inputType=FilterInputType.CALENDAR, order=1)})
@Audited
public class Falta
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_FOR_FILTER = "SELECT $R{[fa.id], [fa]} FROM Falta fa LEFT JOIN FETCH fa.evento ev LEFT JOIN FETCH fa.trabalhador tr WHERE $P{[evento], [ev], [:evento]}    AND $P{[trabalhador], [tr], [:trabalhador]}    AND $P{[cargo], [tr.cargoAtual], [:cargo]}    AND $P{[data], [fa.data], [:data]} ";
    public static final String FIND_BY_PERIODO = "select distinct fa.eventoCodigo as eventoCodigo, ev.nome as eventoNome, fa.data as data, fa.data + trunc(coalesce(fa.dias - 1, 0)) as dataFinal from Falta fa left join fa.evento ev where fa.entidadeCodigo = :entidade and fa.registro = :registro  and ev.classificacao IN (:classificacoes) and ((fa.data between :dataInicial and :dataFinal)    or (fa.data + trunc(coalesce(fa.dias - 1, 0)) between :dataInicial and :dataFinal)    or ((fa.data < :dataInicial) and (fa.data + trunc(coalesce(fa.dias - 1, 0)) > :dataFinal))) ";
    public static final String IS_TRABALHADOR_EM_FALTA_ABONADA = "SELECT CASE WHEN COALESCE(COUNT(f.registro), 0) > 0 THEN TRUE ELSE FALSE END FROM Falta f LEFT JOIN f.evento ev WHERE f.trabalhador.documentosPessoais.cpf = :cpf AND CURRENT_DATE = f.data AND ev.classificacao IN ('07', '23')";
    public static final String FIND_BY_DATA_AND_CLASSIFICACAO_05_06_07_23 = "SELECT ev.eventoPK.codigo AS eventoCodigo, ev.nome AS eventoNome, fa.data AS data FROM Falta fa LEFT JOIN fa.evento ev WHERE fa.trabalhador.trabalhadorPK = :trabalhadorPK    and :data between fa.data and (fa.data + trunc(coalesce(fa.dias - 1, 0))) AND ev.classificacao IN ('05', '06', '07', '23') ORDER BY ev.eventoPK.codigo";
    public static final String VALIDATE_QUANTIDADE_HORAS_AND_HORAS_EFETIVAS = "SELECT COALESCE(SUM(fa.horasLancamento), 0.0) FROM Falta fa LEFT JOIN fa.trabalhador tr WHERE tr.trabalhadorPK = :trabalhadorPK AND fa.data = :data";
    public static final String GET_TOTAL_FALTAS_ABONADAS = "SELECT COALESCE(COUNT(fa.registro), 0) FROM Falta fa LEFT JOIN fa.trabalhador tr LEFT JOIN fa.evento ev WHERE tr.trabalhadorPK = :trabalhadorPK    AND ev.classificacao IN ('07', '23')    AND fa.ano = :ano    AND (:mes = '00' OR fa.mes = :mes)";
    public static final String GET_FALTAS_ABONADAS_SOLICITACAO = "SELECT fa FROM Falta fa LEFT JOIN FETCH fa.trabalhador tr LEFT JOIN fa.evento ev WHERE tr.trabalhadorPK = :trabalhadorPK    AND ev.classificacao IN ('07', '23')    AND fa.ano = :ano   AND ((fa.protocoloSolicitacao is null) OR (trim(fa.protocoloSolicitacao) = ''))";
    public static final String GET_FETCHED = "SELECT f FROM Falta f LEFT JOIN FETCH f.trabalhador t LEFT JOIN FETCH t.vinculo v LEFT JOIN FETCH f.evento e WHERE f.entidadeCodigo = :entidadeCodigo AND f.id = :id ";
    public static final String FIND_BY_ENTIDADE_REGISTRO_EVENTOS_AS_PONTO_EVENTO = "SELECT new br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra.PontoEventoVO (f.data, e.eventoPK.codigo, e.nome, f.horasLancamentoMillis)    FROM Falta f   INNER JOIN f.evento e    INNER JOIN f.trabalhador t \tWHERE f.entidadeCodigo = :entidadeCodigo \tAND f.registro = :registro \tAND f.evento IN (:eventos) \tAND ((t.ponto.dataImplantacaoCartao IS NOT NULL AND f.data >= t.ponto.dataImplantacaoCartao) OR (t.ponto.dataImplantacaoCartao IS NULL AND f.data IS NOT NULL)) \tAND f.data <= :dataLimite    ORDER BY f.data, e.eventoPK.codigo ASC ";
    @Id
    private int id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Column(name="QTDEHORAS")
    private Double quantidadeHoras;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="MOTIVO")
    private String motivo;
    @Column(name="DIAS")
    private Double dias;
    @Column(name="DEPDESPESA")
    private Integer unidadeCodigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES")
    private String mes;
    @Type(type="BooleanTypeSip")
    @Column(name="APENAS_CONTROLE_FREQUENCIA")
    private Boolean apenasControleFrequencia;
    @Column(name="IDSIE")
    private Integer sieID;
    @Column(name="HORAS_LANCTO")
    private Double horasLancamento;
    @Type(type="DoubleAsMillis")
    @Column(name="HORAS_LANCTO", insertable=false, updatable=false)
    private Long horasLancamentoMillis;
    @Column(name="USUARIO")
    private Integer codigoUsuario;
    @JoinColumn(name="DEPDESPESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade unidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Type(type="BooleanTypeSip")
    @Column(name="MEIO_DIA")
    private Boolean meioDia;
    @Column(name="PERIODO")
    private Integer meioDiaPeriodo;
    @Column(name="PROTOCOLO_SOLICITACAO")
    private String protocoloSolicitacao;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DT_INCLUSAO")
    private Date dataInclusao;

    public Falta() {
    }

    public Falta(Builder builder) {
        this.entidadeCodigo = builder.entidadeCodigo;
        this.registro = builder.registro;
        this.eventoCodigo = builder.eventoCodigo;
        this.data = builder.data;
        this.quantidadeHoras = builder.quantidadeHoras;
        this.motivo = builder.motivo;
        this.dias = builder.dias;
        this.unidadeCodigo = builder.unidadeCodigo;
        this.ano = builder.ano;
        this.mes = builder.mes;
        this.apenasControleFrequencia = builder.apenasControleFrequencia;
        this.sieID = builder.sieID;
        this.horasLancamento = builder.horasLancamento;
        this.horasLancamentoMillis = builder.horasLancamentoMillis;
        this.trabalhador = builder.trabalhador;
        this.evento = builder.evento;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public final String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public final void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public final String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public final void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public MesAno getMesAno() {
        return new MesAno(this.getMes(), this.getAno());
    }

    public void setMesAno(MesAno value) {
        this.setMes(value.getMesStr());
        this.setAno(value.getAnoStr());
    }

    public Double getQuantidadeHoras() {
        return this.quantidadeHoras;
    }

    public void setQuantidadeHoras(Double qtdehoras) {
        this.quantidadeHoras = qtdehoras;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public Double getDias() {
        return this.dias;
    }

    public void setDias(Double dias) {
        this.dias = dias;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes.length() == 1 ? "0" + mes : mes;
    }

    public Integer getSieID() {
        return this.sieID;
    }

    public void setSieID(Integer idsie) {
        this.sieID = idsie;
    }

    public Double getHorasLancamento() {
        return this.horasLancamento;
    }

    public void setHorasLancamento(Double horasLancto) {
        this.horasLancamento = horasLancto;
    }

    public String getHorasLancamentoLiteral() {
        return TimeUtils.toStringTime((Double)this.horasLancamento);
    }

    public void setHorasLancamento(String horasLancto) {
        this.horasLancamento = StringUtils.isBlank((CharSequence)horasLancto) ? null : Double.valueOf(horasLancto.replace(":", "."));
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade unidade) {
        this.unidadeCodigo = unidade != null ? unidade.getCodigo() : null;
        this.unidade = unidade;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
            this.setEntidadeCodigo(trabalhador.getTrabalhadorPK().getEntidade());
        } else {
            this.setRegistro(null);
            this.setEntidadeCodigo(null);
        }
        this.trabalhador = trabalhador;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.setEventoCodigo(evento.getEventoPK().getCodigo());
            this.setApenasControleFrequencia(evento.getApenasFrequencia());
        } else {
            this.setEventoCodigo(null);
        }
        this.evento = evento;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade1) {
        this.entidade = entidade1;
    }

    public Integer getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public void setUnidadeCodigo(Integer unidadeCodigo) {
        this.unidadeCodigo = unidadeCodigo;
    }

    public Boolean getApenasControleFrequencia() {
        return this.apenasControleFrequencia;
    }

    public void setApenasControleFrequencia(Boolean apenasControleFrequencia) {
        this.apenasControleFrequencia = apenasControleFrequencia;
    }

    public Boolean getMeioDia() {
        return this.meioDia;
    }

    public void setMeioDia(Boolean meioDia) {
        this.meioDia = meioDia;
    }

    public Integer getMeioDiaPeriodo() {
        return this.meioDiaPeriodo;
    }

    public void setMeioDiaPeriodo(Integer meioDiaPeriodo) {
        this.meioDiaPeriodo = meioDiaPeriodo;
    }

    public String getProtocoloSolicitacao() {
        return this.protocoloSolicitacao;
    }

    public void setProtocoloSolicitacao(String protocoloSolicitacao) {
        this.protocoloSolicitacao = protocoloSolicitacao;
    }

    public Long getHorasLancamentoMillis() {
        return this.horasLancamentoMillis;
    }

    public Date getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(Date dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Falta other = (Falta)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "id: " + this.id;
    }

    public Falta ofData(Date dataDaFalta) {
        Falta falta = new Falta();
        falta.id = this.id;
        falta.ano = this.ano;
        falta.apenasControleFrequencia = this.apenasControleFrequencia;
        falta.data = dataDaFalta;
        falta.dias = 1.0;
        falta.entidadeCodigo = this.entidadeCodigo;
        falta.eventoCodigo = this.eventoCodigo;
        falta.horasLancamento = this.horasLancamento;
        falta.mes = this.mes;
        falta.motivo = this.motivo;
        falta.quantidadeHoras = this.quantidadeHoras;
        falta.registro = this.registro;
        falta.sieID = this.sieID;
        falta.unidadeCodigo = this.unidadeCodigo;
        falta.evento = this.evento;
        return falta;
    }

    public Integer getCodigoUsuario() {
        return this.codigoUsuario;
    }

    public void setCodigoUsuario(Integer codigoUsuario) {
        this.codigoUsuario = codigoUsuario;
    }

    public static class FaltaSql {
        public static final String FIND_BY_ENTIDADE_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "fa.entidadeCodigo, " + "fa.registro, " + "fa.data, " + "fa.dias, " + "'3', " + "'', " + "fa.entidadeCodigo||'-'||fa.registro||'-'||fa.eventoCodigo||'-'||fa.data, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "fa.horasLancamento, " + "ev.eventoPK.codigo, " + "ev.nome, " + "0, " + "''," + "fa.meioDia," + "fa.meioDiaPeriodo) " + "FROM Falta fa " + "JOIN fa.evento ev " + "INNER JOIN fa.trabalhador t " + "WHERE fa.entidadeCodigo = :entidadeCodigo " + "   AND (fa.registro = :registro or :registro = '000000') " + "   AND ev.classificacao in('05','06','07','23','47') " + "   AND fa.data BETWEEN :periodoInicio AND :periodoFim ";
        public static final String FIND_BY_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "fa.entidadeCodigo, " + "fa.registro, " + "fa.data, " + "fa.dias, " + "'3', " + "'', " + "fa.entidadeCodigo||'-'||fa.registro||'-'||fa.eventoCodigo||'-'||fa.data, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "fa.horasLancamento, " + "ev.eventoPK.codigo, " + "ev.nome, " + "0, " + "'', " + "fa.meioDia, " + "fa.meioDiaPeriodo) " + "FROM Falta fa " + "JOIN fa.evento ev " + "INNER JOIN fa.trabalhador t " + "WHERE (fa.registro = :registro or :registro = '000000') " + "   AND ev.classificacao in('05','06','07','23','47') " + "   AND fa.data BETWEEN :periodoInicio AND :periodoFim ";
        public static final String FIND_BY_ENTIDADE_MATRICULA_CONTRATO_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "fa.entidadeCodigo, " + "fa.registro, " + "fa.data, " + "fa.dias, " + "'3', " + "'', " + "fa.entidadeCodigo||'-'||fa.registro||'-'||fa.eventoCodigo||'-'||fa.data, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "fa.horasLancamento, " + "ev.eventoPK.codigo, " + "ev.nome, " + "0, " + "'', " + "fa.meioDia, " + "fa.meioDiaPeriodo) " + "FROM Falta fa " + "JOIN fa.evento ev " + "INNER JOIN fa.trabalhador t " + "WHERE fa.entidadeCodigo = :entidadeCodigo " + "   AND t.matricula = :matricula " + "   AND t.contrato = :contrato " + "   AND ev.classificacao in('05','06','07','23','47') " + "   AND fa.data BETWEEN :periodoInicio AND :periodoFim ";
    }

    public static class Builder {
        private String entidadeCodigo;
        private String registro;
        private String eventoCodigo;
        private Date data;
        private Double quantidadeHoras;
        private String motivo;
        private Double dias;
        private Integer unidadeCodigo;
        private String ano;
        private String mes;
        private Boolean apenasControleFrequencia;
        private Integer sieID;
        private Double horasLancamento;
        private Long horasLancamentoMillis;
        private Trabalhador trabalhador;
        private Evento evento;

        public Falta build() {
            return new Falta(this);
        }

        public Builder comEntidadeCodigo(String entidadeCodigo) {
            this.entidadeCodigo = entidadeCodigo;
            return this;
        }

        public Builder comRegistro(String registro) {
            this.registro = registro;
            return this;
        }

        public Builder comEventoCodigo(String eventoCodigo) {
            this.eventoCodigo = eventoCodigo;
            return this;
        }

        public Builder comData(Date data) {
            this.data = data;
            return this;
        }

        public Builder comQuantidadeHoras(Double quantidadeHoras) {
            this.quantidadeHoras = quantidadeHoras;
            return this;
        }

        public Builder comMotivo(String motivo) {
            this.motivo = motivo;
            return this;
        }

        public Builder comDias(Double dias) {
            this.dias = dias;
            return this;
        }

        public Builder comUnidadeCodigo(Integer unidadeCodigo) {
            this.unidadeCodigo = unidadeCodigo;
            return this;
        }

        public Builder comAno(String ano) {
            this.ano = ano;
            return this;
        }

        public Builder comMes(String mes) {
            this.mes = mes;
            return this;
        }

        public Builder comApenasControleFrequencia(Boolean apenasControleFrequencia) {
            this.apenasControleFrequencia = apenasControleFrequencia;
            return this;
        }

        public Builder comSieID(Integer sieID) {
            this.sieID = sieID;
            return this;
        }

        public Builder comHorasLancamento(Double horasLancamento) {
            this.horasLancamento = horasLancamento;
            return this;
        }

        public Builder comHorasLancamentoMillis(Long horasLancamentoMillis) {
            this.horasLancamentoMillis = horasLancamentoMillis;
            return this;
        }

        public Builder comTrabalhador(Trabalhador trabalhador) {
            this.trabalhador = trabalhador;
            return this;
        }

        public Builder comEvento(Evento evento) {
            this.evento = evento;
            return this;
        }
    }
}

