/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoFolhaComplementar;
import br.com.fiorilli.sip.persistence.entity.Eventuais;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="EVENTUAIS_MASSA")
@Audited
public class EventuaisMassa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="DATAHORA")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date datahora;
    @Column(name="TIPOFOLHA")
    private Short tipofolha;
    @Column(name="DTLANCTO")
    @Temporal(value=TemporalType.DATE)
    private Date dtlancto;
    @Column(name="QTDE")
    private Double qtde;
    @Column(name="VALOR")
    private Double valor;
    @Column(name="PERCENTUAL")
    private Double percentual;
    @Size(max=7)
    @Column(name="REFERENCIA")
    private String referencia;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="ESCOPO")
    private String escopo;
    @JoinTable(name="EVENTUAIS_MASSA_EVCOMPL", joinColumns={@JoinColumn(name="CODMASSA")}, inverseJoinColumns={@JoinColumn(name="ID_EV_FOLHACOMPL")})
    @OneToMany(fetch=FetchType.LAZY)
    private List<EventoFolhaComplementar> eventosFolhacomplList;
    @ManyToMany(mappedBy="eventuaisMassaList", fetch=FetchType.LAZY)
    private List<Eventuais> eventuaisList;
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Usuario usuario;
    @JoinColumn(name="DEPDESPESA", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade depdespesa;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA"), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO")})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento eventos;

    public EventuaisMassa() {
    }

    public EventuaisMassa(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDatahora() {
        return this.datahora;
    }

    public void setDatahora(Date datahora) {
        this.datahora = datahora;
    }

    public Short getTipofolha() {
        return this.tipofolha;
    }

    public void setTipofolha(Short tipofolha) {
        this.tipofolha = tipofolha;
    }

    public Date getDtlancto() {
        return this.dtlancto;
    }

    public void setDtlancto(Date dtlancto) {
        this.dtlancto = dtlancto;
    }

    public Double getQtde() {
        return this.qtde;
    }

    public void setQtde(Double qtde) {
        this.qtde = qtde;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public Double getPercentual() {
        return this.percentual;
    }

    public void setPercentual(Double percentual) {
        this.percentual = percentual;
    }

    public String getReferencia() {
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    public String getEscopo() {
        return this.escopo;
    }

    public void setEscopo(String escopo) {
        this.escopo = escopo;
    }

    public List<EventoFolhaComplementar> getEventosFolhacomplList() {
        return this.eventosFolhacomplList;
    }

    public void setEventosFolhacomplList(List<EventoFolhaComplementar> eventosFolhacomplList) {
        this.eventosFolhacomplList = eventosFolhacomplList;
    }

    public List<Eventuais> getEventuaisList() {
        return this.eventuaisList;
    }

    public void setEventuaisList(List<Eventuais> eventuaisList) {
        this.eventuaisList = eventuaisList;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public Unidade getDepdespesa() {
        return this.depdespesa;
    }

    public void setDepdespesa(Unidade depdespesa) {
        this.depdespesa = depdespesa;
    }

    public Evento getEventos() {
        return this.eventos;
    }

    public void setEventos(Evento eventos) {
        this.eventos = eventos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventuaisMassa)) {
            return false;
        }
        EventuaisMassa other = (EventuaisMassa)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.EventuaisMassa[ codigo=" + this.codigo + " ]";
    }
}

