/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.SituacaoEventuaisExternos;
import br.com.fiorilli.sip.persistence.entity.TipoLancamentoEventuaisExterno;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="EVENTUAIS_EXTERNO")
@Audited
public class EventuaisExterno
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private Integer id;
    private String observacao;
    @Enumerated
    @Column(name="TIPO_LANCAMENTO")
    private TipoLancamentoEventuaisExterno tipoLancamento;
    private Double valor;
    @Enumerated
    private SituacaoEventuaisExternos situacao;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESAEVENTO")
    private String eventoEntidadeCodigo;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESAEVENTO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento evento;
    @FilterConfig(label="Data")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESATRABALHADOR")
    private String trabalhadorEntidadeCodigo;
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESATRABALHADOR", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @Column(name="USUARIO")
    private Integer usuarioCodigo;
    @ManyToOne
    @JoinColumn(name="USUARIO", insertable=false, updatable=false)
    private Usuario usuario;
    @Column(name="REFERENCIA_TIPO")
    private String referenciaTipo;

    public void validaTipoLancamento() throws Exception {
        if (this.evento.isFalta() && this.getTipoLancamento() != TipoLancamentoEventuaisExterno.HORA && this.getTipoLancamento() != TipoLancamentoEventuaisExterno.DIA) {
            throw new Exception("Tipo de Lan\u00e7amento Incompat\u00edvel com a Classificass\u00e3o do Evento. Faltas podem ser em dias ou em horas");
        }
        if (!(this.evento.isFalta() || this.getTipoLancamento() != TipoLancamentoEventuaisExterno.HORA && this.getTipoLancamento() != TipoLancamentoEventuaisExterno.DIA)) {
            throw new Exception("Tipo de Lan\u00e7amento Incompat\u00edvel com a Classificass\u00e3o do Evento. Eventos diferentes de Faltas n\u00e3o podem ser em dias nem em horas");
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.eventoEntidadeCodigo = evento.getEventoPK().getEntidade();
            this.eventoCodigo = evento.getEventoPK().getCodigo();
        } else {
            this.eventoEntidadeCodigo = null;
            this.eventoCodigo = null;
        }
        this.evento = evento;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.trabalhadorEntidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.trabalhadorEntidadeCodigo = null;
            this.registro = null;
        }
        this.trabalhador = trabalhador;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuarioCodigo = usuario != null ? usuario.getCodigo() : null;
        this.usuario = usuario;
    }

    public String getMes() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.data);
        String mes = Integer.valueOf(cal.get(2) + 1).toString();
        if (mes.length() == 1) {
            mes = "0" + mes;
        }
        return mes;
    }

    public String getAno() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.data);
        return Integer.valueOf(cal.get(1)).toString();
    }

    public String getDias() {
        return null;
    }

    public TipoLancamentoEventuaisExterno getTipoLancamento() {
        return this.tipoLancamento;
    }

    public void setTipoLancamento(TipoLancamentoEventuaisExterno tipoLancamento) {
        this.tipoLancamento = tipoLancamento;
    }

    public SituacaoEventuaisExternos getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SituacaoEventuaisExternos situacao) {
        this.situacao = situacao;
    }

    public ReferenciaTipo getReferenciaTipo() {
        return ReferenciaTipo.get(this.referenciaTipo);
    }

    public void setReferenciaTipo(ReferenciaTipo referenciaTipo) {
        this.referenciaTipo = referenciaTipo != null ? referenciaTipo.getCodigo() : null;
    }

    public String getEventoEntidadeCodigo() {
        return this.eventoEntidadeCodigo;
    }

    public void setEventoEntidadeCodigo(String eventoEntidadeCodigo) {
        this.eventoEntidadeCodigo = eventoEntidadeCodigo;
    }

    public String getTrabalhadorEntidadeCodigo() {
        return this.trabalhadorEntidadeCodigo;
    }

    public void setTrabalhadorEntidadeCodigo(String trabalhadorEntidadeCodigo) {
        this.trabalhadorEntidadeCodigo = trabalhadorEntidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public static class EventuaisExternoSql {
        public static final String FIND_BY_TRABALHADOR_REF = "SELECT NEW br.com.fiorilli.sipweb.vo.EventualExternoVo(e.id, ev.nome, t.nome, c.nome, e.data, e.valor, e.tipoLancamento, e.situacao, e.observacao, t.dataAdmissao) FROM EventuaisExterno e JOIN e.trabalhador t JOIN e.evento ev JOIN t.cargoAtual c WHERE t.trabalhadorPK.entidade = coalesce(:entidadeCodigo, t.trabalhadorPK.entidade) and t.trabalhadorPK.registro = coalesce(:registro, t.trabalhadorPK.registro) and e.data BETWEEN :dataInicio AND :dataFim ORDER BY e.data, t.nome";
        public static final String FIND_BY_REFERENCIA = "SELECT e FROM EventuaisExterno e JOIN e.trabalhador t JOIN FETCH e.evento WHERE e.data BETWEEN :dataInicio AND :dataFim ORDER BY e.data";
        public static final String FIND_FALTA_DUPLICADA = "SELECT CASE WHEN (COUNT(ee) > 0) THEN true ELSE false END FROM EventuaisExterno ee WHERE ee.trabalhador.trabalhadorPK = :trabalhadorPK AND ee.evento.eventoPK = :eventoPK AND ee.data = :data";
        public static final String IS_EVENTO_DUPLICADO = "SELECT CASE WHEN (COUNT(ee) > 0) THEN true ELSE false END FROM EventuaisExterno ee WHERE (COALESCE(:eventualExternoId, 0) = 0 OR NOT ee.id = :eventualExternoId) AND ee.trabalhador.trabalhadorPK = :trabalhadorPK AND ee.evento.eventoPK = :eventoPK AND MONTH(ee.data) = :mes AND YEAR(ee.data) = :ano";
        public static final String FIND_BY_PERIODO = "SELECT NEW br.com.fiorilli.sipweb.vo.EventualExternoVo(e.id, ev.nome, t.nome, c.nome, e.data, e.valor, e.tipoLancamento, e.situacao, e.observacao, t.dataAdmissao) FROM EventuaisExterno e JOIN e.trabalhador t JOIN t.cargoAtual c JOIN e.evento ev WHERE t.divisao IN (:divisoes) AND t.unidade.departamentoDespesa = COALESCE(:departamentoDespesa, t.unidade.departamentoDespesa) AND (t.trabalhadorPK.entidade = :entidadeId OR :entidadeId = '000') AND e.data BETWEEN :periodoInicio AND :periodoFim AND (e.usuario.codigo = :usuarioId OR e.usuario.login = 'SIP') ORDER BY e.data, t.nome";
        public static final String FIND_BY_PERIODO_FOR_HOMOLOGACAO = "SELECT NEW br.com.fiorilli.sipweb.vo.EventualExternoVo(e.id, ev.nome, t.nome, c.nome, e.data, e.valor, e.tipoLancamento, e.situacao, e.observacao, t.dataAdmissao, ev.eventoPK.codigo, t.matricula) FROM EventuaisExterno e JOIN e.trabalhador t JOIN t.cargoAtual c JOIN e.evento ev WHERE t.divisao IN (:divisoes) AND t.unidade.departamentoDespesa = COALESCE(:departamentoDespesa, t.unidade.departamentoDespesa) AND (t.trabalhadorPK.entidade = :entidadeId OR :entidadeId = '000') AND e.data BETWEEN :periodoInicio AND :periodoFim AND (e.usuario.codigo = :usuarioId OR e.usuario.login = 'SIP') ORDER BY e.data, t.nome";
    }
}

