/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventuaisMassa;
import br.com.fiorilli.sip.persistence.entity.EventuaisObs;
import br.com.fiorilli.sip.persistence.entity.MesAno;
import br.com.fiorilli.sip.persistence.entity.Movimento;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.Sipimporteventuais;
import br.com.fiorilli.sip.persistence.entity.TipoControleEventuaisDiversos;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import br.com.fiorilli.sipweb.vo.ReferenciaSelecionada;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="EVENTUAIS")
@Audited
public class Eventuais
implements Serializable,
GenericEntity,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR_REF = "SELECT e FROM Eventuais e JOIN e.trabalhador t JOIN FETCH e.evento WHERE t.trabalhadorPK = :trabalhadorPK AND e.dataInicial BETWEEN :dataInicio AND :dataFim";
    public static final String FIND_BY_TRABALHADOR_UNIDADE = "SELECT e FROM Eventuais e JOIN e.trabalhador t WHERE t.trabalhadorPK = :trabalhadorPK AND e.unidadeCodigo = :unidade";
    public static final String IS_DUPLICATE_DATA_INICIAL = "SELECT CASE WHEN COALESCE(COUNT(e), 0) > 0 THEN true ELSE false END FROM Eventuais e WHERE e.trabalhador.trabalhadorPK = :trabalhadorPK AND e.eventoCodigo = :eventoCodigo AND ( (e.dataInicial = :dataInicial) OR (e.dataFinal IS NOT NULL AND :dataInicial BETWEEN e.dataInicial AND e.dataFinal))";
    public static final String IS_DUPLICATE_ON_MONTH = "SELECT CASE WHEN COALESCE(COUNT(e), 0) > 0 THEN true ELSE false END FROM Eventuais e WHERE e.entidade = :entidadeCodigo AND e.registro = :registro AND e.eventoCodigo = :eventoCodigo AND e.dataInicial BETWEEN :primeiroDia AND :ultimoDia";
    public static final String GET_LIMITE_HORA_TRABLHADOR = "SELECT COALESCE(SUM(e.quantidade), 0) FROM Eventuais e WHERE e.entidade = :entidadeCodigo AND e.registro = :registro AND e.eventoCodigo = :eventoCodigo AND e.dataInicial BETWEEN :primeiroDia AND :ultimoDia";
    public static final String SUM_QUANTIDADE = "SELECT COALESCE(SUM(eu.quantidade), 0) FROM Eventuais eu LEFT JOIN eu.trabalhador tr LEFT JOIN eu.evento eo WHERE tr = :trabalhador AND eu.dataInicial BETWEEN :dataInicio AND :dataFim AND eo = :evento AND tr.bancoHorasTrabalhador = 'S' AND eo.bancoHorasEvento = 'S' AND eu.codigo <> :codigo";
    public static final String FIND_HORAS_EXTRAS_BY_DATA = "SELECT eu.dataInicial AS dataInicial, eu.dataFinal AS dataFinal FROM Eventuais eu LEFT JOIN eu.trabalhador tr LEFT JOIN eu.evento eo WHERE tr.trabalhadorPK = :trabalhador AND (:data >= eu.dataInicial AND (:data < eu.dataFinal AND eu.dataFinal IS NOT NULL)) OR (:data = eu.dataInicial AND eu.dataFinal IS NULL) AND eo.classificacao = '1'";
    public static final String GENERATOR = "GEN_EVENTUAIS";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="DTLANCTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicial;
    @Column(name="DTFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFinal;
    @Column(name="QTDE")
    private Double quantidade;
    @Column(name="VALORUNI")
    private Double valorUnitario;
    @Column(name="PERCENTUAL")
    private Double percentual;
    @Size(max=7)
    @Column(name="REFERENCIA")
    private String referencia;
    @Column(name="QTDHORAS")
    private Double quantidadeHoras;
    @Column(name="CONTROLE")
    private Character controle;
    @Type(type="BooleanTypeSip")
    @Column(name="QUITADO")
    private Boolean quitado;
    @Column(name="DEPDESPESA")
    private Integer unidadeCodigo;
    @Column(name="TIPOREFERENCIA")
    private String referenciaTipo;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @JoinColumn(name="DEPDESPESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade unidade;
    @FilterConfig(label="Trabalhador", blockCondition=true, condition=FilterCondition.IGUAL, inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @FilterConfigJoin(fetch=true, type=FilterJoinType.LEFT)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @FilterConfig(label="Evento", condition=FilterCondition.IGUAL, blockCondition=true, inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @FilterConfigJoin(fetch=true, type=FilterJoinType.LEFT)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento evento;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="eventuais", fetch=FetchType.LAZY)
    private Sipimporteventuais sipImporteEventuais;
    @JoinTable(name="MOVIMENTO_EVENTUAIS", joinColumns={@JoinColumn(name="ID_EVENTUAIS", referencedColumnName="CODIGO")}, inverseJoinColumns={@JoinColumn(name="ID_MOVIMENTO", referencedColumnName="CODIGO")})
    @ManyToMany(fetch=FetchType.LAZY)
    private List<Movimento> movimentoList;
    @JoinTable(name="EVENTUAIS_MASSA_EVENTUAIS", joinColumns={@JoinColumn(name="CODEVENTUAIS", referencedColumnName="CODIGO")}, inverseJoinColumns={@JoinColumn(name="CODMASSA", referencedColumnName="CODIGO")})
    @ManyToMany(fetch=FetchType.LAZY)
    private List<EventuaisMassa> eventuaisMassaList;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="eventuais", fetch=FetchType.LAZY)
    private EventuaisObs eventuaisObs;
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FilterConfigJoin(fetch=true, type=FilterJoinType.LEFT)
    private Usuario usuario;
    @Column(name="USUARIO")
    private Integer usuarioCodigo;
    @Transient
    private ReferenciaSelecionada referenciaSelecionada;

    public Eventuais() {
    }

    public Eventuais(Integer codigo) {
        this.codigo = codigo;
    }

    public Eventuais(Integer codigo, Date dtlancto) {
        this.codigo = codigo;
        this.dataInicial = dtlancto;
    }

    public MesAno getMesAno() {
        return new MesAno(this.getDataInicial());
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dtlancto) {
        this.dataInicial = dtlancto;
    }

    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double qtde) {
        this.quantidade = qtde;
    }

    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valoruni) {
        this.valorUnitario = valoruni;
    }

    public Double getPercentual() {
        return this.percentual;
    }

    public void setPercentual(Double percentual) {
        this.percentual = percentual;
    }

    public String getReferencia() {
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFim) {
        this.dataFinal = dataFim;
    }

    public Double getQuantidadeHoras() {
        return this.quantidadeHoras;
    }

    public void setQuantidadeHoras(Double qtdhoras) {
        this.quantidadeHoras = qtdhoras;
    }

    public TipoControleEventuaisDiversos getControle() {
        if (this.controle == null) {
            this.controle = Character.valueOf(TipoControleEventuaisDiversos.UNICO.getId());
        }
        return TipoControleEventuaisDiversos.getEntity(this.controle.charValue());
    }

    public void setControle(TipoControleEventuaisDiversos controle) {
        this.controle = Character.valueOf(controle.getId());
    }

    public Boolean getQuitado() {
        return this.quitado;
    }

    public void setQuitado(Boolean quitado) {
        this.quitado = quitado;
    }

    public List<Movimento> getMovimentoList() {
        return this.movimentoList;
    }

    public void setMovimentoList(List<Movimento> movimentoList) {
        this.movimentoList = movimentoList;
    }

    public List<EventuaisMassa> getEventuaisMassaList() {
        return this.eventuaisMassaList;
    }

    public void setEventuaisMassaList(List<EventuaisMassa> eventuaisMassaList) {
        this.eventuaisMassaList = eventuaisMassaList;
    }

    public EventuaisObs getEventuaisObs() {
        if (this.eventuaisObs == null) {
            this.eventuaisObs = new EventuaisObs();
        }
        return this.eventuaisObs;
    }

    public void setEventuaisObs(EventuaisObs eventuaisObs) {
        this.eventuaisObs = eventuaisObs;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuarioCodigo = usuario == null ? null : usuario.getCodigo();
        this.usuario = usuario;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade unidade) {
        this.unidade = unidade;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
            this.entidade = trabalhador.getTrabalhadorPK().getEntidade();
            this.unidadeCodigo = trabalhador.getUnidadeCodigo();
        } else {
            this.registro = null;
            this.entidade = null;
            this.unidadeCodigo = null;
        }
        this.trabalhador = trabalhador;
    }

    public ReferenciaTipo getReferenciaTipo() {
        return ReferenciaTipo.get(this.referenciaTipo);
    }

    public void setReferenciaTipo(ReferenciaTipo referenciaTipo) {
        this.referenciaTipo = referenciaTipo.getCodigo();
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.eventoCodigo = evento != null ? evento.getEventoPK().getCodigo() : null;
        this.evento = evento;
    }

    public Sipimporteventuais getSipImporteEventuais() {
        return this.sipImporteEventuais;
    }

    public void setSipImporteEventuais(Sipimporteventuais sipimporteventuais) {
        this.sipImporteEventuais = sipimporteventuais;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Eventuais)) {
            return false;
        }
        Eventuais other = (Eventuais)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Eventuais[ codigo=" + this.codigo + " ]";
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String evento) {
        this.eventoCodigo = evento;
    }

    public Integer getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public void setUnidadeCodigo(Integer unidadeCodigo) {
        this.unidadeCodigo = unidadeCodigo;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.codigo);
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataCriacao) {
        this.dataDocumento = dataCriacao;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegal = tipoLegal;
        this.tipoLegalCodigo = tipoLegal != null ? tipoLegal.getCodigo() : null;
    }

    public ReferenciaSelecionada getReferenciaSelecionada() {
        return this.referenciaSelecionada;
    }

    public void setReferenciaSelecionada(ReferenciaSelecionada referenciaSelecionada) {
        this.referenciaSelecionada = referenciaSelecionada;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }

    public Integer getUsuarioCodigo() {
        return this.usuarioCodigo;
    }

    public void setUsuarioCodigo(Integer usuarioCodigo) {
        this.usuarioCodigo = usuarioCodigo;
    }
}

