/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventosGatilhoPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="EVENTOS_GATILHO")
@Audited
public class EventosGatilho
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO_MESTRE = "SELECT eg FROM EventosGatilho ga JOIN ga.eventoMestre em JOIN ga.eventoGatilho eg WHERE em.eventoPK = :eventoMestrePK ORDER BY ga.pk.eventoGatilho";
    public static final String FIND_BY_EVENTO = "SELECT eg FROM EventosGatilho eg LEFT JOIN FETCH eg.eventoGatilho ga WHERE eg.eventoMestre.eventoPK = :eventoPK ORDER BY eg.pk.eventoGatilho";
    @EmbeddedId
    private EventosGatilhoPK pk;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA_MESTRE", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_MESTRE", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento eventoMestre;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA_GATILHO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_GATILHO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento eventoGatilho;
    @Column(name="EVENTO_GATILHO", insertable=false, updatable=false)
    private String codigoEventoGatilho;

    public EventosGatilhoPK getPk() {
        if (this.pk == null) {
            this.pk = new EventosGatilhoPK();
        }
        return this.pk;
    }

    public void setPk(EventosGatilhoPK id) {
        this.pk = id;
    }

    public Evento getEventoMestre() {
        return this.eventoMestre;
    }

    public void setEventoMestre(Evento eventoMestre) {
        this.eventoMestre = eventoMestre;
        if (eventoMestre != null) {
            this.getPk().setEntidadeMestre(eventoMestre.getEventoPK().getEntidade());
            this.getPk().setEventoMestre(eventoMestre.getEventoPK().getCodigo());
        } else {
            this.getPk().setEntidadeMestre(null);
            this.getPk().setEventoMestre(null);
        }
    }

    public Evento getEventoGatilho() {
        return this.eventoGatilho;
    }

    public void setEventoGatilho(Evento eventoGatilho) {
        this.eventoGatilho = eventoGatilho;
        if (eventoGatilho != null) {
            this.getPk().setEntidadeGatilho(eventoGatilho.getEventoPK().getEntidade());
            this.getPk().setEventoGatilho(eventoGatilho.getEventoPK().getCodigo());
        } else {
            this.getPk().setEntidadeGatilho(null);
            this.getPk().setEventoGatilho(null);
        }
    }

    public String getCodigoEventoGatilho() {
        return this.codigoEventoGatilho;
    }

    public void setCodigoEventoGatilho(String codigoEventoGatilho) {
        this.codigoEventoGatilho = codigoEventoGatilho;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventosGatilho other = (EventosGatilho)obj;
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }

    public String toString() {
        return "EventosGatilho [pk=" + this.pk + "]";
    }
}

