/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventosExclusaoPK;
import br.com.fiorilli.sip.persistence.entity.MesConsulta;
import br.com.fiorilli.sip.persistence.entity.TipoComparador;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="EVENTOS_EXCLUSAO")
@Audited
public class EventosExclusao
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT e FROM EventosExclusao e LEFT JOIN FETCH e.eventoExclusao ee WHERE e.eventoMestre.eventoPK = :eventoPK ORDER BY e.eventosExclusaoPK.eventoExclusao";
    @EmbeddedId
    private EventosExclusaoPK eventosExclusaoPK;
    @Column(name="GRUPO")
    private Integer grupo;
    @Column(name="MES_ANTERIOR_ATUAL")
    private Integer mesAnteriorAtual;
    @Column(name="QTDE")
    private Double qtde;
    @Column(name="TIPO")
    private Integer tipo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA_EXCLUSAO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_EXCLUSAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento eventoExclusao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA_MESTRE", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_MESTRE", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento eventoMestre;

    public EventosExclusaoPK getEventosExclusaoPK() {
        if (this.eventosExclusaoPK == null) {
            this.eventosExclusaoPK = new EventosExclusaoPK();
        }
        return this.eventosExclusaoPK;
    }

    public void setEventosExclusaoPK(EventosExclusaoPK eventosExclusaoPK) {
        this.eventosExclusaoPK = eventosExclusaoPK;
    }

    public Integer getGrupo() {
        return this.grupo;
    }

    public void setGrupo(Integer grupo) {
        this.grupo = grupo;
    }

    public MesConsulta getMesAnteriorAtual() {
        return MesConsulta.toEntity(this.mesAnteriorAtual);
    }

    public void setMesAnteriorAtual(MesConsulta mesAnteriorAtual) {
        if (mesAnteriorAtual == null) {
            MesConsulta.MES_ATUAL.getId();
        } else {
            this.mesAnteriorAtual = mesAnteriorAtual.getId();
        }
    }

    public Double getQtde() {
        return this.qtde;
    }

    public void setQtde(Double qtde) {
        this.qtde = qtde;
    }

    public TipoComparador getTipo() {
        return TipoComparador.toEntity(this.tipo);
    }

    public void setTipo(TipoComparador tipo) {
        if (tipo == null) {
            TipoComparador.IGUAL.getId();
        } else {
            this.tipo = tipo.getId();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventosExclusaoPK == null ? 0 : this.eventosExclusaoPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventosExclusao other = (EventosExclusao)obj;
        return !(this.eventosExclusaoPK == null ? other.eventosExclusaoPK != null : !this.eventosExclusaoPK.equals(other.eventosExclusaoPK));
    }

    public String toString() {
        return "EventosExclusao [eventosExclusaoPK=" + this.eventosExclusaoPK + "]";
    }

    public Evento getEventoExclusao() {
        if (this.eventoExclusao == null) {
            this.eventoExclusao = new Evento();
        }
        return this.eventoExclusao;
    }

    public void setEventoExclusao(Evento eventoExclusao) {
        this.eventoExclusao = eventoExclusao;
        if (eventoExclusao != null) {
            this.getEventosExclusaoPK().setEntidadeExclusao(eventoExclusao.getEventoPK().getEntidade());
            this.getEventosExclusaoPK().setEventoExclusao(eventoExclusao.getEventoPK().getCodigo());
        } else {
            this.getEventosExclusaoPK().setEntidadeExclusao(null);
            this.getEventosExclusaoPK().setEventoExclusao(null);
        }
    }

    public Evento getEventoMestre() {
        return this.eventoMestre;
    }

    public void setEventoMestre(Evento eventoMestre) {
        this.eventoMestre = eventoMestre;
        if (eventoMestre != null) {
            this.getEventosExclusaoPK().setEntidadeMestre(eventoMestre.getEventoPK().getEntidade());
            this.getEventosExclusaoPK().setEventoMestre(eventoMestre.getEventoPK().getCodigo());
        } else {
            this.getEventosExclusaoPK().setEntidadeMestre(null);
            this.getEventosExclusaoPK().setEventoMestre(null);
        }
    }
}

