/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.EventoDespesaMedica;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="EVENTOS_DESPMEDICA_IDADES")
@Audited
public class EventosDespMedicaIdades
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT e FROM EventosDespMedicaIdades e LEFT JOIN FETCH e.eventoDespesaMedica ev WHERE ev.eventoDespesaMedicaPK.evento = :pk";
    public static final String GENERATOR = "GEN_EVENTOS_DESPMEDICA_IDADES";
    @Id
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private EventoDespesaMedica eventoDespesaMedica;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String codigoEvento;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Column(name="DE")
    private String de;
    @Column(name="ATE")
    private String ate;
    @Column(name="VALOR")
    private Double valor;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventosDespMedicaIdades other = (EventosDespMedicaIdades)obj;
        return this.codigo == other.codigo;
    }

    public String toString() {
        return "EventosDespmedicaIdades [codigo=" + this.codigo + "]";
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public EventoDespesaMedica getEventoDespesaMedica() {
        return this.eventoDespesaMedica;
    }

    public void setEventoDespesaMedica(EventoDespesaMedica eventoDespesaMedica) {
        if (eventoDespesaMedica != null) {
            this.codigoEvento = eventoDespesaMedica.getEventoDespesaMedicaPK().getEvento();
            this.entidade = eventoDespesaMedica.getEventoDespesaMedicaPK().getEntidade();
        } else {
            this.codigoEvento = null;
            this.entidade = null;
        }
        this.eventoDespesaMedica = eventoDespesaMedica;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String codigoEvento) {
        this.codigoEvento = codigoEvento;
    }

    public String getDe() {
        return this.de;
    }

    public void setDe(String de) {
        this.de = de;
    }

    public String getAte() {
        return this.ate;
    }

    public void setAte(String ate) {
        this.ate = ate;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }
}

