/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CategoriaFuncional;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventosCategoriafuncionalPK;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="EVENTOS_CATFUNCIONAL")
@Audited
public class EventosCategoriafuncional
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CATEGORIA_FUNCIONAL = "SELECT e FROM EventosCategoriafuncional e JOIN FETCH e.evento WHERE e.categoriaFuncional.categoriaFuncionalPK = :categoriaFuncionalPK ORDER BY e.evento.nome";
    @EmbeddedId
    private EventosCategoriafuncionalPK id = new EventosCategoriafuncionalPK();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CATFUNCIONAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private CategoriaFuncional categoriaFuncional;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento evento;

    public EventosCategoriafuncionalPK getId() {
        return this.id;
    }

    public void setId(EventosCategoriafuncionalPK id) {
        this.id = id;
    }

    public CategoriaFuncional getCategoriaFuncional() {
        return this.categoriaFuncional;
    }

    public void setCategoriaFuncional(CategoriaFuncional categoriaFuncionalBean) {
        if (categoriaFuncionalBean != null) {
            this.id.setCategoriaFuncionalCodigo(categoriaFuncionalBean.getCategoriaFuncionalPK().getCodigo());
        } else {
            this.id.setCategoriaFuncionalCodigo(0);
        }
        this.categoriaFuncional = categoriaFuncionalBean;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.id.setEvento(evento.getEventoPK().getCodigo());
            this.id.setEmpresa(evento.getEventoPK().getEntidade());
        } else {
            this.id.setEvento(null);
            this.id.setEmpresa(null);
        }
        this.evento = evento;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventosCategoriafuncional other = (EventosCategoriafuncional)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "EventosCategoriafuncional [id=" + this.id + "]";
    }
}

