/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventosAritimeticaPK;
import br.com.fiorilli.sip.persistence.entity.OperadoresAritmeticos;
import br.com.fiorilli.sip.persistence.entity.TipoValorCalculoAritmetico;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="EVENTOS_ARITIMETICA")
@Audited
public class EventosAritimetica
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT e FROM EventosAritimetica e LEFT JOIN FETCH e.eventoConta ec WHERE e.eventoPrincipal.eventoPK = :eventoPK ORDER BY e.ordem";
    @EmbeddedId
    protected EventosAritimeticaPK eventosAritimeticaPK;
    @Column(name="OPERACAO")
    private Character operacao;
    @Column(name="ORDEM")
    private Short ordem;
    @Column(name="TIPOVALOR")
    private Character tipovalor;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTOPRINCIPAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento eventoPrincipal;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTOCONTA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento eventoConta;
    @Type(type="BooleanTypeSip")
    @Column(name="ATUALIZAR_REFHOLERITE")
    private Boolean atualizarReferenciaHolerite;

    public EventosAritimetica() {
    }

    public EventosAritimetica(EventosAritimeticaPK eventosAritimeticaPK) {
        this.eventosAritimeticaPK = eventosAritimeticaPK;
    }

    public EventosAritimetica(String entidade, String eventoprincipal, String eventoconta) {
        this.eventosAritimeticaPK = new EventosAritimeticaPK(entidade, eventoprincipal, eventoconta);
    }

    public EventosAritimeticaPK getEventosAritimeticaPK() {
        if (this.eventosAritimeticaPK == null) {
            this.eventosAritimeticaPK = new EventosAritimeticaPK();
        }
        return this.eventosAritimeticaPK;
    }

    public void setEventosAritimeticaPK(EventosAritimeticaPK eventosAritimeticaPK) {
        this.eventosAritimeticaPK = eventosAritimeticaPK;
    }

    public OperadoresAritmeticos getOperacao() {
        return OperadoresAritmeticos.toEntity(this.operacao);
    }

    public void setOperacao(OperadoresAritmeticos operacao) {
        if (operacao == null) {
            operacao = OperadoresAritmeticos.SOMA;
        } else {
            this.operacao = operacao.getId();
        }
    }

    public Short getOrdem() {
        return this.ordem;
    }

    public void setOrdem(Short ordem) {
        this.ordem = ordem;
    }

    public TipoValorCalculoAritmetico getTipovalor() {
        return TipoValorCalculoAritmetico.toEntity(this.tipovalor);
    }

    public void setTipovalor(TipoValorCalculoAritmetico tipovalor) {
        if (tipovalor == null) {
            tipovalor = TipoValorCalculoAritmetico.VALOR_PROPORCIONAL;
        } else {
            this.tipovalor = tipovalor.getId();
        }
    }

    public Evento getEventoPrincipal() {
        return this.eventoPrincipal;
    }

    public void setEventoPrincipal(Evento eventoPrincipal) {
        if (eventoPrincipal != null) {
            this.getEventosAritimeticaPK().setEntidade(eventoPrincipal.getEventoPK().getEntidade());
            this.getEventosAritimeticaPK().setEventoprincipal(eventoPrincipal.getEventoPK().getCodigo());
        } else {
            this.getEventosAritimeticaPK().setEntidade(null);
            this.getEventosAritimeticaPK().setEventoprincipal(null);
        }
        this.eventoPrincipal = eventoPrincipal;
    }

    public Evento getEventoConta() {
        return this.eventoConta;
    }

    public void setEventoConta(Evento eventoConta) {
        if (eventoConta != null) {
            this.getEventosAritimeticaPK().setEventoconta(eventoConta.getEventoPK().getCodigo());
        } else {
            this.getEventosAritimeticaPK().setEventoconta(null);
        }
        this.eventoConta = eventoConta;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.eventosAritimeticaPK != null ? this.eventosAritimeticaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventosAritimetica)) {
            return false;
        }
        EventosAritimetica other = (EventosAritimetica)object;
        return (this.eventosAritimeticaPK != null || other.eventosAritimeticaPK == null) && (this.eventosAritimeticaPK == null || this.eventosAritimeticaPK.equals(other.eventosAritimeticaPK));
    }

    public String toString() {
        return "entity.EventosAritimetica[ eventosAritimeticaPK=" + this.eventosAritimeticaPK + " ]";
    }

    public Boolean getAtualizarReferenciaHolerite() {
        return this.atualizarReferenciaHolerite;
    }

    public void setAtualizarReferenciaHolerite(Boolean atualizarReferenciaHolerite) {
        this.atualizarReferenciaHolerite = atualizarReferenciaHolerite;
    }
}

