/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventosAlteracoesPK;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="EVENTOS_ALTERACOES")
@Audited
public class EventosAlteracoes
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT e FROM EventosAlteracoes e LEFT JOIN FETCH e.tipolegal tl WHERE e.evento.eventoPK = :eventoPK ORDER BY e.eventosAlteracoesPK.item";
    public static final String GET_NEXT_ITEM = "Select coalesce(max(e.eventosAlteracoesPK.item), 0)+ 1 FROM EventosAlteracoes e WHERE e.eventosAlteracoesPK.entidade = :entidadeCodigo";
    @EmbeddedId
    protected EventosAlteracoesPK eventosAlteracoesPK;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date datadoc;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numdoc;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String obs;
    @Column(name="TIPOLEGAL")
    private Integer codigoTipoLegal;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipolegal;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;

    public EventosAlteracoes() {
    }

    public EventosAlteracoes(EventosAlteracoesPK eventosAlteracoesPK) {
        this.eventosAlteracoesPK = eventosAlteracoesPK;
    }

    public EventosAlteracoes(String entidade, String evento, short item) {
        this.eventosAlteracoesPK = new EventosAlteracoesPK(entidade, evento, item);
    }

    public EventosAlteracoesPK getEventosAlteracoesPK() {
        if (this.eventosAlteracoesPK == null) {
            this.eventosAlteracoesPK = new EventosAlteracoesPK();
        }
        return this.eventosAlteracoesPK;
    }

    public void setEventosAlteracoesPK(EventosAlteracoesPK eventosAlteracoesPK) {
        this.eventosAlteracoesPK = eventosAlteracoesPK;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.evento = evento;
        if (evento != null) {
            this.getEventosAlteracoesPK().setEntidade(evento.getEventoPK().getEntidade());
            this.getEventosAlteracoesPK().setEvento(evento.getEventoPK().getCodigo());
        } else {
            this.getEventosAlteracoesPK().setEntidade(null);
            this.getEventosAlteracoesPK().setEvento(null);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.eventosAlteracoesPK != null ? this.eventosAlteracoesPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventosAlteracoes)) {
            return false;
        }
        EventosAlteracoes other = (EventosAlteracoes)object;
        return (this.eventosAlteracoesPK != null || other.eventosAlteracoesPK == null) && (this.eventosAlteracoesPK == null || this.eventosAlteracoesPK.equals(other.eventosAlteracoesPK));
    }

    public TipoDocumentoLegal getTipolegal() {
        return this.tipolegal;
    }

    public void setTipolegal(TipoDocumentoLegal tipolegal) {
        this.tipolegal = tipolegal;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipolegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.codigoTipoLegal = this.tipolegal != null ? value.getCodigo() : null;
        this.tipolegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.codigoTipoLegal;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numdoc;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numdoc = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numdoc);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numdoc);
    }

    @Override
    public Date getData() {
        return this.datadoc;
    }

    @Override
    public void setData(Date value) {
        this.datadoc = value;
    }
}

