/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoVinculoPK;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="EVENTOS_VINCULO")
@Audited
public class EventoVinculo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_VINCULO = "SELECT ev FROM EventoVinculo ev JOIN ev.vinculo vi JOIN FETCH ev.evento WHERE vi.vinculoPK = :vinculoPK";
    @EmbeddedId
    private EventoVinculoPK pk = new EventoVinculoPK();
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="VINCULO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Vinculo vinculo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento evento;

    public EventoVinculoPK getPk() {
        return this.pk;
    }

    public void setPk(EventoVinculoPK id) {
        this.pk = id;
    }

    public Vinculo getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(Vinculo vinculo) {
        if (vinculo != null) {
            this.pk.setVinculo(vinculo.getVinculoPK().getCodigo());
            this.pk.setEntidade(vinculo.getVinculoPK().getEntidade());
        } else {
            this.pk.setVinculo(null);
            this.pk.setEntidade(null);
        }
        this.vinculo = vinculo;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.pk.setEvento(evento.getEventoPK().getCodigo());
            this.pk.setEntidade(evento.getEventoPK().getEntidade());
        } else {
            this.pk.setEvento(null);
            this.pk.setEntidade(null);
        }
        this.evento = evento;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventoVinculo other = (EventoVinculo)obj;
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }
}

