/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoPerdeAvoBenefFaltas;
import br.com.fiorilli.sip.persistence.entity.EventoPerdeAvoBeneficioCausas;
import br.com.fiorilli.sip.persistence.entity.EventoPerdeAvoBeneficioPK;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="EVENTO_PERDE_AVO_BENEFICIO")
@Audited
public class EventoPerdeAvoBeneficio
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT e FROM EventoPerdeAvoBeneficio e LEFT JOIN FETCH e.evento WHERE e.evento.eventoPK = :pk";
    @EmbeddedId
    protected EventoPerdeAvoBeneficioPK eventoPerdeAvoBeneficioPK;
    @Column(name="DIAS_AFASTAMENTO")
    private Short diasAfastamento;
    @Column(name="DIAS_FALTA")
    private Short diasFalta;
    @Type(type="BooleanTypeSip")
    @Column(name="GOZO_LICENCA_PREMIO")
    private Boolean gozoLicencaPremio;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @OneToMany(mappedBy="eventoPerdeAvoBeneficio", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventoPerdeAvoBenefFaltas> eventoPerdeBeneficioFaltas = new ArrayList<EventoPerdeAvoBenefFaltas>();
    @OneToMany(mappedBy="eventoPerdeAvoBeneficio", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventoPerdeAvoBeneficioCausas> eventoPerdeAvoBeneficioCausas = new ArrayList<EventoPerdeAvoBeneficioCausas>();

    public EventoPerdeAvoBeneficio() {
    }

    public EventoPerdeAvoBeneficio(EventoPerdeAvoBeneficioPK eventoPerdeAvoBeneficioPK) {
        this.eventoPerdeAvoBeneficioPK = eventoPerdeAvoBeneficioPK;
    }

    public EventoPerdeAvoBeneficio(String entidade, String evento) {
        this.eventoPerdeAvoBeneficioPK = new EventoPerdeAvoBeneficioPK(entidade, evento);
    }

    public EventoPerdeAvoBeneficioPK getEventoPerdeAvoBeneficioPK() {
        if (this.eventoPerdeAvoBeneficioPK == null) {
            this.eventoPerdeAvoBeneficioPK = new EventoPerdeAvoBeneficioPK();
        }
        return this.eventoPerdeAvoBeneficioPK;
    }

    public void setEventoPerdeAvoBeneficioPK(EventoPerdeAvoBeneficioPK eventoPerdeAvoBeneficioPK) {
        this.eventoPerdeAvoBeneficioPK = eventoPerdeAvoBeneficioPK;
    }

    public Short getDiasAfastamento() {
        return this.diasAfastamento;
    }

    public void setDiasAfastamento(Short diasAfastamento) {
        this.diasAfastamento = diasAfastamento;
    }

    public Short getDiasFalta() {
        return this.diasFalta;
    }

    public void setDiasFalta(Short diasFalta) {
        this.diasFalta = diasFalta;
    }

    public Boolean getGozoLicencaPremio() {
        return this.gozoLicencaPremio;
    }

    public void setGozoLicencaPremio(Boolean gozoLicencaPremio) {
        this.gozoLicencaPremio = gozoLicencaPremio;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.eventoPerdeAvoBeneficioPK != null ? this.eventoPerdeAvoBeneficioPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventoPerdeAvoBeneficio)) {
            return false;
        }
        EventoPerdeAvoBeneficio other = (EventoPerdeAvoBeneficio)object;
        return (this.eventoPerdeAvoBeneficioPK != null || other.eventoPerdeAvoBeneficioPK == null) && (this.eventoPerdeAvoBeneficioPK == null || this.eventoPerdeAvoBeneficioPK.equals(other.eventoPerdeAvoBeneficioPK));
    }

    public String toString() {
        return "entity.EventoPerdeAvoBeneficio[ eventoPerdeAvoBeneficioPK=" + this.eventoPerdeAvoBeneficioPK + " ]";
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.getEventoPerdeAvoBeneficioPK().setEntidade(evento.getEventoPK().getEntidade());
            this.getEventoPerdeAvoBeneficioPK().setEvento(evento.getEventoPK().getCodigo());
        } else {
            this.getEventoPerdeAvoBeneficioPK().setEntidade(null);
            this.getEventoPerdeAvoBeneficioPK().setEvento(null);
        }
        this.evento = evento;
    }

    public List<EventoPerdeAvoBenefFaltas> getEventoPerdeBeneficioFaltas() {
        return this.eventoPerdeBeneficioFaltas;
    }

    public void setEventoPerdeBeneficioFaltas(List<EventoPerdeAvoBenefFaltas> eventoPerdeBeneficioFaltas) {
        this.eventoPerdeBeneficioFaltas = eventoPerdeBeneficioFaltas;
    }

    public List<EventoPerdeAvoBeneficioCausas> getEventoPerdeAvoBeneficioCausas() {
        return this.eventoPerdeAvoBeneficioCausas;
    }

    public void setEventoPerdeAvoBeneficioCausas(List<EventoPerdeAvoBeneficioCausas> eventoPerdeAvoBeneficioCausas) {
        this.eventoPerdeAvoBeneficioCausas = eventoPerdeAvoBeneficioCausas;
    }
}

