/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventuaisMassa;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="EVENTOS_FOLHACOMPL")
@Audited
public class EventoFolhaComplementar
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_EVENTOS_FOLHACOMPL";
    @Id
    @NotNull
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @FilterConfig(label="Data", condition=FilterCondition.INTERVALO, inputType=FilterInputType.CALENDAR)
    @Basic(optional=false)
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Column(name="QTDE")
    private Double quantidade;
    @Column(name="VALOR")
    private Double valor;
    @Column(name="PERCENTUAL")
    private Double percentual;
    @Size(max=7)
    @Column(name="REFERENCIA")
    private String referencia;
    @JoinTable(name="EVENTUAIS_MASSA_EVCOMPL", joinColumns={@JoinColumn(name="ID_EV_FOLHACOMPL")}, inverseJoinColumns={@JoinColumn(name="CODMASSA")})
    @OneToMany(fetch=FetchType.LAZY)
    private List<EventuaisMassa> eventuaisMassaList;
    @Column(name="USUARIO")
    private Integer usuarioCodigo;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Usuario usuario;
    @Column(name="DEPDESPESA")
    private Integer unidadeCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DEPDESPESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Unidade unidade;
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE, blockCondition=true)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @FilterConfig(label="Evento", inputType=FilterInputType.AUTO_COMPLETE, blockCondition=true)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @Size(max=512)
    @Column(name="OBS")
    private String obs;
    public static final String IS_DUPLICATE = "SELECT CASE WHEN COALESCE(COUNT(ef.registro), 0) > 0 THEN TRUE ELSE FALSE END FROM         EventoFolhaComplementar ef WHERE         ef.entidade     = :entidade AND     ef.registro     = :registro AND     ef.eventoCodigo = :eventoCodigo AND     ef.data         = :data";

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
        this.usuarioCodigo = usuario != null ? usuario.getCodigo() : null;
    }

    public void setUnidade(Unidade unidade) {
        this.unidade = unidade;
        this.unidadeCodigo = unidade != null ? unidade.getCodigo() : null;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            TrabalhadorPK pk = trabalhador.getTrabalhadorPK();
            this.setEntidade(pk.getEntidade());
            this.setRegistro(pk.getRegistro());
        } else {
            this.setEntidade(null);
            this.setRegistro(null);
        }
        this.trabalhador = trabalhador;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.setEventoCodigo(evento.getEventoPK().getCodigo());
        } else {
            this.setEventoCodigo(null);
        }
        this.evento = evento;
    }

    public Integer getId() {
        return this.id;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public Date getData() {
        return this.data;
    }

    public Double getQuantidade() {
        return this.quantidade;
    }

    public Double getValor() {
        return this.valor;
    }

    public Double getPercentual() {
        return this.percentual;
    }

    public String getReferencia() {
        return this.referencia;
    }

    public List<EventuaisMassa> getEventuaisMassaList() {
        return this.eventuaisMassaList;
    }

    public Integer getUsuarioCodigo() {
        return this.usuarioCodigo;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public Integer getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public String getObs() {
        return this.obs;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public void setPercentual(Double percentual) {
        this.percentual = percentual;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    public void setEventuaisMassaList(List<EventuaisMassa> eventuaisMassaList) {
        this.eventuaisMassaList = eventuaisMassaList;
    }

    public void setUsuarioCodigo(Integer usuarioCodigo) {
        this.usuarioCodigo = usuarioCodigo;
    }

    public void setUnidadeCodigo(Integer unidadeCodigo) {
        this.unidadeCodigo = unidadeCodigo;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventoFolhaComplementar)) {
            return false;
        }
        EventoFolhaComplementar other = (EventoFolhaComplementar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$entidade = this.getEntidade();
        String other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !this$entidade.equals(other$entidade)) {
            return false;
        }
        String this$registro = this.getRegistro();
        String other$registro = other.getRegistro();
        if (this$registro == null ? other$registro != null : !this$registro.equals(other$registro)) {
            return false;
        }
        String this$eventoCodigo = this.getEventoCodigo();
        String other$eventoCodigo = other.getEventoCodigo();
        if (this$eventoCodigo == null ? other$eventoCodigo != null : !this$eventoCodigo.equals(other$eventoCodigo)) {
            return false;
        }
        Date this$data = this.getData();
        Date other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Double this$quantidade = this.getQuantidade();
        Double other$quantidade = other.getQuantidade();
        if (this$quantidade == null ? other$quantidade != null : !((Object)this$quantidade).equals(other$quantidade)) {
            return false;
        }
        Double this$valor = this.getValor();
        Double other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        Double this$percentual = this.getPercentual();
        Double other$percentual = other.getPercentual();
        if (this$percentual == null ? other$percentual != null : !((Object)this$percentual).equals(other$percentual)) {
            return false;
        }
        String this$referencia = this.getReferencia();
        String other$referencia = other.getReferencia();
        if (this$referencia == null ? other$referencia != null : !this$referencia.equals(other$referencia)) {
            return false;
        }
        List<EventuaisMassa> this$eventuaisMassaList = this.getEventuaisMassaList();
        List<EventuaisMassa> other$eventuaisMassaList = other.getEventuaisMassaList();
        if (this$eventuaisMassaList == null ? other$eventuaisMassaList != null : !((Object)this$eventuaisMassaList).equals(other$eventuaisMassaList)) {
            return false;
        }
        Integer this$usuarioCodigo = this.getUsuarioCodigo();
        Integer other$usuarioCodigo = other.getUsuarioCodigo();
        if (this$usuarioCodigo == null ? other$usuarioCodigo != null : !((Object)this$usuarioCodigo).equals(other$usuarioCodigo)) {
            return false;
        }
        Usuario this$usuario = this.getUsuario();
        Usuario other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !((Object)this$usuario).equals(other$usuario)) {
            return false;
        }
        Integer this$unidadeCodigo = this.getUnidadeCodigo();
        Integer other$unidadeCodigo = other.getUnidadeCodigo();
        if (this$unidadeCodigo == null ? other$unidadeCodigo != null : !((Object)this$unidadeCodigo).equals(other$unidadeCodigo)) {
            return false;
        }
        Unidade this$unidade = this.getUnidade();
        Unidade other$unidade = other.getUnidade();
        if (this$unidade == null ? other$unidade != null : !((Object)this$unidade).equals(other$unidade)) {
            return false;
        }
        Trabalhador this$trabalhador = this.getTrabalhador();
        Trabalhador other$trabalhador = other.getTrabalhador();
        if (this$trabalhador == null ? other$trabalhador != null : !((Object)this$trabalhador).equals(other$trabalhador)) {
            return false;
        }
        Evento this$evento = this.getEvento();
        Evento other$evento = other.getEvento();
        if (this$evento == null ? other$evento != null : !((Object)this$evento).equals(other$evento)) {
            return false;
        }
        String this$obs = this.getObs();
        String other$obs = other.getObs();
        return !(this$obs == null ? other$obs != null : !this$obs.equals(other$obs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventoFolhaComplementar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : $entidade.hashCode());
        String $registro = this.getRegistro();
        result = result * 59 + ($registro == null ? 43 : $registro.hashCode());
        String $eventoCodigo = this.getEventoCodigo();
        result = result * 59 + ($eventoCodigo == null ? 43 : $eventoCodigo.hashCode());
        Date $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Double $quantidade = this.getQuantidade();
        result = result * 59 + ($quantidade == null ? 43 : ((Object)$quantidade).hashCode());
        Double $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        Double $percentual = this.getPercentual();
        result = result * 59 + ($percentual == null ? 43 : ((Object)$percentual).hashCode());
        String $referencia = this.getReferencia();
        result = result * 59 + ($referencia == null ? 43 : $referencia.hashCode());
        List<EventuaisMassa> $eventuaisMassaList = this.getEventuaisMassaList();
        result = result * 59 + ($eventuaisMassaList == null ? 43 : ((Object)$eventuaisMassaList).hashCode());
        Integer $usuarioCodigo = this.getUsuarioCodigo();
        result = result * 59 + ($usuarioCodigo == null ? 43 : ((Object)$usuarioCodigo).hashCode());
        Usuario $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : ((Object)$usuario).hashCode());
        Integer $unidadeCodigo = this.getUnidadeCodigo();
        result = result * 59 + ($unidadeCodigo == null ? 43 : ((Object)$unidadeCodigo).hashCode());
        Unidade $unidade = this.getUnidade();
        result = result * 59 + ($unidade == null ? 43 : ((Object)$unidade).hashCode());
        Trabalhador $trabalhador = this.getTrabalhador();
        result = result * 59 + ($trabalhador == null ? 43 : ((Object)$trabalhador).hashCode());
        Evento $evento = this.getEvento();
        result = result * 59 + ($evento == null ? 43 : ((Object)$evento).hashCode());
        String $obs = this.getObs();
        result = result * 59 + ($obs == null ? 43 : $obs.hashCode());
        return result;
    }

    public String toString() {
        return "EventoFolhaComplementar(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", registro=" + this.getRegistro() + ", eventoCodigo=" + this.getEventoCodigo() + ", data=" + this.getData() + ", quantidade=" + this.getQuantidade() + ", valor=" + this.getValor() + ", percentual=" + this.getPercentual() + ", referencia=" + this.getReferencia() + ", eventuaisMassaList=" + this.getEventuaisMassaList() + ", usuarioCodigo=" + this.getUsuarioCodigo() + ", usuario=" + this.getUsuario() + ", unidadeCodigo=" + this.getUnidadeCodigo() + ", unidade=" + this.getUnidade() + ", trabalhador=" + this.getTrabalhador() + ", evento=" + this.getEvento() + ", obs=" + this.getObs() + ")";
    }
}

