/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoFixo;
import br.com.fiorilli.sip.persistence.entity.EventoFixoDuplicidade;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="EVENTOSFIXOS_PARAM")
@FilterConfigType(query="SELECT $R{[DISTINCT efp.codigo],[DISTINCT efp]} FROM EventoFixoParametro efp JOIN efp.eventosfixosList ef JOIN ef.trabalhador tr JOIN FETCH efp.evento ev JOIN FETCH efp.usuario us WHERE efp.entidadeCodigo = :entidadeCodigo AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[codigo],[efp.codigo],[:codigo]} AND $P{[dataDocumento],[efp.dataDocumento],[:dataDocumento]} AND $P{[numeroDocumento],[efp.numeroDocumento],[:numeroDocumento]} AND $P{[dataBase],[efp.dataBase],[:dataBase]} AND $P{[dataLimite],[efp.dataLimite],[:dataLimite]} AND $P{[tipoLegal],[efp.tipoLegal],[:tipoLegal]} AND $P{[evento],[ev],[:evento]} AND $P{[usuario],[us],[:usuario]} ")
@FilterConfigParameters(value={@FilterConfigParameter(id="registro", fieldClass=String.class, label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER, order=2)})
@Audited
public class EventoFixoParametro
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_CODIGO_EVENTOSFIXOSPARAM";
    public static final String FILTER_QUERY = "SELECT $R{[DISTINCT efp.codigo],[DISTINCT efp]} FROM EventoFixoParametro efp JOIN efp.eventosfixosList ef JOIN ef.trabalhador tr JOIN FETCH efp.evento ev JOIN FETCH efp.usuario us WHERE efp.entidadeCodigo = :entidadeCodigo AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[codigo],[efp.codigo],[:codigo]} AND $P{[dataDocumento],[efp.dataDocumento],[:dataDocumento]} AND $P{[numeroDocumento],[efp.numeroDocumento],[:numeroDocumento]} AND $P{[dataBase],[efp.dataBase],[:dataBase]} AND $P{[dataLimite],[efp.dataLimite],[:dataLimite]} AND $P{[tipoLegal],[efp.tipoLegal],[:tipoLegal]} AND $P{[evento],[ev],[:evento]} AND $P{[usuario],[us],[:usuario]} ";
    public static final String COLETIVO_CONSULTA_TRABALHADORES = String.format("Select $R{[DISTINCT tr.trabalhadorPK.registro], [DISTINCT tr.trabalhadorPK.entidade, tr.trabalhadorPK.registro, tr.matricula, tr.contrato, tr.nome, tr.dataAdmissao, tr.cargoAtual.nome]} %s WHERE %s", "FROM EventoFixo ef JOIN ef.trabalhador tr JOIN ef.evento ev ", "tr.trabalhadorPK.entidade = :entidadeCodigo AND $P{[EVENTO], [ev], [:EVENTO]} AND $P{[VALOR], [ev.valor], [:VALOR]} AND $P{[PERC], [ev.porcentagem], [:PERC]} AND $P{[QTDE], [ev.quantidade], [:QTDE]} AND $P{[REGISTRO], [tr], [:REGISTRO]} AND $P{[CONTRATO], [tr.contrato], [:CONTRATO]} AND $P{[DTADMISSAO], [tr.dataAdmissao], [:DTADMISSAO]} AND $P{[MATRICULA], [tr.matricula], [:MATRICULA]} AND $P{[DTNASCIMENTO], [tr.dtnascimento], [:DTNASCIMENTO]} AND $P{[ESTADOCIVIL], [tr.dadosPessoais.estadoCivil], [:ESTADOCIVIL]} AND $P{[TIPOSAL], [tr.tipoSalario], [:TIPOSAL]} AND $P{[NACIONALIDADE], [tr.dadosPessoais.nacionalidade], [:NACIONALIDADE]} AND $P{[TIPOADMISSAO], [tr.tipoAdmissao], [:TIPOADMISSAO]} AND $P{[FGTSOPTANTE], [tr.fgtsOptante], [:FGTSOPTANTE]} AND $P{[PROCESSO], [tr.processo], [:PROCESSO]} AND $P{[TIPOPONTO], [tr.ponto.tipo], [:TIPOPONTO]} AND $P{[DEPDESPESA], [tr.unidade], [:DEPDESPESA]} AND $P{[DIVISAO], [tr.divisao], [:DIVISAO]} AND $P{[SUBDIVISAO], [tr.subdivisao], [:SUBDIVISAO]} AND $P{[VINCULO], [tr.vinculo], [:VINCULO]} AND $P{[CATFUNCIONAL], [tr.categoriaFuncional], [:CATFUNCIONAL]} AND $P{[CARGOATUAL], [tr.cargoAtual], [:CARGOATUAL]} AND $P{[CARGOINICIAL], [tr.cargoInicial], [:CARGOINICIAL]} AND $P{[LOCAL_TRABALHO], [tr.localTrabalho], [:LOCAL_TRABALHO]} AND $P{[INSTRUCAO], [tr.dadosPessoais.instrucao], [:INSTRUCAO]} AND $P{[JORNADA], [tr.jornada], [:JORNADA]} AND $P{[SINDICATO], [tr.sindicato], [:SINDICATO]} AND $P{[CATSEFIP], [tr.categoriaSefip], [:CATSEFIP]} AND $P{[SEFIPTPOCORR], [tr.sefipTipoOcorrencia], [:SEFIPTPOCORR]} AND $P{[CONCURSO], [tr.concurso], [:CONCURSO]} AND $P{[SEXO], [tr.dadosPessoais.caracteristicasFisicas.sexo], [:SEXO]} AND $P{[CESTABASICA], [tr.cestabasica], [:CESTABASICA]} AND $P{[SITUACAO], [tr.situacao], [:SITUACAO]} AND $P{[REFSALATUAL], [tr.salarioAtual], [:REFSALATUAL]} AND $P{[REFSALINICIAL], [tr.salarioInicial], [:REFSALINICIAL]} AND $P{[REFSALATUAL_VALOR], [tr.salarioAtual.valor], [:REFSALATUAL_VALOR]} AND $P{[REFSALINICIAL_VALOR], [tr.salarioInicial], [:REFSALINICIAL_VALOR]} ");
    public static final String COLETIVO_FROM_JOIN = "FROM EventoFixo ef JOIN ef.trabalhador tr JOIN ef.evento ev ";
    public static final String COLETIVO_WHERE = "tr.trabalhadorPK.entidade = :entidadeCodigo AND $P{[EVENTO], [ev], [:EVENTO]} AND $P{[VALOR], [ev.valor], [:VALOR]} AND $P{[PERC], [ev.porcentagem], [:PERC]} AND $P{[QTDE], [ev.quantidade], [:QTDE]} AND $P{[REGISTRO], [tr], [:REGISTRO]} AND $P{[CONTRATO], [tr.contrato], [:CONTRATO]} AND $P{[DTADMISSAO], [tr.dataAdmissao], [:DTADMISSAO]} AND $P{[MATRICULA], [tr.matricula], [:MATRICULA]} AND $P{[DTNASCIMENTO], [tr.dtnascimento], [:DTNASCIMENTO]} AND $P{[ESTADOCIVIL], [tr.dadosPessoais.estadoCivil], [:ESTADOCIVIL]} AND $P{[TIPOSAL], [tr.tipoSalario], [:TIPOSAL]} AND $P{[NACIONALIDADE], [tr.dadosPessoais.nacionalidade], [:NACIONALIDADE]} AND $P{[TIPOADMISSAO], [tr.tipoAdmissao], [:TIPOADMISSAO]} AND $P{[FGTSOPTANTE], [tr.fgtsOptante], [:FGTSOPTANTE]} AND $P{[PROCESSO], [tr.processo], [:PROCESSO]} AND $P{[TIPOPONTO], [tr.ponto.tipo], [:TIPOPONTO]} AND $P{[DEPDESPESA], [tr.unidade], [:DEPDESPESA]} AND $P{[DIVISAO], [tr.divisao], [:DIVISAO]} AND $P{[SUBDIVISAO], [tr.subdivisao], [:SUBDIVISAO]} AND $P{[VINCULO], [tr.vinculo], [:VINCULO]} AND $P{[CATFUNCIONAL], [tr.categoriaFuncional], [:CATFUNCIONAL]} AND $P{[CARGOATUAL], [tr.cargoAtual], [:CARGOATUAL]} AND $P{[CARGOINICIAL], [tr.cargoInicial], [:CARGOINICIAL]} AND $P{[LOCAL_TRABALHO], [tr.localTrabalho], [:LOCAL_TRABALHO]} AND $P{[INSTRUCAO], [tr.dadosPessoais.instrucao], [:INSTRUCAO]} AND $P{[JORNADA], [tr.jornada], [:JORNADA]} AND $P{[SINDICATO], [tr.sindicato], [:SINDICATO]} AND $P{[CATSEFIP], [tr.categoriaSefip], [:CATSEFIP]} AND $P{[SEFIPTPOCORR], [tr.sefipTipoOcorrencia], [:SEFIPTPOCORR]} AND $P{[CONCURSO], [tr.concurso], [:CONCURSO]} AND $P{[SEXO], [tr.dadosPessoais.caracteristicasFisicas.sexo], [:SEXO]} AND $P{[CESTABASICA], [tr.cestabasica], [:CESTABASICA]} AND $P{[SITUACAO], [tr.situacao], [:SITUACAO]} AND $P{[REFSALATUAL], [tr.salarioAtual], [:REFSALATUAL]} AND $P{[REFSALINICIAL], [tr.salarioInicial], [:REFSALINICIAL]} AND $P{[REFSALATUAL_VALOR], [tr.salarioAtual.valor], [:REFSALATUAL_VALOR]} AND $P{[REFSALINICIAL_VALOR], [tr.salarioInicial], [:REFSALINICIAL_VALOR]} ";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    @FilterConfig(label="Id. Opera\u00e7\u00e3o", inputType=FilterInputType.NUMBER)
    private Integer codigo;
    @Size(min=1, max=3)
    @NotNull
    @Column(name="EVENTO")
    private String eventoCodigo;
    @Size(min=1, max=3)
    @NotNull
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @FilterConfig(label="Data Documento", inputType=FilterInputType.CALENDAR)
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @FilterConfig(label="N\u00famero do Documento")
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="QTDE")
    private Double quantidade;
    @Column(name="PORCENTAGEM")
    private Double porcentagem;
    @Column(name="VALOR")
    private Double valor;
    @Size(max=7)
    @Column(name="REFEHOLERIT")
    private String referenciaHolerite;
    @FilterConfig(label="Data Base", inputType=FilterInputType.CALENDAR)
    @Column(name="DATA_BASE")
    @Temporal(value=TemporalType.DATE)
    private Date dataBase;
    @Column(name="DUPLICIDADE")
    private Character duplicidade;
    @FilterConfig(label="Data Limite", inputType=FilterInputType.CALENDAR)
    @Column(name="DATA_LIMITE")
    @Temporal(value=TemporalType.DATE)
    private Date dataLimite;
    @Lob
    @Column(name="PARAMETROS")
    private byte[] parametros;
    @Column(name="USUARIO")
    private Integer usuarioCodigo;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @OneToMany(mappedBy="param", fetch=FetchType.LAZY)
    private List<EventoFixo> eventosfixosList;
    @FilterConfig(label="Usu\u00e1rio", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT u FROM Usuario u WHERE u.nome LIKE '%'||:param||'%'")
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Usuario usuario;
    @FilterConfig(label="Tipo Documento", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM TipoDocumentoLegal t WHERE lower(t.nome) LIKE lower('%'||:param||'%') ORDER BY t.nome")
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Evento", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;

    public EventoFixoParametro() {
    }

    public EventoFixoParametro(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dhinclusao) {
        this.dataHoraInclusao = dhinclusao;
    }

    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double qtde) {
        this.quantidade = qtde;
    }

    public Double getPorcentagem() {
        return this.porcentagem;
    }

    public void setPorcentagem(Double porcentagem) {
        this.porcentagem = porcentagem;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public String getReferenciaHolerite() {
        return this.referenciaHolerite;
    }

    public void setReferenciaHolerite(String refeholerit) {
        this.referenciaHolerite = refeholerit;
    }

    public Date getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(Date dataBase) {
        this.dataBase = dataBase;
    }

    public EventoFixoDuplicidade getDuplicidade() {
        return EventoFixoDuplicidade.get(this.duplicidade);
    }

    public void setDuplicidade(EventoFixoDuplicidade duplicidade) {
        this.duplicidade = duplicidade.getCodigo();
    }

    public Date getDataLimite() {
        return this.dataLimite;
    }

    public void setDataLimite(Date dataLimite) {
        this.dataLimite = dataLimite;
    }

    public byte[] getParametros() {
        return this.parametros;
    }

    public void setParametros(byte[] parametros) {
        this.parametros = parametros;
    }

    public List<EventoFixo> getEventosfixosList() {
        return this.eventosfixosList;
    }

    public void setEventosfixosList(List<EventoFixo> eventosfixosList) {
        this.eventosfixosList = eventosfixosList;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    public void setTipoLegal(TipoDocumentoLegal tipolegal) {
        this.tipoLegal = tipolegal;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento eventos) {
        this.evento = eventos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventoFixoParametro)) {
            return false;
        }
        EventoFixoParametro other = (EventoFixoParametro)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.EventosfixosParam[ codigo=" + this.codigo + " ]";
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public Integer getUsuarioCodigo() {
        return this.usuarioCodigo;
    }

    public void setUsuarioCodigo(Integer usuarioCodigo) {
        this.usuarioCodigo = usuarioCodigo;
    }

    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }
}

