/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Embeddable
public class EventoFixoCessacao
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    @Column(name="TIPOLEGAL_CESSACAO")
    private Integer tipoLegalCodigo;
    @JoinColumn(name="TIPOLEGAL_CESSACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="DATADOC_CESSACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC_CESSACAO")
    private String numeroDocumento;

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegalCodigo = tipoLegal != null ? tipoLegal.getCodigo() : null;
        this.tipoLegal = tipoLegal;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataDocumento) {
        this.dataDocumento = dataDocumento;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventoFixoCessacao that = (EventoFixoCessacao)o;
        if (this.tipoLegalCodigo != null ? !this.tipoLegalCodigo.equals(that.tipoLegalCodigo) : that.tipoLegalCodigo != null) {
            return false;
        }
        if (this.dataDocumento != null ? !this.dataDocumento.equals(that.dataDocumento) : that.dataDocumento != null) {
            return false;
        }
        return this.numeroDocumento != null ? this.numeroDocumento.equals(that.numeroDocumento) : that.numeroDocumento == null;
    }

    public int hashCode() {
        int result = this.tipoLegalCodigo != null ? this.tipoLegalCodigo.hashCode() : 0;
        result = 31 * result + (this.dataDocumento != null ? this.dataDocumento.hashCode() : 0);
        result = 31 * result + (this.numeroDocumento != null ? this.numeroDocumento.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventoFixoConcessao{tipoLegalCodigo=" + this.tipoLegalCodigo + ", dataDocumento=" + this.dataDocumento + ", numeroDocumento='" + this.numeroDocumento + '\'' + '}';
    }
}

