/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoFixoCessacao;
import br.com.fiorilli.sip.persistence.entity.EventoFixoConcessao;
import br.com.fiorilli.sip.persistence.entity.EventoFixoPK;
import br.com.fiorilli.sip.persistence.entity.EventoFixoParametro;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="EVENTOSFIXOS")
@Audited
public class EventoFixo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT ef FROM EventoFixo ef LEFT JOIN FETCH ef.evento ev JOIN FETCH ef.trabalhador tr WHERE tr.trabalhadorPK = :trabalhadorPK AND ev.classificacao NOT IN ('03', '08', '22')";
    public static final String FIND_BY_TRABALHADOR_UNIDADE = "SELECT ef FROM EventoFixo ef JOIN ef.trabalhador tr WHERE tr.trabalhadorPK = :trabalhadorPK AND ef.unidadeCodigo = :unidade";
    public static final String UPDATE_EVENTO = "UPDATE EventoFixo ev SET ev.eventoFixoPK.evento = :eventoDestinoCodigo WHERE ev.eventoFixoPK IN :eventosFixos";
    public static final String GET_NEXT_ITEM = "SELECT COALESCE(MAX(ef.eventoFixoPK.item), 0) + 1 FROM EventoFixo ef WHERE ef.eventoFixoPK.entidade = :entidadeCodigo AND ef.eventoFixoPK.registro = :registro AND ef.eventoFixoPK.evento = :eventoCodigo";
    public static final String IS_THERE = "Select CASE WHEN COALESCE(COUNT(tr.trabalhadorPK.registro), 0) > 0 THEN true ELSE false END FROM EventoFixo ef JOIN ef.trabalhador tr JOIN ef.evento ev  WHERE ev.eventoPK.codigo = :novoEventoFixo AND tr.trabalhadorPK.entidade = :entidadeCodigo AND $P{[EVENTO], [ev], [:EVENTO]} AND $P{[VALOR], [ev.valor], [:VALOR]} AND $P{[PERC], [ev.porcentagem], [:PERC]} AND $P{[QTDE], [ev.quantidade], [:QTDE]} AND $P{[REGISTRO], [tr], [:REGISTRO]} AND $P{[CONTRATO], [tr.contrato], [:CONTRATO]} AND $P{[DTADMISSAO], [tr.dataAdmissao], [:DTADMISSAO]} AND $P{[MATRICULA], [tr.matricula], [:MATRICULA]} AND $P{[DTNASCIMENTO], [tr.dtnascimento], [:DTNASCIMENTO]} AND $P{[ESTADOCIVIL], [tr.dadosPessoais.estadoCivil], [:ESTADOCIVIL]} AND $P{[TIPOSAL], [tr.tipoSalario], [:TIPOSAL]} AND $P{[NACIONALIDADE], [tr.dadosPessoais.nacionalidade], [:NACIONALIDADE]} AND $P{[TIPOADMISSAO], [tr.tipoAdmissao], [:TIPOADMISSAO]} AND $P{[FGTSOPTANTE], [tr.fgtsOptante], [:FGTSOPTANTE]} AND $P{[PROCESSO], [tr.processo], [:PROCESSO]} AND $P{[TIPOPONTO], [tr.ponto.tipo], [:TIPOPONTO]} AND $P{[DEPDESPESA], [tr.unidade], [:DEPDESPESA]} AND $P{[DIVISAO], [tr.divisao], [:DIVISAO]} AND $P{[SUBDIVISAO], [tr.subdivisao], [:SUBDIVISAO]} AND $P{[VINCULO], [tr.vinculo], [:VINCULO]} AND $P{[CATFUNCIONAL], [tr.categoriaFuncional], [:CATFUNCIONAL]} AND $P{[CARGOATUAL], [tr.cargoAtual], [:CARGOATUAL]} AND $P{[CARGOINICIAL], [tr.cargoInicial], [:CARGOINICIAL]} AND $P{[LOCAL_TRABALHO], [tr.localTrabalho], [:LOCAL_TRABALHO]} AND $P{[INSTRUCAO], [tr.dadosPessoais.instrucao], [:INSTRUCAO]} AND $P{[JORNADA], [tr.jornada], [:JORNADA]} AND $P{[SINDICATO], [tr.sindicato], [:SINDICATO]} AND $P{[CATSEFIP], [tr.categoriaSefip], [:CATSEFIP]} AND $P{[SEFIPTPOCORR], [tr.sefipTipoOcorrencia], [:SEFIPTPOCORR]} AND $P{[CONCURSO], [tr.concurso], [:CONCURSO]} AND $P{[SEXO], [tr.dadosPessoais.caracteristicasFisicas.sexo], [:SEXO]} AND $P{[CESTABASICA], [tr.cestabasica], [:CESTABASICA]} AND $P{[SITUACAO], [tr.situacao], [:SITUACAO]} AND $P{[REFSALATUAL], [tr.salarioAtual], [:REFSALATUAL]} AND $P{[REFSALINICIAL], [tr.salarioInicial], [:REFSALINICIAL]} AND $P{[REFSALATUAL_VALOR], [tr.salarioAtual.valor], [:REFSALATUAL_VALOR]} AND $P{[REFSALINICIAL_VALOR], [tr.salarioInicial], [:REFSALINICIAL_VALOR]} ";
    public static final String FIND_FOR_INSERT = "SELECT tr.trabalhadorPK.entidade AS entidade, tr.trabalhadorPK.registro AS registro, MAX(CASE WHEN ev.eventoPK.codigo = :novoEventoFixo THEN ef.eventoFixoPK.item ELSE 0 END) AS item FROM EventoFixo ef JOIN ef.trabalhador tr JOIN ef.evento ev  WHERE tr.trabalhadorPK.entidade = :entidadeCodigo AND $P{[EVENTO], [ev], [:EVENTO]} AND $P{[VALOR], [ev.valor], [:VALOR]} AND $P{[PERC], [ev.porcentagem], [:PERC]} AND $P{[QTDE], [ev.quantidade], [:QTDE]} AND $P{[REGISTRO], [tr], [:REGISTRO]} AND $P{[CONTRATO], [tr.contrato], [:CONTRATO]} AND $P{[DTADMISSAO], [tr.dataAdmissao], [:DTADMISSAO]} AND $P{[MATRICULA], [tr.matricula], [:MATRICULA]} AND $P{[DTNASCIMENTO], [tr.dtnascimento], [:DTNASCIMENTO]} AND $P{[ESTADOCIVIL], [tr.dadosPessoais.estadoCivil], [:ESTADOCIVIL]} AND $P{[TIPOSAL], [tr.tipoSalario], [:TIPOSAL]} AND $P{[NACIONALIDADE], [tr.dadosPessoais.nacionalidade], [:NACIONALIDADE]} AND $P{[TIPOADMISSAO], [tr.tipoAdmissao], [:TIPOADMISSAO]} AND $P{[FGTSOPTANTE], [tr.fgtsOptante], [:FGTSOPTANTE]} AND $P{[PROCESSO], [tr.processo], [:PROCESSO]} AND $P{[TIPOPONTO], [tr.ponto.tipo], [:TIPOPONTO]} AND $P{[DEPDESPESA], [tr.unidade], [:DEPDESPESA]} AND $P{[DIVISAO], [tr.divisao], [:DIVISAO]} AND $P{[SUBDIVISAO], [tr.subdivisao], [:SUBDIVISAO]} AND $P{[VINCULO], [tr.vinculo], [:VINCULO]} AND $P{[CATFUNCIONAL], [tr.categoriaFuncional], [:CATFUNCIONAL]} AND $P{[CARGOATUAL], [tr.cargoAtual], [:CARGOATUAL]} AND $P{[CARGOINICIAL], [tr.cargoInicial], [:CARGOINICIAL]} AND $P{[LOCAL_TRABALHO], [tr.localTrabalho], [:LOCAL_TRABALHO]} AND $P{[INSTRUCAO], [tr.dadosPessoais.instrucao], [:INSTRUCAO]} AND $P{[JORNADA], [tr.jornada], [:JORNADA]} AND $P{[SINDICATO], [tr.sindicato], [:SINDICATO]} AND $P{[CATSEFIP], [tr.categoriaSefip], [:CATSEFIP]} AND $P{[SEFIPTPOCORR], [tr.sefipTipoOcorrencia], [:SEFIPTPOCORR]} AND $P{[CONCURSO], [tr.concurso], [:CONCURSO]} AND $P{[SEXO], [tr.dadosPessoais.caracteristicasFisicas.sexo], [:SEXO]} AND $P{[CESTABASICA], [tr.cestabasica], [:CESTABASICA]} AND $P{[SITUACAO], [tr.situacao], [:SITUACAO]} AND $P{[REFSALATUAL], [tr.salarioAtual], [:REFSALATUAL]} AND $P{[REFSALINICIAL], [tr.salarioInicial], [:REFSALINICIAL]} AND $P{[REFSALATUAL_VALOR], [tr.salarioAtual.valor], [:REFSALATUAL_VALOR]} AND $P{[REFSALINICIAL_VALOR], [tr.salarioInicial], [:REFSALINICIAL_VALOR]}  GROUP BY tr.trabalhadorPK.entidade, tr.trabalhadorPK.registro ";
    public static final String FIND_FOR_UPDATE = "SELECT DISTINCT ef.eventoFixoPK FROM EventoFixo ef JOIN ef.trabalhador tr JOIN ef.evento ev  WHERE ev = :eventoOrigem AND tr.trabalhadorPK.entidade = :entidadeCodigo AND $P{[EVENTO], [ev], [:EVENTO]} AND $P{[VALOR], [ev.valor], [:VALOR]} AND $P{[PERC], [ev.porcentagem], [:PERC]} AND $P{[QTDE], [ev.quantidade], [:QTDE]} AND $P{[REGISTRO], [tr], [:REGISTRO]} AND $P{[CONTRATO], [tr.contrato], [:CONTRATO]} AND $P{[DTADMISSAO], [tr.dataAdmissao], [:DTADMISSAO]} AND $P{[MATRICULA], [tr.matricula], [:MATRICULA]} AND $P{[DTNASCIMENTO], [tr.dtnascimento], [:DTNASCIMENTO]} AND $P{[ESTADOCIVIL], [tr.dadosPessoais.estadoCivil], [:ESTADOCIVIL]} AND $P{[TIPOSAL], [tr.tipoSalario], [:TIPOSAL]} AND $P{[NACIONALIDADE], [tr.dadosPessoais.nacionalidade], [:NACIONALIDADE]} AND $P{[TIPOADMISSAO], [tr.tipoAdmissao], [:TIPOADMISSAO]} AND $P{[FGTSOPTANTE], [tr.fgtsOptante], [:FGTSOPTANTE]} AND $P{[PROCESSO], [tr.processo], [:PROCESSO]} AND $P{[TIPOPONTO], [tr.ponto.tipo], [:TIPOPONTO]} AND $P{[DEPDESPESA], [tr.unidade], [:DEPDESPESA]} AND $P{[DIVISAO], [tr.divisao], [:DIVISAO]} AND $P{[SUBDIVISAO], [tr.subdivisao], [:SUBDIVISAO]} AND $P{[VINCULO], [tr.vinculo], [:VINCULO]} AND $P{[CATFUNCIONAL], [tr.categoriaFuncional], [:CATFUNCIONAL]} AND $P{[CARGOATUAL], [tr.cargoAtual], [:CARGOATUAL]} AND $P{[CARGOINICIAL], [tr.cargoInicial], [:CARGOINICIAL]} AND $P{[LOCAL_TRABALHO], [tr.localTrabalho], [:LOCAL_TRABALHO]} AND $P{[INSTRUCAO], [tr.dadosPessoais.instrucao], [:INSTRUCAO]} AND $P{[JORNADA], [tr.jornada], [:JORNADA]} AND $P{[SINDICATO], [tr.sindicato], [:SINDICATO]} AND $P{[CATSEFIP], [tr.categoriaSefip], [:CATSEFIP]} AND $P{[SEFIPTPOCORR], [tr.sefipTipoOcorrencia], [:SEFIPTPOCORR]} AND $P{[CONCURSO], [tr.concurso], [:CONCURSO]} AND $P{[SEXO], [tr.dadosPessoais.caracteristicasFisicas.sexo], [:SEXO]} AND $P{[CESTABASICA], [tr.cestabasica], [:CESTABASICA]} AND $P{[SITUACAO], [tr.situacao], [:SITUACAO]} AND $P{[REFSALATUAL], [tr.salarioAtual], [:REFSALATUAL]} AND $P{[REFSALINICIAL], [tr.salarioInicial], [:REFSALINICIAL]} AND $P{[REFSALATUAL_VALOR], [tr.salarioAtual.valor], [:REFSALATUAL_VALOR]} AND $P{[REFSALINICIAL_VALOR], [tr.salarioInicial], [:REFSALINICIAL_VALOR]} ";
    public static final String EXISTS_BY_TRABALHADOR_EVENTO = "SELECT ef FROM EventoFixo ef JOIN FETCH ef.trabalhador tr WHERE tr.trabalhadorPK = :trabalhadorPK AND ef.eventoFixoPK.evento = :evento";
    @EmbeddedId
    protected EventoFixoPK eventoFixoPK;
    @Column(name="QTDE")
    private Double qtde;
    @Column(name="VALOR")
    private Double valor;
    @Column(name="PERC")
    private Double perc;
    @Size(max=7)
    @Column(name="REFERENCIA")
    private String referencia;
    @Column(name="QTDHORAS")
    private Double qtdhoras;
    @Column(name="DATA_BASE")
    @Temporal(value=TemporalType.DATE)
    private Date dataBase;
    @Type(type="BooleanTypeSip")
    @Column(name="ATIVO")
    private Boolean ativo;
    @Column(name="DATA_LIMITE")
    @Temporal(value=TemporalType.DATE)
    private Date dataLimite;
    @Column(name="DEPDESPESA")
    private Integer unidadeCodigo;
    @JoinColumn(name="DEPDESPESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade unidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Embedded
    private EventoFixoCessacao cessacao;
    @Embedded
    private EventoFixoConcessao concessao;
    @JoinColumn(name="PARAM", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private EventoFixoParametro param;
    @Column(name="EVENTO", insertable=false, updatable=false)
    private String eventoCodigo;
    @FilterConfig(label="Evento", condition=FilterCondition.IGUAL, blockCondition=true, inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @Size(max=512)
    @Column(name="OBS")
    private String obs;

    public EventoFixo() {
    }

    public EventoFixo(EventoFixoPK eventoFixoPK) {
        this.eventoFixoPK = eventoFixoPK;
    }

    public EventoFixo(String entidade, String registro, String evento, short item) {
        this.eventoFixoPK = new EventoFixoPK(entidade, registro, evento, item);
    }

    public EventoFixoPK getEventosfixosPK() {
        if (this.eventoFixoPK == null) {
            this.eventoFixoPK = new EventoFixoPK();
        }
        return this.eventoFixoPK;
    }

    public void setEventosfixosPK(EventoFixoPK eventoFixoPK) {
        this.eventoFixoPK = eventoFixoPK;
    }

    public Double getQtde() {
        return this.qtde;
    }

    public void setQtde(Double qtde) {
        this.qtde = qtde;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public Double getPerc() {
        return this.perc;
    }

    public void setPerc(Double perc) {
        this.perc = perc;
    }

    public String getReferencia() {
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    public Double getQtdhoras() {
        return this.qtdhoras;
    }

    public void setQtdhoras(Double qtdhoras) {
        this.qtdhoras = qtdhoras;
    }

    public Date getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(Date dataBase) {
        this.dataBase = dataBase;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public Date getDataLimite() {
        return this.dataLimite;
    }

    public void setDataLimite(Date dataLimite) {
        this.dataLimite = dataLimite;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade depdespesa) {
        this.unidade = depdespesa;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.getEventosfixosPK().setEntidade(this.trabalhador.getTrabalhadorPK().getEntidade());
            this.getEventosfixosPK().setRegistro(this.trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.getEventosfixosPK().setEntidade(null);
            this.getEventosfixosPK().setRegistro(null);
        }
    }

    public EventoFixoParametro getParam() {
        return this.param;
    }

    public void setParam(EventoFixoParametro param) {
        this.param = param;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.evento = evento;
        if (this.evento != null) {
            this.eventoCodigo = this.evento.getEventoPK().getCodigo();
            this.getEventosfixosPK().setEvento(evento.getEventoPK().getCodigo());
        } else {
            this.eventoCodigo = null;
        }
    }

    public Integer getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public void setUnidadeCodigo(Integer unidadeCodigo) {
        this.unidadeCodigo = unidadeCodigo;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.eventoFixoPK != null ? this.eventoFixoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventoFixo)) {
            return false;
        }
        EventoFixo other = (EventoFixo)object;
        return (this.eventoFixoPK != null || other.eventoFixoPK == null) && (this.eventoFixoPK == null || this.eventoFixoPK.equals(other.eventoFixoPK));
    }

    public String toString() {
        return "entity.Eventosfixos[ eventosfixosPK=" + this.eventoFixoPK + " ]";
    }

    public EventoFixoCessacao getCessacao() {
        if (this.cessacao == null) {
            this.cessacao = new EventoFixoCessacao();
        }
        return this.cessacao;
    }

    public void setCessacao(EventoFixoCessacao cessacao) {
        this.cessacao = cessacao;
    }

    public EventoFixoConcessao getConcessao() {
        if (this.concessao == null) {
            this.concessao = new EventoFixoConcessao();
        }
        return this.concessao;
    }

    public void setConcessao(EventoFixoConcessao concessao) {
        this.concessao = concessao;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }
}

