/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoDespesaMedicaPK;
import br.com.fiorilli.sip.persistence.entity.EventosDespMedicaIdades;
import br.com.fiorilli.sip.persistence.entity.Movimento;
import br.com.fiorilli.sip.persistence.entity.TipoValor;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="EVENTOS_DESPMEDICA")
@Audited
public class EventoDespesaMedica
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT ed FROM EventoDespesaMedica ed LEFT JOIN FETCH ed.evento e  WHERE e.eventoPK = :pk ORDER BY ed.eventoDespesaMedicaPK.evento";
    @EmbeddedId
    protected EventoDespesaMedicaPK eventoDespesaMedicaPK;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=18)
    @Column(name="CNPJ")
    private String cnpj;
    @Size(max=6)
    @Column(name="NUMERO_ANS")
    private String numeroAns;
    @Column(name="TIPOVALOR")
    private Short tipoValor;
    @Column(name="PARTE_ENTIDADE")
    private Short parteEntidade;
    @Column(name="SEPARAR_VALORES_CALCULADOS")
    private Boolean separarValorCalculados;
    @Column(name="ENVIAR_DIRF")
    private Boolean enviarDirf;
    @Column(name="ENVIAR_INFORME")
    private Boolean enviarInforme;
    @Size(min=1, max=3)
    @Column(name="EVENTO", insertable=false, updatable=false)
    private String codigoEvento;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="eventoDespesaMedica")
    private List<Movimento> movimentos;
    @OneToMany(mappedBy="eventoDespesaMedica", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventosDespMedicaIdades> eventosDespMedicaIdadades;

    public EventoDespesaMedica() {
    }

    public EventoDespesaMedica(EventoDespesaMedicaPK eventosDespmedicaPK) {
        this.eventoDespesaMedicaPK = eventosDespmedicaPK;
    }

    public EventoDespesaMedica(String entidade, String evento) {
        this.eventoDespesaMedicaPK = new EventoDespesaMedicaPK(entidade, evento);
    }

    public EventoDespesaMedicaPK getEventoDespesaMedicaPK() {
        if (this.eventoDespesaMedicaPK == null) {
            this.eventoDespesaMedicaPK = new EventoDespesaMedicaPK();
        }
        return this.eventoDespesaMedicaPK;
    }

    public void setEventoDespesaMedicaPK(EventoDespesaMedicaPK eventosDespmedicaPK) {
        this.eventoDespesaMedicaPK = eventosDespmedicaPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.eventoDespesaMedicaPK != null ? this.eventoDespesaMedicaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventoDespesaMedica)) {
            return false;
        }
        EventoDespesaMedica other = (EventoDespesaMedica)object;
        return (this.eventoDespesaMedicaPK != null || other.eventoDespesaMedicaPK == null) && (this.eventoDespesaMedicaPK == null || this.eventoDespesaMedicaPK.equals(other.eventoDespesaMedicaPK));
    }

    public String toString() {
        return "entity.EventosDespmedica[ eventosDespmedicaPK=" + this.eventoDespesaMedicaPK + " ]";
    }

    public String getNumeroAns() {
        return this.numeroAns;
    }

    public void setNumeroAns(String numeroAns) {
        this.numeroAns = numeroAns;
    }

    public TipoValor getTipoValor() {
        return TipoValor.toEntity(this.tipoValor);
    }

    public void setTipoValor(TipoValor tipoValor) {
        if (tipoValor == null) {
            tipoValor = TipoValor.VALOR_FIXO;
        } else {
            this.tipoValor = tipoValor.getId();
        }
    }

    public Short getParteEntidade() {
        return this.parteEntidade;
    }

    public void setParteEntidade(Short parteEntidade) {
        this.parteEntidade = parteEntidade;
    }

    public Boolean getSepararValorCalculados() {
        return this.separarValorCalculados;
    }

    public void setSepararValorCalculados(Boolean separarValorCalculados) {
        this.separarValorCalculados = separarValorCalculados;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String codigoEvento) {
        this.codigoEvento = codigoEvento;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.getEventoDespesaMedicaPK().setEntidade(evento.getEventoPK().getEntidade());
            this.getEventoDespesaMedicaPK().setEvento(evento.getEventoPK().getCodigo());
        } else {
            this.getEventoDespesaMedicaPK().setEntidade(null);
            this.getEventoDespesaMedicaPK().setEvento(null);
        }
        this.evento = evento;
    }

    public List<EventosDespMedicaIdades> getEventosDespMedicaIdadades() {
        return this.eventosDespMedicaIdadades;
    }

    public void setEventosDespMedicaIdadades(List<EventosDespMedicaIdades> eventosDespMedicaIdadades) {
        this.eventosDespMedicaIdadades = eventosDespMedicaIdadades;
    }

    public Boolean getEnviarDirf() {
        return this.enviarDirf;
    }

    public void setEnviarDirf(Boolean enviarDirf) {
        this.enviarDirf = enviarDirf;
    }

    public Boolean getEnviarInforme() {
        return this.enviarInforme;
    }

    public void setEnviarInforme(Boolean enviarInforme) {
        this.enviarInforme = enviarInforme;
    }
}

