/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoComplementarPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="EVENTO_COMPLEMENTAR")
@FilterConfigType(query="SELECT $R{[e.eventoComplementarPK.eventoNormalCodigo],[e]} FROM EventoComplementar e JOIN FETCH e.eventoNormal JOIN FETCH e.eventoDemonstrarProvento JOIN FETCH e.eventoDemonstrarDesconto WHERE $P{[eventoNormal],[e.eventoNormal],[:eventoNormal]}")
@Audited
public class EventoComplementar
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY = "SELECT $R{[e.eventoComplementarPK.eventoNormalCodigo],[e]} FROM EventoComplementar e JOIN FETCH e.eventoNormal JOIN FETCH e.eventoDemonstrarProvento JOIN FETCH e.eventoDemonstrarDesconto WHERE $P{[eventoNormal],[e.eventoNormal],[:eventoNormal]}";
    @EmbeddedId
    protected EventoComplementarPK eventoComplementarPK;
    @NotNull
    @Column(name="EVENTO_COMPLE", nullable=false)
    private String eventoDemonstrarProventoCodigo;
    @NotNull
    @Column(name="EVENTO_DESCON", nullable=false)
    private String eventoDemonstrarDescontoCodigo;
    @FilterConfig(label="Evento Normal", inputType=FilterInputType.AUTO_COMPLETE, condition=FilterCondition.IGUAL, blockCondition=true)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_NORMAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne
    private Evento eventoNormal;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_COMPLE", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne
    private Evento eventoDemonstrarProvento;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_DESCON", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne
    private Evento eventoDemonstrarDesconto;

    public EventoComplementar() {
    }

    public String getEventoDemonstrarProventoCodigo() {
        return this.eventoDemonstrarProventoCodigo;
    }

    public void setEventoDemonstrarProventoCodigo(String eventoDemonstrarProvento) {
        this.eventoDemonstrarProventoCodigo = eventoDemonstrarProvento;
    }

    public String getEventoDemonstrarDescontoCodigo() {
        return this.eventoDemonstrarDescontoCodigo;
    }

    public void setEventoDemonstrarDescontoCodigo(String eventoDemonstrarDesconto) {
        this.eventoDemonstrarDescontoCodigo = eventoDemonstrarDesconto;
    }

    public EventoComplementar(EventoComplementarPK eventoComplementarPK) {
        this.eventoComplementarPK = eventoComplementarPK;
    }

    public EventoComplementar(String entidade, String eventoNormal) {
        this.eventoComplementarPK = new EventoComplementarPK(entidade, eventoNormal);
    }

    public EventoComplementarPK getEventoComplementarPK() {
        return this.eventoComplementarPK;
    }

    public void setEventoComplementarPK(EventoComplementarPK eventoComplementarPK) {
        this.eventoComplementarPK = eventoComplementarPK;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.eventoComplementarPK != null ? this.eventoComplementarPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventoComplementar)) {
            return false;
        }
        EventoComplementar other = (EventoComplementar)object;
        return (this.eventoComplementarPK != null || other.eventoComplementarPK == null) && (this.eventoComplementarPK == null || this.eventoComplementarPK.equals(other.eventoComplementarPK));
    }

    public String toString() {
        return "entity.EventoComplementar[ eventoComplementarPK=" + this.eventoComplementarPK + " ]";
    }

    public Evento getEventoNormal() {
        return this.eventoNormal;
    }

    public void setEventoNormal(Evento eventoNormal) {
        if (eventoNormal != null) {
            this.eventoComplementarPK.setEventoNormalCodigo(eventoNormal.getEventoPK().getCodigo());
        } else {
            this.eventoComplementarPK.setEventoNormalCodigo(null);
        }
        this.eventoNormal = eventoNormal;
    }

    public Evento getEventoDemonstrarProvento() {
        return this.eventoDemonstrarProvento;
    }

    public void setEventoDemonstrarProvento(Evento eventoDemonstrativoProvento) {
        this.eventoDemonstrarProventoCodigo = eventoDemonstrativoProvento != null ? eventoDemonstrativoProvento.getEventoPK().getCodigo() : null;
        this.eventoDemonstrarProvento = eventoDemonstrativoProvento;
    }

    public Evento getEventoDemonstrarDesconto() {
        return this.eventoDemonstrarDesconto;
    }

    public void setEventoDemonstrarDesconto(Evento eventoDemonstrativoDesconto) {
        this.eventoDemonstrarDescontoCodigo = eventoDemonstrativoDesconto != null ? eventoDemonstrativoDesconto.getEventoPK().getCodigo() : null;
        this.eventoDemonstrarDesconto = eventoDemonstrativoDesconto;
    }
}

