/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.Arrays;
import java.util.List;

public enum EventoClassificacao {
    SEM_CLASSIFICACAO("00", "Sem Classifica\u00e7\u00e3o"),
    HORA_EXTRA("01", "01 - Hora Extra"),
    BOLSA_ESTUDO("02", "02 - Bolsa de Estudo"),
    INDICADOR("03", "03 - Indicador"),
    DESP_REC_EXTRA_PASEP("04", "04 - Desp./Rec.Extra, PASEP, etc..."),
    FALTA_JUSTIFICADA("05", "05 - Faltas Justificadas"),
    FALTA_INJUSTIFICADA("06", "06 - Faltas Injustificadas"),
    FALTA_ABONADA("07", "07 - Faltas Abonadas"),
    BASE_CALCULO("08", "08 - Base de C\u00e1lculo"),
    GRATIFICACAO_RESCISORIA("09", "09 - Gratifica\u00e7\u00e3o Rescis\u00f3ria (RAIS)"),
    MULTA_RESCISORIA_FGTS("10", "10 - Multa Rescis\u00f3ria FGTS"),
    REFERENTE_IRRF("11", "11 - Referente I.R.R.F. (DIRF)"),
    INSALUBRIDADE("12", "12 - INSALUBRIDADE"),
    PERICULOSIDADE("13", "13 - PERICULOSIDADE"),
    CONVENIO_CONSIGNACAO("14", "14 - Conv\u00eanio/Consigna\u00e7\u00e3o"),
    SALARIO_FAMILIA("15", "15 - Sal\u00e1rio Fam\u00edlia (SEFIP)"),
    SALARIO_MATERNIDADE("16", "16 - Sal\u00e1rio Maternidade (SEFIP)"),
    BENEFICIOS_ASSISTENCIAIS("17", "17 - Benef\u00edcios Assistenciais"),
    SUSPENSAO("18", "18 - Suspens\u00e3o"),
    BONIFICACAO("19", "19 - Bonifica\u00e7\u00f5es"),
    PARTICICACAO_RESULTADOS("20", "20 - Partifica\u00e7\u00e3o de Resultados"),
    REDUTOR_SALARIAL("21", "21 - Redutor Salarial"),
    CESTA_BASICA("22", "22 - Cesta B\u00e1sica"),
    FALTA_ABONADA_DEMONSTRACAO("23", "23 - Falta Abonada com Demonstra\u00e7\u00e3o"),
    ADICIONAL_NOTURNO("24", "24 - Adicional Noturno"),
    HORA_AULA("25", "25 - Hora Aula"),
    GRATIFICACOES("26", "26 - Gratifica\u00e7\u00f5es"),
    REFERENCIA_SALARIAL_ANTERIOR("27", "27 - Refer\u00eancia Salarial Anterior"),
    ABATIMENTO_DIARIA("28", "28 - Abatimento de Di\u00e1ria"),
    IPERGS("29", "29 - IPERGS"),
    ATS("30", "30 - A.T.S."),
    SEXTA_PARTE("31", "31 - Sexta Parte"),
    AUXILIOS("32", "32 - Aux\u00edlios"),
    PATRONAL_IPERGS("33", "33 - Patronal IPERGS"),
    ABONO_PERMANENCIA("34", "34 - Abono Perman\u00eancia"),
    FUNCAO_GRATIFICADA("35", "35 - Fun\u00e7\u00e3o Gratificada"),
    SEGUROS("36", "36 - Seguros"),
    COMPENSACAO_PREVIDENCIARIA_ENTRE_REGIMES("37", "37 - Compensa\u00e7\u00e3o Previdenci\u00e1ria entre Regimes"),
    SOBREAVISO("38", "38 - Sobreaviso"),
    ACOMPANHAR_PESSOA_FAMILIA("39", "39 - Acompanhar Pessoa da Fam\u00edlia"),
    GRATIFICACAO_CARGO_COMISSAO("40", "40 - Gratifica\u00e7\u00e3o Cargo em Comiss\u00e3o"),
    HORA_EXTRA_NOTURNA("41", "41 - Hora Extra Noturna"),
    CASSEMS("42", "42 - CASSEMS"),
    VALE_ALIMENTACAO("43", "43 - Vale Alimenta\u00e7\u00e3o"),
    SUBSTITUICAO("44", "44 - Substitui\u00e7\u00e3o"),
    DOACAO_SANGUE("47", "47 - Doa\u00e7\u00e3o de Sangue"),
    SALARIO_BASE("99", "99 - Sal\u00e1rio Base");

    private final String id;
    private final String label;
    private static final EventoClassificacao[] FALTAS;

    public static final EventoClassificacao parse(String id) {
        for (EventoClassificacao c : EventoClassificacao.values()) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return SEM_CLASSIFICACAO;
    }

    private EventoClassificacao(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public String getLabelWithoutId() {
        try {
            return this.label.substring(this.label.lastIndexOf(45) + 1).trim();
        }
        catch (Exception e) {
            return this.label;
        }
    }

    public boolean isHoraExtra() {
        return this.equals((Object)HORA_EXTRA);
    }

    public boolean isAdicionalNoturno() {
        return this.equals((Object)ADICIONAL_NOTURNO);
    }

    public boolean isHoraExtraNoturna() {
        return this.equals((Object)HORA_EXTRA_NOTURNA);
    }

    public boolean isFaltaAbonada(Boolean withDemonstracao) {
        return this.equals((Object)FALTA_ABONADA) || withDemonstracao != false && this.equals((Object)FALTA_ABONADA_DEMONSTRACAO);
    }

    public boolean isFaltaAbonadaDemonstracao() {
        return this.equals((Object)FALTA_ABONADA_DEMONSTRACAO);
    }

    public boolean isFaltaInjustificada() {
        return this.equals((Object)FALTA_INJUSTIFICADA);
    }

    public boolean isFaltaJustificada() {
        return this.equals((Object)FALTA_JUSTIFICADA);
    }

    public boolean isHoraAula() {
        return this == HORA_AULA;
    }

    public boolean isSuspensao() {
        return this.equals((Object)SUSPENSAO);
    }

    public boolean isValeAlimentacao() {
        return this.equals((Object)VALE_ALIMENTACAO);
    }

    public boolean isFalta() {
        Boolean result = Boolean.FALSE;
        for (EventoClassificacao c : FALTAS) {
            if (!c.equals((Object)this)) continue;
            result = Boolean.TRUE;
        }
        return result;
    }

    public static List<EventoClassificacao> getOcultosNoMovimento() {
        return Arrays.asList(INDICADOR, FALTA_ABONADA, BASE_CALCULO, CESTA_BASICA, VALE_ALIMENTACAO);
    }

    public static List<String> ofFaltasJustificadas() {
        return Arrays.asList(EventoClassificacao.FALTA_JUSTIFICADA.id, EventoClassificacao.FALTA_ABONADA.id, EventoClassificacao.FALTA_ABONADA_DEMONSTRACAO.id);
    }

    static {
        FALTAS = new EventoClassificacao[]{FALTA_ABONADA, FALTA_ABONADA_DEMONSTRACAO, FALTA_INJUSTIFICADA, FALTA_JUSTIFICADA};
    }
}

