/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoCargoPK;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="EVENTOS_CARGO")
@Audited
public class EventoCargo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CARGO = "SELECT ec FROM EventoCargo ec LEFT JOIN FETCH ec.evento WHERE ec.cargo.cargoPK = :cargoPK ";
    @EmbeddedId
    private EventoCargoPK pk = new EventoCargoPK();
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Cargo cargo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento evento;

    public EventoCargoPK getPk() {
        if (this.pk == null) {
            this.pk = new EventoCargoPK();
        }
        return this.pk;
    }

    public void setPk(EventoCargoPK id) {
        this.pk = id;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        if (cargo != null && cargo.getCargoPK() != null) {
            this.getPk().setEntidadeCodigo(cargo.getCargoPK().getEntidade());
            this.getPk().setCargoCodigo(cargo.getCargoPK().getCodigo());
        } else {
            this.getPk().setEntidadeCodigo(null);
            this.getPk().setCargoCodigo(null);
        }
        this.cargo = cargo;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null && evento.getEventoPK() != null) {
            this.getPk().setEntidadeCodigo(evento.getEventoPK().getEntidade());
            this.getPk().setEventoCodigo(evento.getEventoPK().getCodigo());
        } else {
            this.getPk().setEntidadeCodigo(null);
            this.getPk().setEventoCodigo(null);
        }
        this.evento = evento;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventoCargo other = (EventoCargo)obj;
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }
}

