/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Adicltemposervico;
import br.com.fiorilli.sip.persistence.entity.Banco;
import br.com.fiorilli.sip.persistence.entity.BancoHorasLancamento;
import br.com.fiorilli.sip.persistence.entity.ClassificacaoContabilEvento;
import br.com.fiorilli.sip.persistence.entity.ClassificacaoInformeRendimentosEvento;
import br.com.fiorilli.sip.persistence.entity.CriterioResultado;
import br.com.fiorilli.sip.persistence.entity.DocumentoCriacaoBasic;
import br.com.fiorilli.sip.persistence.entity.DocumentoExtincaoBasic;
import br.com.fiorilli.sip.persistence.entity.ESocialClassificacaoRubrica;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.EventoClassificacao;
import br.com.fiorilli.sip.persistence.entity.EventoDespesaMedica;
import br.com.fiorilli.sip.persistence.entity.EventoFormaAcumulada;
import br.com.fiorilli.sip.persistence.entity.EventoFormula;
import br.com.fiorilli.sip.persistence.entity.EventoIncidencia;
import br.com.fiorilli.sip.persistence.entity.EventoNatureza;
import br.com.fiorilli.sip.persistence.entity.EventoPK;
import br.com.fiorilli.sip.persistence.entity.EventoPerdeAvoBeneficio;
import br.com.fiorilli.sip.persistence.entity.EventoRateio;
import br.com.fiorilli.sip.persistence.entity.EventoTCESP;
import br.com.fiorilli.sip.persistence.entity.EventoTceMg;
import br.com.fiorilli.sip.persistence.entity.EventoTcmgo;
import br.com.fiorilli.sip.persistence.entity.EventoTempoServico;
import br.com.fiorilli.sip.persistence.entity.EventosAlteracoes;
import br.com.fiorilli.sip.persistence.entity.EventosAritimetica;
import br.com.fiorilli.sip.persistence.entity.EventosExclusao;
import br.com.fiorilli.sip.persistence.entity.EventosGatilho;
import br.com.fiorilli.sip.persistence.entity.FiltroEvento;
import br.com.fiorilli.sip.persistence.entity.PermissoesPerfilEvento;
import br.com.fiorilli.sip.persistence.entity.ProcessoAdmJudicial;
import br.com.fiorilli.sip.persistence.entity.SipmsEvento;
import br.com.fiorilli.sip.persistence.entity.SipmtEvento;
import br.com.fiorilli.sip.persistence.entity.SippeEvento;
import br.com.fiorilli.sip.persistence.entity.SipprEvento;
import br.com.fiorilli.sip.persistence.entity.SiprnEvento;
import br.com.fiorilli.sip.persistence.entity.SiproEvento;
import br.com.fiorilli.sip.persistence.entity.TipoCalculoEvento;
import br.com.fiorilli.sip.persistence.entity.TipoDemonstracaoFaltas;
import br.com.fiorilli.sip.persistence.entity.TipoLancamentoEvento;
import br.com.fiorilli.sip.persistence.entity.TipoMediaEvento;
import br.com.fiorilli.sipweb.vo.ws.FaltaEventoWsVo;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(rootQueryType=Evento.class)
@Entity
@Table(name="EVENTOS")
@Audited
public class Evento
implements Serializable,
Filterable,
GenericEntity {
    private static final long serialVersionUID = -396067823825838923L;
    public static final String QUERY_FIND_POR_ENTIDADE = "SELECT e FROM Evento e WHERE e.eventoPK.entidade = :entidadeId ORDER BY e.eventoPK.codigo";
    public static final String FIND_BY_ENTIDADE_NOME = "SELECT DISTINCT e FROM Evento e WHERE (e.eventoPK.entidade = :entidadeId OR :entidadeId = '000') AND e.nome LIKE :nome ORDER BY e.nome";
    public static final String FIND_BY_ENTIDADE_CODIGO = "SELECT DISTINCT e FROM Evento e WHERE (e.eventoPK.entidade = :entidadeId OR :entidadeId = '000') AND e.eventoPK.codigo = :codigo ORDER BY e.eventoPK.codigo";
    public static final String FIND_FOR_FILTER = "SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome";
    public static final String FIND_BY_CODIGO_CLASSIFICACOES = "SELECT e FROM Evento e WHERE e.eventoPK.entidade = :entidadeCodigo AND e.eventoPK.codigo = :codigo AND e.classificacao IN (:classificacoes)";
    public static final String GET_NEXT_ITEM = "SELECT coalesce(max(e.eventoPK.codigo), 0) FROM Evento e where e.eventoPK.entidade = :entidadeCodigo";
    public static final String GET_EVENTO_COMPLETO = "SELECT e FROM Evento e LEFT JOIN e.eventosGatilho eg LEFT JOIN e.eventosAritimeticas ca LEFT JOIN e.eventosAlteracoes ea LEFT JOIN e.adicTempoServico ad LEFT JOIN e.eventosExclusao ee LEFT JOIN ee.eventoExclusao LEFT JOIN ee.eventoMestre LEFT JOIN eg.eventoGatilho LEFT JOIN eg.eventoMestre LEFT JOIN ca.eventos LEFT JOIN ca.eventos1 LEFT JOIN FETCH e.banco LEFT JOIN FETCH e.criacao.tipolegalCriacao LEFT JOIN FETCH e.extincao.tipolegalExtincao LEFT JOIN FETCH e.tceMs ms LEFT JOIN FETCH e.tcePe pe LEFT JOIN FETCH e.tceMt mt LEFT JOIN FETCH e.tcePr pr LEFT JOIN FETCH e.classificacaoESocial LEFT JOIN FETCH e.processoAdminitrativoPREV LEFT JOIN FETCH e.processoAdminitrativoIRRF LEFT JOIN FETCH e.processoContribuicaoSindical LEFT JOIN FETCH e.eventoPerdeAvoBeneficio WHERE e.eventoPK = :eventoPK";
    public static final String FIND_PK_BY_ENTIDADE_PERMISSOES_CLASSIFICACOES = " SELECT e.eventoPK  FROM Evento e  LEFT JOIN e.permissoesEventos pe  WHERE e.eventoPK.entidade = :entidade  AND pe.permissoesPerfilEventoPK IN :permissoes  AND e.classificacao IN :classificacoes ";
    public static final String FIND_PK_BY_ENTIDADE_CLASSIFICACOES = " SELECT e.eventoPK  FROM Evento e  LEFT JOIN e.permissoesEventos pe  WHERE e.eventoPK.entidade = :entidade  AND e.classificacao IN :classificacoes ";
    public static final String FIND_BY_ENTIDADE_CLASSIFICACOES = " SELECT e  FROM Evento e  WHERE e.eventoPK.entidade = :entidade  AND e.classificacao IN :classificacoes ";
    public static final String FIND_BY_ENTIDADE_CLASSIFICACAO = "SELECT e FROM Evento e WHERE e.eventoPK.entidade = :entidade    AND e.classificacao = :classificacao   AND e.ativo = true ";
    public static final String FIND_FALTAS_BY_ENTIDADE_TO_WS = "SELECT new " + FaltaEventoWsVo.class.getCanonicalName() + "(" + "e.eventoPK.codigo," + "e.nome" + ")" + "FROM Evento e " + "WHERE e.eventoPK.entidade = :entidade " + "   AND e.classificacao IN :classificacoes" + "   AND e.ativo = true ";
    @EmbeddedId
    protected EventoPK eventoPK;
    @SearchNome
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=1)
    @Column(name="NATUREZA", insertable=false, updatable=false)
    private String natureza;
    @Column(name="NATUREZA")
    @Type(type="NaturezaEvento")
    private EventoNatureza naturezaEvento;
    @Type(type="BooleanTypeSip")
    @Column(name="ATIVO", insertable=false, updatable=false)
    private Boolean ativo;
    @Column(name="VANTAGEM")
    private String vantagem;
    @Embedded
    private EventoFormula formula;
    @Embedded
    private EventoTempoServico tempoServico;
    @Embedded
    private FiltroEvento filtro;
    @Embedded
    private EventoIncidencia incidencia;
    @Embedded
    private DocumentoCriacaoBasic criacao;
    @Embedded
    private DocumentoExtincaoBasic extincao;
    @Type(type="BooleanTypeSip")
    @Column(name="SIPREV")
    private Boolean siprev;
    @Size(max=2)
    @Column(name="SIPREVBENEFICIO")
    private String siprevBeneficio;
    @Column(name="CLASSIFICACAO", insertable=false, updatable=false)
    private String classificacao;
    @Column(name="CLASSIFICACAO")
    @Type(type="EventoClassificacao")
    private EventoClassificacao classificacaoEvento;
    @Size(max=6)
    @Column(name="CONTACONTABIL")
    private String contaContabil;
    @Column(name="CLASSIFICACAOCONTABIL")
    private Integer classificacaoContabil;
    @Type(type="BooleanTypeSip")
    @Column(name="DESCONTAR_DO_TOTAL_A_EMPENHAR")
    private Boolean descontarDoTotalAEmpenhar;
    @Column(name="INFORMERENDIMENTOS")
    private Short informeRendimentos;
    @Column(name="BASEVALOR")
    private Double basevalor;
    @Column(name="TIPOMEDIA")
    private Character tipoMedia;
    @Column(name="TIPOCORTE")
    private Character criterioResultado;
    @Type(type="BooleanTypeSip")
    @Column(name="PAGAR_SEM_VENCTO")
    private Boolean pagarSemVencto;
    @Type(type="BooleanTypeSip")
    @Column(name="EXCLUIR_SALDO_ZERAR")
    private Boolean excluirSaldoZerar;
    @Type(type="BooleanTypeSip")
    @Column(name="PROPORCIONAL_DATA")
    private Boolean proporcionalData;
    @Type(type="BooleanTypeSip")
    @Column(name="BASE_EXERCICIO")
    private Boolean baseExercicio;
    @Type(type="BooleanTypeSip")
    @Column(name="CONSIDERAR_ESTOURO")
    private Boolean considerarEstouro;
    @Type(type="BooleanTypeSip")
    @Column(name="PORTAL_TRANSPARENCIA")
    private Boolean portalTransparencia;
    @Type(type="BooleanTypeSip")
    @Column(name="PROP_CONFORME_FALTA_JUSTIF")
    private Boolean proporcionalFaltaJustificada;
    @Column(name="TIPOLANCAMENTO")
    private Short tipoLancamento;
    @Column(name="LIMITE_HORAS")
    private Double limiteHoras;
    @Column(name="RATEIO")
    private Short rateio;
    @Column(name="BASE_COMPOSICAO")
    private Integer baseComposicao;
    @Type(type="BooleanTypeSip")
    @Column(name="BANCO_HORAS_EVENTO")
    private Boolean bancoHorasEvento;
    @Column(name="QTDMESESMEDIA")
    private Short qtdmesesmedia;
    @Type(type="BooleanTypeSip")
    @Column(name="APENAS_FREQUENCIA")
    private Boolean apenasFrequencia;
    @Type(type="BooleanTypeSip")
    @Column(name="ABATE_TEMPO_SERVICO")
    private Boolean abateTempoServico;
    @Column(name="FORMA_ACUMULACAO")
    private Integer formaAcumulacao;
    @Column(name="SIOPE_UNIDADE")
    private Double siopeUnidade;
    @OneToMany(mappedBy="evento", fetch=FetchType.LAZY)
    private List<PermissoesPerfilEvento> permissoesEventos;
    @OneToMany(mappedBy="eventoMestre", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventosGatilho> eventosGatilho;
    @OneToMany(mappedBy="eventoMestre", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventosExclusao> eventosExclusao;
    @OneToMany(mappedBy="eventoPrincipal", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventosAritimetica> eventosAritimeticas;
    @OneToMany(mappedBy="evento", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventosAlteracoes> eventosAlteracoes;
    @OneToMany(mappedBy="eventos", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Adicltemposervico> adicTempoServico;
    @OneToMany(mappedBy="evento", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventoPerdeAvoBeneficio> eventoPerdeAvoBeneficio;
    @OneToMany(mappedBy="evento", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventoDespesaMedica> eventoDespesaMedica;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private EventoTceMg tceMg;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private SipmsEvento tceMs;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private SippeEvento tcePe;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private SiproEvento tceRo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private SipmtEvento tceMt;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private SiprnEvento tceRn;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private SipprEvento tcePr;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private EventoTCESP tceSP;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private EventoTcmgo tcmgo;
    @Column(name="QTDE_HORAAULA")
    private String divisorHoraAula;
    @Column(name="QTDE_ADICIONALNOTURNO")
    private Double quantidadeAdicionalNoturno;
    @Column(name="classificacao_esocial")
    private Integer classificacaoESocialId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="classificacao_esocial", insertable=false, updatable=false)
    private ESocialClassificacaoRubrica classificacaoESocial;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Column(name="PROCESSO_IRRF_NAO_INCIDE_ID", insertable=false, updatable=false)
    private Integer processoIrrfId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROCESSO_IRRF_NAO_INCIDE_ID", insertable=false, updatable=false)
    private ProcessoAdmJudicial processoAdminitrativoIRRF;
    @Column(name="PROCESSO_PREV_NAO_INCIDE_ID", insertable=false, updatable=false)
    private Integer processoPrevidenciaId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROCESSO_PREV_NAO_INCIDE_ID", insertable=false, updatable=false)
    private ProcessoAdmJudicial processoAdminitrativoPREV;
    @Column(name="PROCESSO_CS_NAO_INCIDE_ID", insertable=false, updatable=false)
    private Integer processoContribuicaoSindicalId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROCESSO_CS_NAO_INCIDE_ID", referencedColumnName="ID", insertable=false, updatable=false)
    private ProcessoAdmJudicial processoContribuicaoSindical;
    @JoinColumn(name="BANCO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Banco banco;
    @Column(name="BANCO")
    private String codigoBanco;
    @Column(name="TIPODEMONSTRACAO_FALTA")
    private Integer tipoDemonstracaoFalta;
    @Column(name="FORMULA", insertable=false, updatable=false)
    private String utilizarFormula;
    @OneToMany(mappedBy="evento", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BancoHorasLancamento> bancoHorasLancamentos;

    public static Evento createInitialized(String codigoEntidade) {
        Evento e = new Evento();
        e.setEventoPK(new EventoPK());
        e.getEventoPK().setEntidade(codigoEntidade);
        return e;
    }

    public Evento() {
    }

    public Evento(EventoPK eventoPK) {
        this.eventoPK = eventoPK;
    }

    public Evento(String entidade, String codigo) {
        this.eventoPK = new EventoPK(entidade, codigo);
    }

    public EventoPK getEventoPK() {
        if (this.eventoPK == null) {
            this.eventoPK = new EventoPK();
        }
        return this.eventoPK;
    }

    public void setEventoPK(EventoPK eventoPK) {
        this.eventoPK = eventoPK;
    }

    public Entidade getEntidade() {
        if (this.entidade == null) {
            this.entidade = new Entidade();
        }
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getNatureza() {
        return this.natureza;
    }

    public void setNatureza(String natureza) {
        this.natureza = natureza;
    }

    public final EventoNatureza getNaturezaEvento() {
        return this.naturezaEvento;
    }

    public final void setNaturezaEvento(EventoNatureza naturezaEnum) {
        this.naturezaEvento = naturezaEnum;
    }

    public TipoCalculoEvento getVantagem() {
        return TipoCalculoEvento.toEntity(this.vantagem);
    }

    public void setVantagem(TipoCalculoEvento vantagem) {
        this.vantagem = vantagem.getId();
    }

    public String getSiprevBeneficio() {
        return this.siprevBeneficio;
    }

    public void setSiprevBeneficio(String siprevBeneficio) {
        this.siprevBeneficio = siprevBeneficio;
    }

    public EventoClassificacao getClassificacao() {
        return EventoClassificacao.parse(this.classificacao);
    }

    public void setClassificacao(EventoClassificacao classificacao) {
        this.classificacao = classificacao.getId();
    }

    public String getContaContabil() {
        return this.contaContabil;
    }

    public void setContaContabil(String contaContabil) {
        this.contaContabil = contaContabil;
    }

    public ClassificacaoContabilEvento getClassificacaoContabil() {
        return ClassificacaoContabilEvento.of(this.classificacaoContabil);
    }

    public void setClassificacaoContabil(ClassificacaoContabilEvento classificacaoContabil) {
        this.classificacaoContabil = classificacaoContabil.getId();
    }

    public ClassificacaoInformeRendimentosEvento getInformeRendimentos() {
        return ClassificacaoInformeRendimentosEvento.toEntity(this.informeRendimentos);
    }

    public void setInformeRendimentos(ClassificacaoInformeRendimentosEvento informeRendimentos) {
        this.informeRendimentos = informeRendimentos.getId();
    }

    public Double getBasevalor() {
        return this.basevalor;
    }

    public void setBasevalor(Double basevalor) {
        this.basevalor = basevalor;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public TipoMediaEvento getTipoMedia() {
        return TipoMediaEvento.toEntity(this.tipoMedia);
    }

    public void setTipoMedia(TipoMediaEvento tipoMedia) {
        this.tipoMedia = tipoMedia.getId();
    }

    public CriterioResultado getCriterioResultado() {
        return CriterioResultado.toEntity(this.criterioResultado);
    }

    public void setCriterioResultado(CriterioResultado criterioResultado) {
        this.criterioResultado = criterioResultado.getId();
    }

    public Boolean getExcluirSaldoZerar() {
        return this.excluirSaldoZerar;
    }

    public void setExcluirSaldoZerar(Boolean excluirSaldoZerar) {
        this.excluirSaldoZerar = excluirSaldoZerar;
    }

    public Boolean getProporcionalData() {
        return this.proporcionalData;
    }

    public void setProporcionalData(Boolean proporcionalData) {
        this.proporcionalData = proporcionalData;
    }

    public TipoLancamentoEvento getTipoLancamento() {
        return TipoLancamentoEvento.toEntity(this.tipoLancamento);
    }

    public void setTipoLancamento(TipoLancamentoEvento tipoLancamento) {
        this.tipoLancamento = tipoLancamento.getId();
    }

    public Double getLimiteHoras() {
        return this.limiteHoras;
    }

    public void setLimiteHoras(Double limiteHoraExtra) {
        this.limiteHoras = limiteHoraExtra;
    }

    public EventoRateio getRateio() {
        return EventoRateio.toEntity(this.rateio);
    }

    public void setRateio(EventoRateio rateio) {
        this.rateio = rateio.getId();
    }

    public Integer getBaseComposicao() {
        return this.baseComposicao;
    }

    public void setBaseComposicao(Integer baseComposicao) {
        this.baseComposicao = baseComposicao;
    }

    public Short getQtdmesesmedia() {
        return this.qtdmesesmedia;
    }

    public void setQtdmesesmedia(Short qtdmesesmedia) {
        this.qtdmesesmedia = qtdmesesmedia;
    }

    public EventoTempoServico getTempoServico() {
        if (this.tempoServico == null) {
            this.tempoServico = new EventoTempoServico();
        }
        return this.tempoServico;
    }

    public void setTempoServico(EventoTempoServico tempoServico) {
        this.tempoServico = tempoServico;
    }

    public FiltroEvento getFiltro() {
        if (this.filtro == null) {
            this.filtro = new FiltroEvento();
        }
        return this.filtro;
    }

    public void setFiltro(FiltroEvento filtro) {
        this.filtro = filtro;
    }

    public EventoFormula getFormula() {
        if (this.formula == null) {
            this.formula = new EventoFormula();
        }
        return this.formula;
    }

    public void setFormula(EventoFormula formula) {
        this.formula = formula;
    }

    public EventoFormaAcumulada getFormaAcumulacao() {
        return EventoFormaAcumulada.get(this.formaAcumulacao);
    }

    public Boolean getSiprev() {
        return this.siprev;
    }

    public void setSiprev(Boolean siprev) {
        this.siprev = siprev;
    }

    public Boolean getDescontarDoTotalAEmpenhar() {
        return this.descontarDoTotalAEmpenhar;
    }

    public void setDescontarDoTotalAEmpenhar(Boolean descontarDoTotalAEmpenhar) {
        this.descontarDoTotalAEmpenhar = descontarDoTotalAEmpenhar;
    }

    public Boolean getPagarSemVencto() {
        return this.pagarSemVencto;
    }

    public void setPagarSemVencto(Boolean pagarSemVencto) {
        this.pagarSemVencto = pagarSemVencto;
    }

    public Boolean getBaseExercicio() {
        return this.baseExercicio;
    }

    public void setBaseExercicio(Boolean baseExercicio) {
        this.baseExercicio = baseExercicio;
    }

    public Boolean getBancoHorasEvento() {
        return this.bancoHorasEvento;
    }

    public void setBancoHorasEvento(Boolean bancoHorasEvento) {
        this.bancoHorasEvento = bancoHorasEvento;
    }

    public Boolean getAbateTempoServico() {
        return this.abateTempoServico;
    }

    public void setAbateTempoServico(Boolean abateTempoServico) {
        this.abateTempoServico = abateTempoServico;
    }

    public void setFormaAcumulacao(EventoFormaAcumulada formaAcumulacao) {
        this.formaAcumulacao = formaAcumulacao.getCodigo();
    }

    public List<BancoHorasLancamento> getBancoHorasLancamentos() {
        return this.bancoHorasLancamentos;
    }

    public void setBancoHorasLancamentos(List<BancoHorasLancamento> bancoHorasLancamentos) {
        this.bancoHorasLancamentos = bancoHorasLancamentos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.eventoPK != null ? this.eventoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Evento)) {
            return false;
        }
        Evento other = (Evento)object;
        return (this.eventoPK != null || other.eventoPK == null) && (this.eventoPK == null || this.eventoPK.equals(other.eventoPK));
    }

    public String toString() {
        return "entity.Eventos[ eventoPK=" + this.eventoPK + " ]";
    }

    public List<PermissoesPerfilEvento> getPermissoesEventos() {
        return this.permissoesEventos;
    }

    public void setPermissoesEventos(List<PermissoesPerfilEvento> permissoesEventos) {
        this.permissoesEventos = permissoesEventos;
    }

    public String getItemLabel() {
        return this.nome;
    }

    public String getItemId() {
        return this.eventoPK.getCodigo();
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public final EventoTceMg getTceMg() {
        if (this.tceMg == null) {
            this.tceMg = new EventoTceMg();
        }
        return this.tceMg;
    }

    public final void setTceMg(EventoTceMg tceMg) {
        this.tceMg = tceMg;
    }

    public String getDivisorHoraAula() {
        return this.divisorHoraAula;
    }

    public void setDivisorHoraAula(String divisorHoraAula) {
        this.divisorHoraAula = divisorHoraAula;
    }

    public Double getQuantidadeAdicionalNoturno() {
        return this.quantidadeAdicionalNoturno;
    }

    public Double getQuantidadeAdicionalNoturnoHorarioVerao() {
        return this.quantidadeAdicionalNoturno;
    }

    public void setQuantidadeAdicionalNoturno(Double quantidadeAdicionalNoturno) {
        this.quantidadeAdicionalNoturno = quantidadeAdicionalNoturno;
    }

    public Integer getClassificacaoESocialId() {
        return this.classificacaoESocialId;
    }

    public void setClassificacaoESocialId(Integer classificacaoESocialId) {
        this.classificacaoESocialId = classificacaoESocialId;
    }

    public ESocialClassificacaoRubrica getClassificacaoESocial() {
        return this.classificacaoESocial;
    }

    public void setClassificacaoESocial(ESocialClassificacaoRubrica classificacaoESocial) {
        if (classificacaoESocial != null) {
            this.classificacaoESocialId = classificacaoESocial.getCodigo();
        }
        this.classificacaoESocial = classificacaoESocial;
    }

    public EventoIncidencia getIncidencia() {
        if (this.incidencia == null) {
            this.incidencia = new EventoIncidencia();
        }
        return this.incidencia;
    }

    public void setIncidencia(EventoIncidencia incidencia) {
        this.incidencia = incidencia;
    }

    public DocumentoCriacaoBasic getCriacao() {
        if (this.criacao == null) {
            this.criacao = new DocumentoCriacaoBasic();
        }
        return this.criacao;
    }

    public void setCriacao(DocumentoCriacaoBasic criacao) {
        this.criacao = criacao;
    }

    public DocumentoExtincaoBasic getExtincao() {
        if (this.extincao == null) {
            this.extincao = new DocumentoExtincaoBasic();
        }
        return this.extincao;
    }

    public void setExtincao(DocumentoExtincaoBasic extincao) {
        this.extincao = extincao;
    }

    public List<EventosGatilho> getEventosGatilho() {
        return this.eventosGatilho;
    }

    public void setEventosGatilho(List<EventosGatilho> eventosGatilho) {
        this.eventosGatilho = eventosGatilho;
    }

    public List<EventosAritimetica> getEventosAritimeticas() {
        return this.eventosAritimeticas;
    }

    public void setEventosAritimeticas(List<EventosAritimetica> eventosAritimeticas) {
        this.eventosAritimeticas = eventosAritimeticas;
    }

    public List<EventosAlteracoes> getEventosAlteracoes() {
        return this.eventosAlteracoes;
    }

    public void setEventosAlteracoes(List<EventosAlteracoes> eventosAlteracoes) {
        this.eventosAlteracoes = eventosAlteracoes;
    }

    public List<Adicltemposervico> getAdicTempoServico() {
        return this.adicTempoServico;
    }

    public void setAdicTempoServico(List<Adicltemposervico> adicTempoServico) {
        this.adicTempoServico = adicTempoServico;
    }

    public List<EventosExclusao> getEventosExclusao() {
        return this.eventosExclusao;
    }

    public void setEventosExclusao(List<EventosExclusao> eventosExclusao) {
        this.eventosExclusao = eventosExclusao;
    }

    public List<EventoPerdeAvoBeneficio> getEventoPerdeAvoBeneficio() {
        return this.eventoPerdeAvoBeneficio;
    }

    public void setEventoPerdeAvoBeneficio(List<EventoPerdeAvoBeneficio> eventoPerdeAvoBeneficio) {
        this.eventoPerdeAvoBeneficio = eventoPerdeAvoBeneficio;
    }

    public ProcessoAdmJudicial getProcessoAdminitrativoIRRF() {
        return this.processoAdminitrativoIRRF;
    }

    public void setProcessoAdminitrativoIRRF(ProcessoAdmJudicial processoAdminitrativoIRRF) {
        this.processoAdminitrativoIRRF = processoAdminitrativoIRRF;
    }

    public ProcessoAdmJudicial getProcessoAdminitrativoPREV() {
        return this.processoAdminitrativoPREV;
    }

    public void setProcessoAdminitrativoPREV(ProcessoAdmJudicial processoAdminitrativoPREV) {
        this.processoAdminitrativoPREV = processoAdminitrativoPREV;
    }

    public SipmsEvento getTceMs() {
        if (this.tceMs == null) {
            this.tceMs = new SipmsEvento();
        }
        return this.tceMs;
    }

    public void setTceMs(SipmsEvento tceMs) {
        this.tceMs = tceMs;
    }

    public SippeEvento getTcePe() {
        if (this.tcePe == null) {
            this.tcePe = new SippeEvento();
        }
        return this.tcePe;
    }

    public void setTcePe(SippeEvento tcePe) {
        this.tcePe = tcePe;
    }

    public SiproEvento getTceRo() {
        if (this.tceRo == null) {
            this.tceRo = new SiproEvento();
        }
        return this.tceRo;
    }

    public void setTceRo(SiproEvento tceRo) {
        this.tceRo = tceRo;
    }

    public SipmtEvento getTceMt() {
        if (this.tceMt == null) {
            this.tceMt = new SipmtEvento();
        }
        return this.tceMt;
    }

    public void setTceMt(SipmtEvento tceMt) {
        this.tceMt = tceMt;
    }

    public SiprnEvento getTceRn() {
        if (this.tceRn == null) {
            this.tceRn = new SiprnEvento();
        }
        return this.tceRn;
    }

    public void setTceRn(SiprnEvento tceRn) {
        this.tceRn = tceRn;
    }

    public SipprEvento getTcePr() {
        if (this.tcePr == null) {
            this.tcePr = new SipprEvento();
        }
        return this.tcePr;
    }

    public void setTcePr(SipprEvento tcePr) {
        this.tcePr = tcePr;
    }

    public Banco getBanco() {
        return this.banco;
    }

    public void setBanco(Banco banco) {
        this.banco = banco;
        this.codigoBanco = banco != null ? banco.getCodigo() : null;
    }

    public String getCodigoBanco() {
        return this.codigoBanco;
    }

    public void setCodigoBanco(String codigoBanco) {
        this.codigoBanco = codigoBanco;
    }

    public Boolean getApenasFrequencia() {
        return this.apenasFrequencia;
    }

    public void setApenasFrequencia(Boolean apenasFrequencia) {
        this.apenasFrequencia = apenasFrequencia;
    }

    public Boolean getConsiderarEstouro() {
        return this.considerarEstouro;
    }

    public void setConsiderarEstouro(Boolean considerarEstouro) {
        this.considerarEstouro = considerarEstouro;
    }

    public Integer getProcessoIrrfId() {
        return this.processoIrrfId;
    }

    public void setProcessoIrrfId(Integer processoIrrfId) {
        this.processoIrrfId = processoIrrfId;
    }

    public Integer getProcessoPrevidenciaId() {
        return this.processoPrevidenciaId;
    }

    public void setProcessoPrevidenciaId(Integer processoPrevidenciaId) {
        this.processoPrevidenciaId = processoPrevidenciaId;
    }

    public Integer getProcessoContribuicaoSindicalId() {
        return this.processoContribuicaoSindicalId;
    }

    public void setProcessoContribuicaoSindicalId(Integer processoContribuicaoSindicalId) {
        this.processoContribuicaoSindicalId = processoContribuicaoSindicalId;
    }

    public ProcessoAdmJudicial getProcessoContribuicaoSindical() {
        return this.processoContribuicaoSindical;
    }

    public void setProcessoContribuicaoSindical(ProcessoAdmJudicial processoContribuicaoSindical) {
        this.processoContribuicaoSindical = processoContribuicaoSindical;
    }

    public TipoDemonstracaoFaltas getTipoDemonstracaoFalta() {
        return TipoDemonstracaoFaltas.toEntity(this.tipoDemonstracaoFalta);
    }

    public void setTipoDemonstracaoFalta(TipoDemonstracaoFaltas tipoDemonstracaoFalta) {
        this.tipoDemonstracaoFalta = tipoDemonstracaoFalta.getId();
    }

    public final EventoClassificacao getClassificacaoEvento() {
        return this.classificacaoEvento;
    }

    public final void setClassificacaoEvento(EventoClassificacao classificacaoEvento) {
        this.classificacaoEvento = classificacaoEvento;
    }

    public Boolean getPortalTransparencia() {
        return this.portalTransparencia;
    }

    public void setPortalTransparencia(Boolean portalTransparencia) {
        this.portalTransparencia = portalTransparencia;
    }

    public Boolean getProporcionalFaltaJustificada() {
        return this.proporcionalFaltaJustificada;
    }

    public void setProporcionalFaltaJustificada(Boolean proporcionalFaltaJustificada) {
        this.proporcionalFaltaJustificada = proporcionalFaltaJustificada;
    }

    public List<EventoDespesaMedica> getEventoDespesaMedica() {
        return this.eventoDespesaMedica;
    }

    public void setEventoDespesaMedica(List<EventoDespesaMedica> eventoDespesaMedica) {
        this.eventoDespesaMedica = eventoDespesaMedica;
    }

    public Double getSiopeUnidade() {
        return this.siopeUnidade;
    }

    public void setSiopeUnidade(Double siopeUnidade) {
        this.siopeUnidade = siopeUnidade;
    }

    public boolean isHoraExtra() {
        return this.getClassificacao().isHoraExtra();
    }

    public boolean isFalta() {
        return this.getClassificacao().isFalta();
    }

    public String getUtilizarFormula() {
        return this.utilizarFormula;
    }

    public void setUtilizarFormula(String utilizarFormula) {
        this.utilizarFormula = utilizarFormula;
    }
}

