/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.EstagioProbatorioPergunta;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=EstagioProbatorioProva.class)
@Entity
@Table(name="SIPESTPROB_PROVAS")
@Audited
public class EstagioProbatorioProva
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_ESTPROB_PROVAS";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @FilterConfig(label="Descri\u00e7\u00e3o", order=2)
    @Size(max=512)
    @Column(name="DESCRICAO")
    private String descricao;
    @FilterConfig(label="Data In\u00edcio", order=3, condition=FilterCondition.INTERVALO)
    @Column(name="DTINICIO")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicio;
    @FilterConfig(label="Data Fim", order=4, condition=FilterCondition.INTERVALO)
    @Column(name="DTFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFim;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="prova", fetch=FetchType.LAZY)
    private List<EstagioProbatorioPergunta> perguntas;

    public EstagioProbatorioProva() {
    }

    public EstagioProbatorioProva(Integer codigo) {
        this.codigo = codigo;
    }

    public EstagioProbatorioProva(Integer codigo, String entidade) {
        this.codigo = codigo;
        this.entidadeCodigo = entidade;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidade) {
        this.entidadeCodigo = entidade;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dtinicio) {
        this.dataInicio = dtinicio;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public List<EstagioProbatorioPergunta> getPerguntas() {
        return this.perguntas;
    }

    public void setPerguntas(List<EstagioProbatorioPergunta> sipestprobPerguntasList) {
        this.perguntas = sipestprobPerguntasList;
    }

    public String toString() {
        return "EstagioProbatorioProva [codigo=" + this.codigo + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EstagioProbatorioProva other = (EstagioProbatorioProva)obj;
        return this.codigo == other.codigo;
    }

    @Override
    public String getHashId() {
        return this.codigo.toString();
    }
}

