/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.EstagioProbatorioPergunta;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPESTPROB_ITEMSPERGUNTAS")
@Audited
public class EstagioProbatorioPerguntaItem
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_ESTPROB_ITEMSPERGUNTAS";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Size(max=3)
    @Column(name="ITEM")
    private String item;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=512)
    @Column(name="NOME")
    private String nome;
    @Column(name="NOTA")
    private Double nota;
    @Column(name="ITEM_PERGUNTAS")
    private Integer perguntaCodigo;
    @JoinColumn(name="ITEM_PERGUNTAS", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private EstagioProbatorioPergunta pergunta;

    public EstagioProbatorioPerguntaItem() {
    }

    public EstagioProbatorioPerguntaItem(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getItem() {
        return this.item;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Double getNota() {
        return this.nota;
    }

    public void setNota(Double nota) {
        this.nota = nota;
    }

    public EstagioProbatorioPergunta getPergunta() {
        return this.pergunta;
    }

    public void setPergunta(EstagioProbatorioPergunta itemPerguntas) {
        this.perguntaCodigo = itemPerguntas != null ? Integer.valueOf(itemPerguntas.getCodigo()) : null;
        this.pergunta = itemPerguntas;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EstagioProbatorioPerguntaItem)) {
            return false;
        }
        EstagioProbatorioPerguntaItem other = (EstagioProbatorioPerguntaItem)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.SipestprobItemsperguntas[ codigo=" + this.codigo + " ]";
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.codigo);
    }

    public Integer getPerguntaCodigo() {
        return this.perguntaCodigo;
    }

    public void setPerguntaCodigo(Integer perguntaCodigo) {
        this.perguntaCodigo = perguntaCodigo;
    }
}

