/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.EstagioProbatorioProva;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPESTPROB_PERGUNTAS")
@Audited
public class EstagioProbatorioPergunta
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_ESTPROB_PERGUNTAS";
    public static final String GET_FETCHED_BY_CODIGO = "SELECT e FROM EstagioProbatorioPergunta e LEFT JOIN FETCH e.prova WHERE e.codigo = :codigo";
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private int codigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="ITEM_PROVA")
    private Integer provaCodigo;
    @Size(max=3)
    @Column(name="ITEM")
    private String item;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=512)
    @Column(name="DESCRICAO")
    private String descricao;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="ITEM_PROVA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private EstagioProbatorioProva prova;

    public EstagioProbatorioPergunta() {
    }

    public EstagioProbatorioPergunta(int codigo) {
        this.codigo = codigo;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public void setCodigo(int codigo) {
        this.codigo = codigo;
    }

    public String getItem() {
        return this.item;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public EstagioProbatorioProva getProva() {
        return this.prova;
    }

    public void setProva(EstagioProbatorioProva prova) {
        this.provaCodigo = prova != null ? prova.getCodigo() : null;
        this.prova = prova;
    }

    public Integer getProvaCodigo() {
        return this.provaCodigo;
    }

    public void setProvaCodigo(Integer provaCodigo) {
        this.provaCodigo = provaCodigo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        result = 31 * result + this.provaCodigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EstagioProbatorioPergunta other = (EstagioProbatorioPergunta)obj;
        if (this.codigo != other.codigo) {
            return false;
        }
        return this.provaCodigo == other.provaCodigo;
    }

    public String toString() {
        return "EstagioProbatorioPergunta [codigo=" + this.codigo + ", provaCodigo=" + this.provaCodigo + "]";
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.codigo);
    }
}

