/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Atividade;
import br.com.fiorilli.sip.persistence.entity.EpiTipoProtecao;
import br.com.fiorilli.sip.persistence.entity.RegistroControleEpi;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="EPI")
@FilterConfigType(rootEntityAlias="e", autoFilter=true)
@Audited
public class Epi
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "SELECT e FROM Epi e";
    public static final String FIND_BY_ATIVIDADE = "SELECT e FROM Epi e LEFT JOIN e.atividadeList a WHERE a.atividadePK = :atividadePK";
    public static final String GENERATOR = "GEN_EPI";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Size(max=150)
    @Column(name="NOME")
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE, order=1)
    private String nome;
    @Size(max=60)
    @Column(name="FABRICANTE")
    @FilterConfig(label="Fabricante", condition=FilterCondition.COMECE, order=2)
    private String fabricante;
    @Size(max=20)
    @Column(name="NUMERO_CERTIFICADO_APROVACAO")
    private String numeroCertificadoAprovacao;
    @Enumerated
    @Column(name="TIPO_PROTECAO")
    @FilterConfig(label="Tipo de Prote\u00e7\u00e3o", inputType=FilterInputType.SELECT_ONE_MENU, order=3)
    @FilterConfigEnum(itemLabel="label")
    private EpiTipoProtecao tipoProtecao;
    @Column(name="DATA_VALIDADE")
    @Temporal(value=TemporalType.DATE)
    @FilterConfig(label="Data de Validade", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO, order=4)
    private Date dataValidade;
    @ManyToMany(mappedBy="epis", fetch=FetchType.LAZY)
    private List<Atividade> atividadeList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="epi", fetch=FetchType.LAZY)
    private List<RegistroControleEpi> controleEpiList;

    public Epi() {
    }

    public Epi(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getFabricante() {
        return this.fabricante;
    }

    public void setFabricante(String fabricante) {
        this.fabricante = fabricante;
    }

    public String getNumeroCertificadoAprovacao() {
        return this.numeroCertificadoAprovacao;
    }

    public void setNumeroCertificadoAprovacao(String numeroCertificadoAprovacao) {
        this.numeroCertificadoAprovacao = numeroCertificadoAprovacao;
    }

    public EpiTipoProtecao getTipoProtecao() {
        return this.tipoProtecao;
    }

    public void setTipoProtecao(EpiTipoProtecao tipoProtecao) {
        this.tipoProtecao = tipoProtecao;
    }

    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    public List<Atividade> getAtividadeList() {
        return this.atividadeList;
    }

    public void setAtividadeList(List<Atividade> atividadeList) {
        this.atividadeList = atividadeList;
    }

    public List<RegistroControleEpi> getControleEpiList() {
        return this.controleEpiList;
    }

    public void setControleEpiList(List<RegistroControleEpi> controleEpiList) {
        this.controleEpiList = controleEpiList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Epi)) {
            return false;
        }
        Epi other = (Epi)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Epi[ codigo=" + this.codigo + " ]";
    }
}

