/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPMG_EMPRESA")
@Audited
public class EntidadeTceMg
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @NotNull
    @Basic(optional=false)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @OneToOne(fetch=FetchType.LAZY)
    private Entidade entidade;
    @Basic(optional=false)
    @NotNull
    @Size(max=5)
    @Column(name="CODIGO_IDENTIFICADOR")
    private String codigoIdentificador;
    @Basic(optional=false)
    @NotNull
    @Size(max=3)
    @Column(name="CODIGO_ORGAO")
    private String codigoOrgao;
    @Size(max=14)
    @Column(name="CNPJ_ORGAO_TETO")
    private String cnpjOrgaoTeto;
    @Size(max=60)
    @Column(name="NOME_ORGAO_TETO")
    private String nomeOrgaoTeto;
    @Column(name="DATA_LEI_TETO")
    @Temporal(value=TemporalType.DATE)
    private Date dataLeiTeto;
    @Size(max=16)
    @Column(name="NUMDOC_LEI_TETO")
    private String numeroDocumentoLeiTeto;
    @JoinColumn(name="TIPOLEGAL_LEI_TETO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipolegalLeiTeto;
    @Column(name="TIPOLEGAL_LEI_TETO")
    private Integer tipoLegalCodigo;
    @Column(name="CODIGO_TETO_REM")
    private Integer codigoTetoRem;

    public String getCodigoIdentificador() {
        return this.codigoIdentificador;
    }

    public void setCodigoIdentificador(String codigo) {
        this.codigoIdentificador = codigo;
    }

    public String getCodigoOrgao() {
        return this.codigoOrgao;
    }

    public void setCodigoOrgao(String codigoOrgao) {
        this.codigoOrgao = codigoOrgao;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public Integer getCodigoTetoRem() {
        return this.codigoTetoRem;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
        this.entidadeCodigo = entidade != null ? entidade.getCodigo() : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entidadeCodigo == null ? 0 : this.entidadeCodigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntidadeTceMg other = (EntidadeTceMg)obj;
        return !(this.entidadeCodigo == null ? other.entidadeCodigo != null : !this.entidadeCodigo.equals(other.entidadeCodigo));
    }

    public String toString() {
        return "TribunalContasMgEntidade [entidadeCodigo=" + this.entidadeCodigo + "]";
    }
}

