/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.SipMailSecurityType;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Embeddable
public class EntidadeSipweb
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Size(max=60)
    @Column(name="SIPWEB_EMAIL_USUARIO")
    private String emailUsuario;
    @Size(max=60)
    @Column(name="SIPWEB_EMAIL")
    private String email;
    @Size(max=20)
    @Column(name="SIPWEB_EMAIL_SENHA")
    private String senhaEmail;
    @Size(max=50)
    @Column(name="SIPWEB_EMAIL_SMTP")
    private String smtp;
    @Column(name="SIPWEB_EMAIL_SMTP_PORTA")
    private Short portaSmtp;
    @Type(type="BooleanTypeSip")
    @Column(name="SIPWEB_USA_API_ENVIO")
    private Boolean usaApiEnvio;
    @Type(type="BooleanTypeSip")
    @Column(name="SIPWEB_EMAIL_AUTENTICAVEL")
    private Boolean emailAutenticavel;
    @Column(name="SIPWEB_EMAIL_SECURITYTYPE")
    private String emailSecurityType;
    @Size(max=100)
    @Column(name="SIPWEB_SMS_HOST")
    private String smsHost;
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="SIPWEB_SMS_PORT")
    private Long smsPort;
    @Size(max=32)
    @Column(name="SIPWEB_SMS_USUARIO")
    private String smsUsuario;
    @Size(max=32)
    @Column(name="SIPWEB_SMS_SENHA")
    private String smsSenha;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmailUsuario() {
        return this.emailUsuario;
    }

    public void setEmailUsuario(String emailUsuario) {
        this.emailUsuario = emailUsuario;
    }

    public String getSenhaEmail() {
        return this.senhaEmail;
    }

    public void setSenhaEmail(String senhaEmail) {
        this.senhaEmail = senhaEmail;
    }

    public String getSmtp() {
        return this.smtp;
    }

    public String getUrlApi() {
        if (this.smtp != null && !this.smtp.isEmpty() && this.portaSmtp != null) {
            return this.smtp.concat(":" + this.portaSmtp);
        }
        return this.smtp;
    }

    public void setSmtp(String smtp) {
        this.smtp = smtp;
    }

    public Short getPortaSmtp() {
        return this.portaSmtp;
    }

    public void setPortaSmtp(Short portaSmtp) {
        this.portaSmtp = portaSmtp;
    }

    public Boolean getUsaApiEnvio() {
        return this.usaApiEnvio;
    }

    public void setUsaApiEnvio(Boolean usaApiEnvio) {
        this.usaApiEnvio = usaApiEnvio;
    }

    public Boolean getEmailAutenticavel() {
        return this.emailAutenticavel;
    }

    public void setEmailAutenticavel(Boolean emailAutenticavel) {
        this.emailAutenticavel = emailAutenticavel;
    }

    public String getSmsHost() {
        return this.smsHost;
    }

    public void setSmsHost(String smsHost) {
        this.smsHost = smsHost;
    }

    public Long getSmsPort() {
        return this.smsPort;
    }

    public void setSmsPort(Long smsPort) {
        this.smsPort = smsPort;
    }

    public String getSmsUsuario() {
        return this.smsUsuario;
    }

    public void setSmsUsuario(String smsUsuario) {
        this.smsUsuario = smsUsuario;
    }

    public String getSmsSenha() {
        return this.smsSenha;
    }

    public void setSmsSenha(String smsSenha) {
        this.smsSenha = smsSenha;
    }

    public SipMailSecurityType getEmailSecurityType() {
        return SipMailSecurityType.get(this.emailSecurityType);
    }

    public void setEmailSecurityType(SipMailSecurityType emailSecurityType) {
        this.emailSecurityType = emailSecurityType.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntidadeSipweb that = (EntidadeSipweb)o;
        return Objects.equals(this.emailUsuario, that.emailUsuario) && Objects.equals(this.email, that.email) && Objects.equals(this.senhaEmail, that.senhaEmail) && Objects.equals(this.smtp, that.smtp) && Objects.equals(this.portaSmtp, that.portaSmtp) && Objects.equals(this.emailAutenticavel, that.emailAutenticavel) && Objects.equals(this.emailSecurityType, that.emailSecurityType) && Objects.equals(this.smsHost, that.smsHost) && Objects.equals(this.smsPort, that.smsPort) && Objects.equals(this.smsUsuario, that.smsUsuario) && Objects.equals(this.smsSenha, that.smsSenha);
    }

    public int hashCode() {
        return Objects.hash(this.emailUsuario, this.email, this.senhaEmail, this.smtp, this.portaSmtp, this.emailAutenticavel, this.emailSecurityType, this.smsHost, this.smsPort, this.smsUsuario, this.smsSenha);
    }

    public String toString() {
        return "EntidadeSipweb{emailUsuario='" + this.emailUsuario + '\'' + ", email='" + this.email + '\'' + ", senhaEmail='" + this.senhaEmail + '\'' + ", smtp='" + this.smtp + '\'' + ", portaSmtp=" + this.portaSmtp + ", emailAutenticavel=" + this.emailAutenticavel + ", emailSecurityType='" + this.emailSecurityType + '\'' + ", smsHost='" + this.smsHost + '\'' + ", smsPort=" + this.smsPort + ", smsUsuario='" + this.smsUsuario + '\'' + ", smsSenha='" + this.smsSenha + '\'' + '}';
    }
}

