/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.EntidadeNaturezaJuridica;
import br.com.fiorilli.sip.persistence.entity.EntidadeTipoControlePonto;
import br.com.fiorilli.sip.persistence.entity.EsocialOutbox;
import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import br.com.fiorilli.sip.persistence.entity.ProcessoAdmJudicial;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Embeddable
public class EntidadeESocial {
    private static final long serialVersionUID = 1L;
    @Type(type="BooleanTypeSip")
    @Column(name="enviar_esocial")
    private Boolean enviar;
    @Column(name="aliquota_fap")
    private Double aliquotaFap;
    @JoinColumn(name="processo_fap", referencedColumnName="id", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ProcessoAdmJudicial processoFap;
    @Column(name="PROCESSO_FAP")
    private Integer processoFapId;
    @JoinColumn(name="ESOCIAL_OUTBOX_ID", referencedColumnName="id")
    @ManyToOne
    private EsocialOutbox outbox;
    @Column(name="NATJUR")
    private String naturezaJuridica;
    @Column(name="MESDICIDIO")
    private String mesDicidio;
    @Enumerated
    @Column(name="TIPO_CONTROLE_PONTO")
    private EntidadeTipoControlePonto tipoControlePonto;
    @Size(max=6)
    @Column(name="SIAFSIPREV")
    private String codigoSIAFI;
    @Type(type="BooleanTypeSip")
    @Column(name="CONTRIBUI_RPPS")
    private Boolean contribuiRpps;
    @Size(max=8)
    @Column(name="CODCIDADE")
    private String codigoMunicipioIBGE;

    public Boolean getEnviar() {
        return this.enviar;
    }

    public void setEnviar(Boolean enviarESocial) {
        this.enviar = enviarESocial;
    }

    public Double getAliquotaFap() {
        return this.aliquotaFap;
    }

    public void setAliquotaFap(Double aliquotaFap) {
        this.aliquotaFap = aliquotaFap;
    }

    public ProcessoAdmJudicial getProcessoFap() {
        return this.processoFap;
    }

    public void setProcessoFap(ProcessoAdmJudicial processoFap) {
        this.processoFapId = processoFap != null ? processoFap.getId() : null;
        this.processoFap = processoFap;
    }

    public EsocialOutbox getOutbox() {
        return this.outbox;
    }

    public void setOutbox(EsocialOutbox outbox) {
        this.outbox = outbox;
    }

    public EntidadeNaturezaJuridica getNaturezaJuridica() {
        return EntidadeNaturezaJuridica.get(this.naturezaJuridica);
    }

    public void setNaturezaJuridica(EntidadeNaturezaJuridica naturezaJuridica) {
        this.naturezaJuridica = naturezaJuridica != null ? naturezaJuridica.getCodigo() : null;
    }

    public MesNomeEnum getMesDicidio() {
        if (this.mesDicidio == null) {
            return null;
        }
        if (this.mesDicidio.equals("0")) {
            return null;
        }
        return MesNomeEnum.of(this.mesDicidio);
    }

    public void setMesDicidio(MesNomeEnum mesdicidio) {
        this.mesDicidio = mesdicidio.getCodigo();
    }

    public EntidadeTipoControlePonto getTipoControlePonto() {
        return this.tipoControlePonto;
    }

    public void setTipoControlePonto(EntidadeTipoControlePonto tipoControlePonto) {
        this.tipoControlePonto = tipoControlePonto;
    }

    public String getCodigoSIAFI() {
        return this.codigoSIAFI;
    }

    public void setCodigoSIAFI(String codigoSiaf) {
        this.codigoSIAFI = codigoSiaf;
    }

    public Boolean getContribuiRpps() {
        return this.contribuiRpps;
    }

    public void setContribuiRpps(Boolean contribuiRpps) {
        this.contribuiRpps = contribuiRpps;
    }

    public String getCodigoMunicipioIBGE() {
        return this.codigoMunicipioIBGE;
    }

    public void setCodigoMunicipioIBGE(String codcidade) {
        this.codigoMunicipioIBGE = codcidade;
    }

    public Integer getProcessoFapId() {
        return this.processoFapId;
    }

    public void setProcessoFapId(Integer processoFapId) {
        this.processoFapId = processoFapId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntidadeESocial that = (EntidadeESocial)o;
        return Objects.equals(this.enviar, that.enviar) && Objects.equals(this.aliquotaFap, that.aliquotaFap) && Objects.equals(this.processoFap, that.processoFap) && Objects.equals(this.processoFapId, that.processoFapId) && Objects.equals(this.outbox, that.outbox) && Objects.equals(this.naturezaJuridica, that.naturezaJuridica) && Objects.equals(this.mesDicidio, that.mesDicidio) && this.tipoControlePonto == that.tipoControlePonto && Objects.equals(this.codigoSIAFI, that.codigoSIAFI) && Objects.equals(this.contribuiRpps, that.contribuiRpps) && Objects.equals(this.codigoMunicipioIBGE, that.codigoMunicipioIBGE);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enviar, this.aliquotaFap, this.processoFap, this.processoFapId, this.outbox, this.naturezaJuridica, this.mesDicidio, this.tipoControlePonto, this.codigoSIAFI, this.contribuiRpps, this.codigoMunicipioIBGE});
    }

    public String toString() {
        return "EntidadeESocial{enviar=" + this.enviar + ", aliquotaFap=" + this.aliquotaFap + ", processoFap=" + this.processoFap + ", processoFapId=" + this.processoFapId + ", outbox=" + this.outbox + ", naturezaJuridica='" + this.naturezaJuridica + '\'' + ", mesDicidio='" + this.mesDicidio + '\'' + ", tipoControlePonto=" + (Object)((Object)this.tipoControlePonto) + ", codigoSIAFI='" + this.codigoSIAFI + '\'' + ", contribuiRpps=" + this.contribuiRpps + ", codigoMunicipioIBGE='" + this.codigoMunicipioIBGE + '\'' + '}';
    }
}

