/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.EntidadeAudesp;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import br.com.fiorilli.sip.persistence.entity.TelefoneFixo;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="ENTIDADE_CEDENTE")
@Audited
public class EntidadeCedente
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_ENTIDADE_CEDENTE";
    @Id
    @NotNull
    @Column(name="ID")
    private Integer id;
    @FilterConfig(label="Identificador", order=1)
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @Column(name="TIPOID")
    @Enumerated(value=EnumType.STRING)
    private IdentificadorTipo identificadorTipo;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE, order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Embedded
    private TelefoneFixo telefone;
    @Embedded
    private Endereco endereco;
    @Embedded
    private EntidadeAudesp audesp;
    @Column(name="CODIGO_IBGE")
    private String codigoIbge;
    @Basic
    @Column(name="CODIGO_TCEPR")
    private String codigoTcePr;
    @Basic
    @Column(name="CODIGO_ORGAO", length=2)
    private String codigoOrgao;

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        if (this.telefone == null) {
            this.telefone = new TelefoneFixo();
        }
    }

    public EntidadeCedente() {
    }

    public EntidadeCedente(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public IdentificadorTipo getIdentificadorTipo() {
        return this.identificadorTipo;
    }

    public void setIdentificadorTipo(IdentificadorTipo identificadorTipo) {
        this.identificadorTipo = identificadorTipo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public TelefoneFixo getTelefone() {
        if (this.telefone == null) {
            this.telefone = new TelefoneFixo();
        }
        return this.telefone;
    }

    public void setTelefone(TelefoneFixo telefone) {
        this.telefone = telefone;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public EntidadeAudesp getAudesp() {
        if (this.audesp == null) {
            this.audesp = new EntidadeAudesp();
        }
        return this.audesp;
    }

    public void setAudesp(EntidadeAudesp audesp) {
        this.audesp = audesp;
    }

    public String getCodigoIbge() {
        return this.codigoIbge;
    }

    public void setCodigoIbge(String codigoIbge) {
        this.codigoIbge = codigoIbge;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntidadeCedente other = (EntidadeCedente)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "entity.EntidadeCedente[ id=" + this.id + " ]";
    }
}

