/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AmbienteTrabalho;
import br.com.fiorilli.sip.persistence.entity.AtividadeCargo;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Entidade13Salario;
import br.com.fiorilli.sip.persistence.entity.EntidadeAssinaturas;
import br.com.fiorilli.sip.persistence.entity.EntidadeAudesp;
import br.com.fiorilli.sip.persistence.entity.EntidadeCertificado;
import br.com.fiorilli.sip.persistence.entity.EntidadeComplemento13Salario;
import br.com.fiorilli.sip.persistence.entity.EntidadeESocial;
import br.com.fiorilli.sip.persistence.entity.EntidadeFerias;
import br.com.fiorilli.sip.persistence.entity.EntidadeFgts;
import br.com.fiorilli.sip.persistence.entity.EntidadeFolhaComplementar;
import br.com.fiorilli.sip.persistence.entity.EntidadeFrequencia;
import br.com.fiorilli.sip.persistence.entity.EntidadeHorista;
import br.com.fiorilli.sip.persistence.entity.EntidadeLicencaPremio;
import br.com.fiorilli.sip.persistence.entity.EntidadeMensagem;
import br.com.fiorilli.sip.persistence.entity.EntidadeOpcaoGeral;
import br.com.fiorilli.sip.persistence.entity.EntidadeOpcoesCalculo;
import br.com.fiorilli.sip.persistence.entity.EntidadePrevidencia;
import br.com.fiorilli.sip.persistence.entity.EntidadeRPPS;
import br.com.fiorilli.sip.persistence.entity.EntidadeRais;
import br.com.fiorilli.sip.persistence.entity.EntidadeSIPREV;
import br.com.fiorilli.sip.persistence.entity.EntidadeScpi;
import br.com.fiorilli.sip.persistence.entity.EntidadeSipweb;
import br.com.fiorilli.sip.persistence.entity.EntidadeTceMg;
import br.com.fiorilli.sip.persistence.entity.EntidadeTceMs;
import br.com.fiorilli.sip.persistence.entity.EntidadeTcePr;
import br.com.fiorilli.sip.persistence.entity.EntidadeTcmGo;
import br.com.fiorilli.sip.persistence.entity.EntidadeTipo;
import br.com.fiorilli.sip.persistence.entity.GrupoPonto;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import br.com.fiorilli.sip.persistence.entity.PericiaNova;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Responsavel;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.UF;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import br.com.fiorilli.sip.persistence.listeners.EmbeddedLoader;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="EMPRESA")
@FilterConfigType(autoFilter=true)
@Audited
public class Entidade
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="CODIGO")
    private String codigo;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Column(name="TIPOID")
    @Enumerated(value=EnumType.STRING)
    private IdentificadorTipo identificadorTipo;
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @Embedded
    private Endereco endereco;
    @Embedded
    private EntidadeRais rais;
    @Embedded
    private EntidadePrevidencia previdencia;
    @Embedded
    private EntidadeFgts fgts;
    @Embedded
    private EntidadeFerias ferias;
    @Embedded
    private EntidadeMensagem mensagens;
    @Embedded
    private EntidadeSIPREV siprev;
    @Embedded
    private EntidadeOpcoesCalculo calculo;
    @Embedded
    private EntidadeFrequencia frequencia;
    @Embedded
    private EntidadeAssinaturas assinaturas;
    @Embedded
    private EntidadeHorista horistas;
    @Embedded
    private EntidadeFolhaComplementar folhaComplementar;
    @Embedded
    private EntidadeLicencaPremio licencaPremio;
    @Embedded
    private Entidade13Salario salario13;
    @Embedded
    private EntidadeComplemento13Salario complemento13Salario;
    @Embedded
    private EntidadeOpcaoGeral opcoesGerais;
    @Embedded
    private EntidadeSipweb sipweb;
    @Embedded
    private EntidadeRPPS rpps;
    @Embedded
    private EntidadeAudesp audesp;
    @Embedded
    private EntidadeESocial esocial;
    @Embedded
    private EntidadeScpi scpi;
    @Column(name="TELEFONE", length=11)
    private String telefone;
    @Column(name="FAX", length=11)
    private String fax;
    @Size(max=60)
    @Column(name="EMAIL")
    private String email;
    @Lob
    @Column(name="FOTO")
    private byte[] brasao;
    @Column(name="DTENCERRA")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataEncerramentoAtividades;
    @Size(max=30)
    @Column(name="NOME_ABREVIADO")
    private String nomeAbreviado;
    @Size(max=6)
    @Column(name="REFERENCIA_LOGSEFIP")
    private String referenciaLogsefip;
    @Size(max=80)
    @Column(name="SITE")
    private String site;
    @Type(type="BooleanTypeSip")
    @Column(name="IMPORTAR_CONTAS")
    private Boolean importarContas;
    @Type(type="BooleanTypeSip")
    @Column(name="IMPORTAR_FIXOS")
    private Boolean importarFixos;
    @Type(type="BooleanTypeSip")
    @Column(name="IMPORTAR_EVENTUAIS")
    private Boolean importarEventuais;
    @Type(type="BooleanTypeSip")
    @Column(name="IMPORTAR_DEPTES")
    private Boolean importarDeptes;
    @Type(type="BooleanTypeSip")
    @Column(name="IMPORTAR_BENEFPENSAO")
    private Boolean importarBenefpensao;
    @Type(type="BooleanTypeSip")
    @Column(name="IMPORTAR_CARGO")
    private Boolean importarCargo;
    @Type(type="BooleanTypeSip")
    @Column(name="IMPORTAR_UNIDADE")
    private Boolean importarUnidade;
    @Type(type="BooleanTypeSip")
    @Column(name="VERIFICAR_CHAVE_INICIO")
    private Boolean verificarChaveInicio;
    @Column(name="MUDAREFSAL_DTDOC")
    @Temporal(value=TemporalType.DATE)
    private Date mudarefsalDtdoc;
    @Size(max=16)
    @Column(name="MUDAREFSAL_NUMDOC")
    private String mudarefsalNumdoc;
    @Size(max=1)
    @Column(name="UFRJ_TABELA_SECRETARIA")
    private String ufrjTabelaSecretaria;
    @Type(type="BooleanTypeSip")
    @Column(name="SOMAR_UM_TERCOS")
    private Boolean somarUmTercos;
    @Size(max=6)
    @Column(name="CODIGO_PARA_RPPS")
    private String codigoParaRpps;
    @Column(name="TIPO")
    @Enumerated
    private EntidadeTipo tipo;
    @Type(type="BooleanTypeSip")
    @Column(name="FERIAS_INDENIZADAS_SEPARADAS")
    private Boolean feriasIndenizadasSeparadas;
    @Size(max=16)
    @Column(name="LEITEMPORARIOS")
    private String leitemporarios;
    @Column(name="DESEMPENHO_TRABALHADOR")
    private Double desempenhoTrabalhador;
    @Column(name="ID_CADUNICO")
    private Double idCadunico;
    @Column(name="NUMEROLEI_PORTARIA154_ANEXOI")
    private Integer numeroleiPortaria154Anexoi;
    @Column(name="DATALEI_PORTARIA154_ANEXOI")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataleiPortaria154Anexoi;
    @Column(name="ID_PORTARIA154_ANEXOI")
    private Integer idPortaria154Anexoi;
    @Size(max=4)
    @Column(name="ANO_DIRF_RECALCULADO")
    private String anoDirfRecalculado;
    @Size(max=4)
    @Column(name="ANO_RAIS_RECALCULADO")
    private String anoRaisRecalculado;
    @Column(name="TIPOSALARIO_SEGURODESEMPREGO")
    private Integer tiposalarioSegurodesemprego;
    @Column(name="RPPS_CORRECAO_MONETARIA")
    private Double rppsCorrecaoMonetaria;
    @Column(name="RPPS_JUROS_MORA")
    private Double rppsJurosMora;
    @Column(name="RPPS_MULTA")
    private Double rppsMulta;
    @Type(type="BooleanTypeSip")
    @Column(name="UTILIZA_CONTROLE_PORTARIA")
    private Boolean utilizaControlePortaria;
    @Column(name="ENVIADO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date enviado;
    @Type(type="BooleanTypeSip")
    @Column(name="CALCULAR_PROVISAO")
    private Boolean calcularProvisao;
    @Type(type="BooleanTypeSip")
    @Column(name="SINCRONIZAR_RPPS")
    private Boolean sincronizarRpps;
    @JoinColumn(name="MUDAREFSAL_TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.EAGER)
    private TipoDocumentoLegal mudarefsalTipolegal;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="entidade")
    private List<Trabalhador> trabalhadorList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="entidade")
    private List<Responsavel> responsavel;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="entidade", cascade={CascadeType.ALL}, orphanRemoval=true)
    private EntidadeTceMg tceMg;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="entidade", cascade={CascadeType.ALL}, orphanRemoval=true)
    private EntidadeTceMs tceMs;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="entidade", cascade={CascadeType.ALL}, orphanRemoval=true)
    private EntidadeTcmGo tcmGo;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="entidade", cascade={CascadeType.ALL}, orphanRemoval=true)
    private EntidadeTcePr tcePr;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="entidade")
    private List<Referencia> referenciaList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="entidade")
    private List<GrupoPonto> grupoPontoList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="entidade")
    private List<PericiaNova> pericias;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="entidade")
    private List<AmbienteTrabalho> ambientesTrabalho;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="entidade")
    private List<AtividadeCargo> atividadesCargo;
    @OneToOne(mappedBy="entidade", cascade={CascadeType.ALL})
    @PrimaryKeyJoinColumn
    private EntidadeCertificado certificado;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="entidade")
    private List<Usuario> usuarios;
    public static final String FIND_BY_CODIGO_NO_SCPI = "SELECT e FROM Entidade e WHERE e.scpi.codigoNoScpi = :codigoNoScpi";
    public static final String FIND_ENTIDADE_SIPWEB = "SELECT e FROM Entidade e LEFT JOIN FETCH e.sipweb WHERE e.codigo = :id";
    public static final String FIND_BY_ID = "SELECT e FROM Entidade e JOIN FETCH e.calculo WHERE e.codigo = :id";
    public static final String FIND_13_SALARIO_MAX_SOLICITACAO = "SELECT NEW java.lang.Double(e.salario13.porcentagemAdiantamento) FROM Entidade e WHERE e.codigo = :entidadeId";
    public static final String EXISTS_BY_CODIGO_AND_IDENTIFICADOR = "SELECT CASE WHEN COALESCE(COUNT(e.codigo), 0) > 0 THEN true ELSE false END FROM Entidade e WHERE e.codigo = :entidadeCodigo AND (e.identificador = :identificador OR (e.identificadorTipo = '2' AND e.identificador = :cei))";
    public static final String FIND_ALL = "SELECT e FROM Entidade e ORDER BY e.codigo";

    public static Entidade newInstance(UF uf) {
        Entidade e = new Entidade();
        e.endereco = new Endereco();
        e.rais = new EntidadeRais();
        e.previdencia = new EntidadePrevidencia();
        e.fgts = new EntidadeFgts();
        e.ferias = new EntidadeFerias();
        e.mensagens = new EntidadeMensagem();
        e.siprev = new EntidadeSIPREV();
        e.calculo = new EntidadeOpcoesCalculo();
        e.frequencia = new EntidadeFrequencia();
        e.assinaturas = new EntidadeAssinaturas();
        e.horistas = new EntidadeHorista();
        e.folhaComplementar = new EntidadeFolhaComplementar();
        e.licencaPremio = new EntidadeLicencaPremio();
        e.salario13 = new Entidade13Salario();
        e.complemento13Salario = new EntidadeComplemento13Salario();
        e.opcoesGerais = new EntidadeOpcaoGeral();
        e.sipweb = new EntidadeSipweb();
        e.rpps = new EntidadeRPPS();
        e.esocial = new EntidadeESocial();
        e.audesp = new EntidadeAudesp();
        e.initTribunais(uf);
        return e;
    }

    public void initTribunais(UF uf) {
        if (uf.isMG() && this.tceMg == null) {
            this.tceMg = new EntidadeTceMg();
        } else if (uf.isMS() && this.tceMs == null) {
            this.tceMs = new EntidadeTceMs();
        }
    }

    @PostLoad
    public void postLoad() throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        new EmbeddedLoader().load(this);
    }

    public Entidade() {
    }

    public Entidade(String codigo) {
        this.codigo = codigo;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Boolean getImportarContas() {
        return this.importarContas;
    }

    public void setImportarContas(Boolean importarContas) {
        this.importarContas = importarContas;
    }

    public Boolean getImportarFixos() {
        return this.importarFixos;
    }

    public void setImportarFixos(Boolean importarFixos) {
        this.importarFixos = importarFixos;
    }

    public Boolean getImportarEventuais() {
        return this.importarEventuais;
    }

    public void setImportarEventuais(Boolean importarEventuais) {
        this.importarEventuais = importarEventuais;
    }

    public Boolean getImportarDeptes() {
        return this.importarDeptes;
    }

    public void setImportarDeptes(Boolean importarDeptes) {
        this.importarDeptes = importarDeptes;
    }

    public Boolean getImportarBenefpensao() {
        return this.importarBenefpensao;
    }

    public void setImportarBenefpensao(Boolean importarBenefpensao) {
        this.importarBenefpensao = importarBenefpensao;
    }

    public Boolean getImportarCargo() {
        return this.importarCargo;
    }

    public void setImportarCargo(Boolean importarCargo) {
        this.importarCargo = importarCargo;
    }

    public Boolean getImportarUnidade() {
        return this.importarUnidade;
    }

    public void setImportarUnidade(Boolean importarUnidade) {
        this.importarUnidade = importarUnidade;
    }

    public Boolean getVerificarChaveInicio() {
        return this.verificarChaveInicio;
    }

    public void setVerificarChaveInicio(Boolean verificarChaveInicio) {
        this.verificarChaveInicio = verificarChaveInicio;
    }

    public Boolean getSomarUmTercos() {
        return this.somarUmTercos;
    }

    public void setSomarUmTercos(Boolean somarUmTercos) {
        this.somarUmTercos = somarUmTercos;
    }

    public IdentificadorTipo getIdentificadorTipo() {
        return this.identificadorTipo;
    }

    public void setIdentificadorTipo(IdentificadorTipo tipoid) {
        this.identificadorTipo = tipoid;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public EntidadeRais getRais() {
        return this.rais;
    }

    public void setRais(EntidadeRais rais) {
        this.rais = rais;
    }

    public EntidadePrevidencia getPrevidencia() {
        return this.previdencia;
    }

    public void setPrevidencia(EntidadePrevidencia previdencia) {
        this.previdencia = previdencia;
    }

    public EntidadeFgts getFgts() {
        return this.fgts;
    }

    public void setFgts(EntidadeFgts fgts) {
        this.fgts = fgts;
    }

    public EntidadeFerias getFerias() {
        return this.ferias;
    }

    public void setFerias(EntidadeFerias ferias) {
        this.ferias = ferias;
    }

    public EntidadeMensagem getMensagens() {
        return this.mensagens;
    }

    public void setMensagens(EntidadeMensagem mensagens) {
        this.mensagens = mensagens;
    }

    public EntidadeSIPREV getSiprev() {
        return this.siprev;
    }

    public void setSiprev(EntidadeSIPREV siprev) {
        this.siprev = siprev;
    }

    public EntidadeOpcoesCalculo getCalculo() {
        if (this.calculo == null) {
            this.calculo = new EntidadeOpcoesCalculo();
        }
        return this.calculo;
    }

    public void setCalculo(EntidadeOpcoesCalculo calculo) {
        this.calculo = calculo;
    }

    public final EntidadeFrequencia getFrequencia() {
        return this.frequencia;
    }

    public final void setFrequencia(EntidadeFrequencia frequencia) {
        this.frequencia = frequencia;
    }

    public EntidadeAssinaturas getAssinaturas() {
        if (this.assinaturas == null) {
            this.assinaturas = new EntidadeAssinaturas();
        }
        return this.assinaturas;
    }

    public void setAssinaturas(EntidadeAssinaturas assinaturas) {
        this.assinaturas = assinaturas;
    }

    public EntidadeHorista getHoristas() {
        return this.horistas;
    }

    public void setHoristas(EntidadeHorista horistas) {
        this.horistas = horistas;
    }

    public EntidadeFolhaComplementar getFolhaComplementar() {
        return this.folhaComplementar;
    }

    public void setFolhaComplementar(EntidadeFolhaComplementar folhaComplementar) {
        this.folhaComplementar = folhaComplementar;
    }

    public Entidade13Salario getSalario13() {
        return this.salario13;
    }

    public void setSalario13(Entidade13Salario salario13) {
        this.salario13 = salario13;
    }

    public EntidadeComplemento13Salario getComplemento13Salario() {
        return this.complemento13Salario;
    }

    public void setComplemento13Salario(EntidadeComplemento13Salario complemento13Salario) {
        this.complemento13Salario = complemento13Salario;
    }

    public EntidadeLicencaPremio getLicencaPremio() {
        return this.licencaPremio;
    }

    public void setLicencaPremio(EntidadeLicencaPremio licencaPremio) {
        this.licencaPremio = licencaPremio;
    }

    public EntidadeSipweb getSipweb() {
        return this.sipweb;
    }

    public void setSipweb(EntidadeSipweb sipweb) {
        this.sipweb = sipweb;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public byte[] getBrasao() {
        return this.brasao;
    }

    public void setBrasao(byte[] brasao) {
        this.brasao = brasao;
    }

    public Date getDataEncerramentoAtividades() {
        return this.dataEncerramentoAtividades;
    }

    public void setDataEncerramentoAtividades(Date dataEncerramentoAtividades) {
        this.dataEncerramentoAtividades = dataEncerramentoAtividades;
    }

    public String getNomeAbreviado() {
        return this.nomeAbreviado;
    }

    public void setNomeAbreviado(String nomeAbreviado) {
        this.nomeAbreviado = nomeAbreviado;
    }

    public String getReferenciaLogsefip() {
        return this.referenciaLogsefip;
    }

    public void setReferenciaLogsefip(String referenciaLogsefip) {
        this.referenciaLogsefip = referenciaLogsefip;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public Date getMudarefsalDtdoc() {
        return this.mudarefsalDtdoc;
    }

    public void setMudarefsalDtdoc(Date mudarefsalDtdoc) {
        this.mudarefsalDtdoc = mudarefsalDtdoc;
    }

    public String getMudarefsalNumdoc() {
        return this.mudarefsalNumdoc;
    }

    public void setMudarefsalNumdoc(String mudarefsalNumdoc) {
        this.mudarefsalNumdoc = mudarefsalNumdoc;
    }

    public String getUfrjTabelaSecretaria() {
        return this.ufrjTabelaSecretaria;
    }

    public void setUfrjTabelaSecretaria(String ufrjTabelaSecretaria) {
        this.ufrjTabelaSecretaria = ufrjTabelaSecretaria;
    }

    public String getCodigoParaRpps() {
        return this.codigoParaRpps;
    }

    public void setCodigoParaRpps(String codigoParaRpps) {
        this.codigoParaRpps = codigoParaRpps;
    }

    public EntidadeTipo getTipo() {
        return this.tipo;
    }

    public void setTipo(EntidadeTipo tipo) {
        this.tipo = tipo;
    }

    public Boolean getFeriasIndenizadasSeparadas() {
        return this.feriasIndenizadasSeparadas;
    }

    public void setFeriasIndenizadasSeparadas(Boolean feriasIndenizadasSeparadas) {
        this.feriasIndenizadasSeparadas = feriasIndenizadasSeparadas;
    }

    public String getLeitemporarios() {
        return this.leitemporarios;
    }

    public void setLeitemporarios(String leitemporarios) {
        this.leitemporarios = leitemporarios;
    }

    public Double getDesempenhoTrabalhador() {
        return this.desempenhoTrabalhador;
    }

    public void setDesempenhoTrabalhador(Double desempenhoTrabalhador) {
        this.desempenhoTrabalhador = desempenhoTrabalhador;
    }

    public Double getIdCadunico() {
        return this.idCadunico;
    }

    public void setIdCadunico(Double idCadunico) {
        this.idCadunico = idCadunico;
    }

    public Integer getNumeroleiPortaria154Anexoi() {
        return this.numeroleiPortaria154Anexoi;
    }

    public void setNumeroleiPortaria154Anexoi(Integer numeroleiPortaria154Anexoi) {
        this.numeroleiPortaria154Anexoi = numeroleiPortaria154Anexoi;
    }

    public Date getDataleiPortaria154Anexoi() {
        return this.dataleiPortaria154Anexoi;
    }

    public void setDataleiPortaria154Anexoi(Date dataleiPortaria154Anexoi) {
        this.dataleiPortaria154Anexoi = dataleiPortaria154Anexoi;
    }

    public Integer getIdPortaria154Anexoi() {
        return this.idPortaria154Anexoi;
    }

    public void setIdPortaria154Anexoi(Integer idPortaria154Anexoi) {
        this.idPortaria154Anexoi = idPortaria154Anexoi;
    }

    public String getAnoDirfRecalculado() {
        return this.anoDirfRecalculado;
    }

    public void setAnoDirfRecalculado(String anoDirfRecalculado) {
        this.anoDirfRecalculado = anoDirfRecalculado;
    }

    public String getAnoRaisRecalculado() {
        return this.anoRaisRecalculado;
    }

    public void setAnoRaisRecalculado(String anoRaisRecalculado) {
        this.anoRaisRecalculado = anoRaisRecalculado;
    }

    public Integer getTiposalarioSegurodesemprego() {
        return this.tiposalarioSegurodesemprego;
    }

    public void setTiposalarioSegurodesemprego(Integer tiposalarioSegurodesemprego) {
        this.tiposalarioSegurodesemprego = tiposalarioSegurodesemprego;
    }

    public Double getRppsCorrecaoMonetaria() {
        return this.rppsCorrecaoMonetaria;
    }

    public void setRppsCorrecaoMonetaria(Double rppsCorrecaoMonetaria) {
        this.rppsCorrecaoMonetaria = rppsCorrecaoMonetaria;
    }

    public Double getRppsJurosMora() {
        return this.rppsJurosMora;
    }

    public void setRppsJurosMora(Double rppsJurosMora) {
        this.rppsJurosMora = rppsJurosMora;
    }

    public Double getRppsMulta() {
        return this.rppsMulta;
    }

    public void setRppsMulta(Double rppsMulta) {
        this.rppsMulta = rppsMulta;
    }

    public Boolean getUtilizaControlePortaria() {
        return this.utilizaControlePortaria;
    }

    public void setUtilizaControlePortaria(Boolean utilizaControlePortaria) {
        this.utilizaControlePortaria = utilizaControlePortaria;
    }

    public Date getEnviado() {
        return this.enviado;
    }

    public void setEnviado(Date enviado) {
        this.enviado = enviado;
    }

    public Boolean getCalcularProvisao() {
        return this.calcularProvisao;
    }

    public void setCalcularProvisao(Boolean calcularProvisao) {
        this.calcularProvisao = calcularProvisao;
    }

    public Boolean getSincronizarRpps() {
        return this.sincronizarRpps;
    }

    public void setSincronizarRpps(Boolean sincronizarRpps) {
        this.sincronizarRpps = sincronizarRpps;
    }

    public TipoDocumentoLegal getMudarefsalTipolegal() {
        return this.mudarefsalTipolegal;
    }

    public void setMudarefsalTipolegal(TipoDocumentoLegal mudarefsalTipolegal) {
        this.mudarefsalTipolegal = mudarefsalTipolegal;
    }

    public EntidadeOpcaoGeral getOpcoesGerais() {
        if (this.opcoesGerais == null) {
            this.opcoesGerais = new EntidadeOpcaoGeral();
        }
        return this.opcoesGerais;
    }

    public void setOpcoesGerais(EntidadeOpcaoGeral opcoesGerais) {
        this.opcoesGerais = opcoesGerais;
    }

    public EntidadeRPPS getRpps() {
        return this.rpps;
    }

    public void setRpps(EntidadeRPPS rpps) {
        this.rpps = rpps;
    }

    public EntidadeAudesp getAudesp() {
        return this.audesp;
    }

    public void setAudesp(EntidadeAudesp audesp) {
        this.audesp = audesp;
    }

    public List<Trabalhador> getTrabalhadorList() {
        return this.trabalhadorList;
    }

    public void setTrabalhadorList(List<Trabalhador> trabalhadorList) {
        this.trabalhadorList = trabalhadorList;
    }

    public List<Responsavel> getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(List<Responsavel> responsavel) {
        this.responsavel = responsavel;
    }

    public List<Referencia> getReferenciaList() {
        return this.referenciaList;
    }

    public void setReferenciaList(List<Referencia> referenciaList) {
        this.referenciaList = referenciaList;
    }

    public List<GrupoPonto> getGrupoPontoList() {
        return this.grupoPontoList;
    }

    public void setGrupoPontoList(List<GrupoPonto> grupoPontoList) {
        this.grupoPontoList = grupoPontoList;
    }

    public List<PericiaNova> getPericias() {
        return this.pericias;
    }

    public void setPericias(List<PericiaNova> pericias) {
        this.pericias = pericias;
    }

    public List<AmbienteTrabalho> getAmbientesTrabalho() {
        return this.ambientesTrabalho;
    }

    public void setAmbientesTrabalho(List<AmbienteTrabalho> ambientesTrabalho) {
        this.ambientesTrabalho = ambientesTrabalho;
    }

    public List<AtividadeCargo> getAtividadesCargo() {
        return this.atividadesCargo;
    }

    public void setAtividadesCargo(List<AtividadeCargo> atividadesCargo) {
        this.atividadesCargo = atividadesCargo;
    }

    public List<Usuario> getUsuarios() {
        return this.usuarios;
    }

    public void setUsuarios(List<Usuario> usuarios) {
        this.usuarios = usuarios;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Entidade)) {
            return false;
        }
        Entidade other = (Entidade)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public EntidadeESocial getEsocial() {
        if (this.esocial == null) {
            this.esocial = new EntidadeESocial();
        }
        return this.esocial;
    }

    public void setEsocial(EntidadeESocial esocial) {
        this.esocial = esocial;
    }

    public EntidadeScpi getScpi() {
        return this.scpi;
    }

    public void setScpi(EntidadeScpi scpi) {
        this.scpi = scpi;
    }

    public static boolean isSMA(EntidadeTipo tipo, UF uf) {
        return EntidadeTipo.ENTIDADE_ESTADUAL.equals((Object)tipo) && UF.SP.equals((Object)uf);
    }

    public boolean isSMA() {
        return Entidade.isSMA(this.getTipo(), this.getEndereco().getUf());
    }

    public EntidadeTceMg getTceMg() {
        return this.tceMg;
    }

    public void setTceMg(EntidadeTceMg tceMg) {
        this.tceMg = tceMg;
    }

    public EntidadeTceMs getTceMs() {
        return this.tceMs;
    }

    public void setTceMs(EntidadeTceMs tceMs) {
        this.tceMs = tceMs;
    }

    public EntidadeCertificado getCertificado() {
        return this.certificado;
    }

    public void setCertificado(EntidadeCertificado certificado) {
        this.certificado = certificado;
    }
}

