/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Instrucao;
import br.com.fiorilli.sip.persistence.entity.Pais;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import br.com.fiorilli.sip.persistence.entity.SituacaoEnsinoSuperior;
import br.com.fiorilli.sip.persistence.entity.UF;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="TRABCURRICULO_ENS_SUPERIOR")
@Audited
public class EnsinoSuperior
implements Serializable {
    public static final String FIND_BY_CPF = "SELECT e FROM EnsinoSuperior e LEFT JOIN FETCH e.grauInstrucao i WHERE e.cpf = :cpf ORDER BY e.dataFim DESC";
    public static final String GENERATOR = "GEN_TRABCURRICULO_ENS_SUPERIOR";
    private static final long serialVersionUID = 1L;
    @Id
    private int id;
    @Size(max=11)
    @Column(name="CPF")
    private String cpf;
    @Column(name="INSTRUCAO")
    private String grauInstrucaoCodigo;
    @JoinColumn(name="INSTRUCAO", nullable=false, referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Instrucao grauInstrucao;
    @FilterConfig(label="Curso", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="CURSO")
    private String curso;
    @FilterConfig(label="\u00canfase", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="ENFASE")
    private String enfase;
    @FilterConfig(label="\u00c1rea", condition=FilterCondition.COMECE)
    @Size(max=120)
    @Column(name="AREA")
    private String area;
    @JoinColumn(name="PAIS_ORIGEM", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Pais pais;
    @JoinColumn(name="CPF", referencedColumnName="CPF", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Pessoa pessoa;
    @Column(name="PAIS_ORIGEM")
    private Integer paisCodigo;
    @Size(max=30)
    @Column(name="CIDADE")
    private String cidade;
    @Enumerated(value=EnumType.STRING)
    @Column(name="UF")
    private UF uf;
    @Size(max=60)
    @Column(name="INSTITUICAO")
    private String nomeInstituicao;
    @Column(name="DATAINICIO")
    private Date dataInicio;
    @Column(name="DATAFIM")
    private Date dataFim;
    @Column(name="SITUACAO")
    @Enumerated
    private SituacaoEnsinoSuperior situacao;
    @Size(max=20)
    @Column(name="NUMERO_DIPLOMA")
    private String numeroDiploma;
    @Column(name="DT_ENTREGA_CERTIFICADO")
    private Date dataEntregaCertificado;

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getCurso() {
        return this.curso;
    }

    public void setCurso(String curso) {
        this.curso = curso;
    }

    public String getEnfase() {
        return this.enfase;
    }

    public void setEnfase(String enfase) {
        this.enfase = enfase;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getNomeInstituicao() {
        return this.nomeInstituicao;
    }

    public void setNomeInstituicao(String nomeInstituicao) {
        this.nomeInstituicao = nomeInstituicao;
    }

    public Pais getPais() {
        return this.pais;
    }

    public void setSippais(Pais sippais) {
        this.pais = sippais;
    }

    public Instrucao getGrauInstrucao() {
        return this.grauInstrucao;
    }

    public void setGrauInstrucao(Instrucao grauInstrucao) {
        this.grauInstrucaoCodigo = grauInstrucao != null ? grauInstrucao.getCodigo() : null;
        this.grauInstrucao = grauInstrucao;
    }

    public void setPais(Pais pais) {
        this.paisCodigo = pais != null ? pais.getCodigo() : null;
        this.pais = pais;
    }

    public UF getUf() {
        return this.uf;
    }

    public void setUf(UF uf) {
        this.uf = uf;
    }

    public SituacaoEnsinoSuperior getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SituacaoEnsinoSuperior situacao) {
        this.situacao = situacao;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnsinoSuperior other = (EnsinoSuperior)obj;
        return this.id == other.id;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Integer getPaisCodigo() {
        return this.paisCodigo;
    }

    public void setPaisCodigo(Integer paisCodigo) {
        this.paisCodigo = paisCodigo;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public String getGrauInstrucaoCodigo() {
        return this.grauInstrucaoCodigo;
    }

    public void setGrauInstrucaoCodigo(String grauInstrucaoCodigo) {
        this.grauInstrucaoCodigo = grauInstrucaoCodigo;
    }

    public String getNumeroDiploma() {
        return this.numeroDiploma;
    }

    public void setNumeroDiploma(String numeroDiploma) {
        this.numeroDiploma = numeroDiploma;
    }

    public Date getDataEntregaCertificado() {
        return this.dataEntregaCertificado;
    }

    public void setDataEntregaCertificado(Date dataEntregaCertificado) {
        this.dataEntregaCertificado = dataEntregaCertificado;
    }
}

