/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.CaracteristicasEspeciais;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.TipoServico;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="EMPREGO_ANTERIOR")
@Audited
public class EmpregoAnterior
implements Serializable,
Documento {
    public static final String FIND_BY_CPF = "SELECT e FROM EmpregoAnterior e WHERE e.cpf = :cpf";
    public static final String GENERATOR = "GEN_EMPREGOANTERIOR";
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Column(name="CPF")
    private String cpf;
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @Column(name="TIPOID")
    @Enumerated(value=EnumType.STRING)
    private IdentificadorTipo identificadorTipo;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATAINI")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicio;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATAFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFim;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=60)
    @Column(name="FUNCAO")
    private String funcao;
    @Embedded
    private Endereco endereco;
    @Size(max=60)
    @Column(name="DESCRICAO_VINCULO")
    private String descricaoVinculo;
    @Enumerated
    @Column(name="TIPOSERVICO")
    private TipoServico tipoServico;
    @Enumerated
    @Column(name="CARACTERISTICAS_ESPECIAIS")
    private CaracteristicasEspeciais caracteristicasEspeciais;
    @JoinColumn(name="CPF", referencedColumnName="CPF", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Pessoa pessoa;
    @Basic(optional=false)
    @Column(name="NUMDOC", length=16)
    private String numeroDocumento;
    @Basic(optional=false)
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @Type(type="BooleanTypeSip")
    @Column(name="INCIDE_ATS")
    private Boolean incideTempoServico;
    @Type(type="BooleanTypeSip")
    @Column(name="INCIDE_SEXTA_PARTE")
    private Boolean incideSextaParte;
    @Type(type="BooleanTypeSip")
    @Column(name="INCIDE_APOSENTADORIA")
    private Boolean incideAposentadoria;
    @Type(type="BooleanTypeSip")
    @Column(name="INCIDE_LICPREMIO")
    private Boolean incideLicencaPremio;
    @Column(name="ABATIMENTOS")
    private Short abatimento;
    @Column(name="ABATIMENTOS_ATS")
    private Short abatimentoAts;
    @Type(type="BooleanTypeSip")
    @Column(name="CONTA_APOSENTADORIA")
    private Boolean contaAposentadoria;

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
    }

    public EmpregoAnterior() {
        this.postLoad();
    }

    public IdentificadorTipo getIdentificadorTipo() {
        return this.identificadorTipo;
    }

    public void setIdentificadorTipo(IdentificadorTipo tipoid) {
        this.identificadorTipo = tipoid;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataini) {
        this.dataInicio = dataini;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date datafim) {
        this.dataFim = datafim;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getFuncao() {
        return this.funcao;
    }

    public void setFuncao(String funcao) {
        this.funcao = funcao;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getDescricaoVinculo() {
        return this.descricaoVinculo;
    }

    public void setDescricaoVinculo(String descricaoVinculo) {
        this.descricaoVinculo = descricaoVinculo;
    }

    public TipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(TipoServico tiposervico) {
        this.tipoServico = tiposervico;
    }

    public CaracteristicasEspeciais getCaracteristicasEspeciais() {
        return this.caracteristicasEspeciais;
    }

    public void setCaracteristicasEspeciais(CaracteristicasEspeciais caracteristicasEspeciais) {
        this.caracteristicasEspeciais = caracteristicasEspeciais;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = value != null ? value.getCodigo() : null;
        this.tipoLegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.dataDocumento;
    }

    @Override
    public void setData(Date value) {
        this.dataDocumento = value;
    }

    public Boolean getIncideTempoServico() {
        return this.incideTempoServico;
    }

    public void setIncideTempoServico(Boolean incideTempoServico) {
        this.incideTempoServico = incideTempoServico;
    }

    public Boolean getIncideSextaParte() {
        return this.incideSextaParte;
    }

    public void setIncideSextaParte(Boolean incideSextaParte) {
        this.incideSextaParte = incideSextaParte;
    }

    public Boolean getIncideAposentadoria() {
        return this.incideAposentadoria;
    }

    public void setIncideAposentadoria(Boolean incideAposentadoria) {
        this.incideAposentadoria = incideAposentadoria;
    }

    public Boolean getIncideLicencaPremio() {
        return this.incideLicencaPremio;
    }

    public void setIncideLicencaPremio(Boolean incideLicencaPremio) {
        this.incideLicencaPremio = incideLicencaPremio;
    }

    public Short getAbatimento() {
        return this.abatimento;
    }

    public void setAbatimento(Short abatimento) {
        this.abatimento = abatimento;
    }

    public Short getAbatimentoAts() {
        return this.abatimentoAts;
    }

    public void setAbatimentoAts(Short abatimentoAts) {
        this.abatimentoAts = abatimentoAts;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public Boolean getContaAposentadoria() {
        return this.contaAposentadoria;
    }

    public void setContaAposentadoria(Boolean contaAposentadoria) {
        this.contaAposentadoria = contaAposentadoria;
    }

    public String toString() {
        return "EmpregoAnterior [id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmpregoAnterior other = (EmpregoAnterior)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

