/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.ESocialQualificacaoCadastralErro;

public enum ESocialQualificacaoCadastralErroCadastro implements ESocialQualificacaoCadastralErro
{
    COD_NIS_INV("NIS inv\u00e1lido"),
    COD_CPF_INV("CPF inv\u00e1lido"),
    COD_NOME_INV("NOME inv\u00e1lido"),
    COD_DN_INV("DN inv\u00e1lida"),
    COD_CNIS_NIS("NIS inconsistente"),
    COD_CNIS_DN("Data de Nascimento informada diverge da existente no CNIS"),
    COD_CNIS_OBITO("NIS com \u00f3bito no CNIS"),
    COD_CNIS_CPF("CPF informado diverge do existente no CNIS"),
    COD_CNIS_CPF_NAO_INF("CPF n\u00e3o preenchido no CNIS"),
    COD_CPF_NAO_CONSTA("CPF informado n\u00e3o consta o Cadastro CPF"),
    COD_CPF_NULO("CPF informado NULO no Cadastro CPF"),
    COD_CPF_CANCELADO("CPF informado CANCELADO no Cadastro CPF"),
    COD_CPF_SUSPENSO("CPF informado SUSPENSO no Cadastro CPF"),
    COD_CPF_DN("Data de Nascimento informada diverge da existente no Cadastro CPF"),
    COD_CPF_NOME("NOME informado diverge do existente no Cadastro CPF. Obs: Informa o nome que consta no CPF"),
    COD_ORIENTACAO_CPF("Procurar Conveniadas da RFB: Correios, Banco do Brasil ou CAIXA"),
    COD_ORIENTACAO_NIS_INSS("Atualizar NIS no INSS \u2013 Ligar 135 para agendar atendimento"),
    COD_ORIENTACAO_NIS_CAIXA("Atualizar NIS da CAIXA \u2013 Utilizar Cadastro NIS Empresa pelo Conectividade Social ou uma ag\u00eancia da CAIXA"),
    COD_ORIENTACAO_NIS_BRASIL("Atualizar NIS em uma ag\u00eancia do Banco do Brasil");

    private final String msg;

    private ESocialQualificacaoCadastralErroCadastro(String msg) {
        this.msg = msg;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    public static ESocialQualificacaoCadastralErroCadastro getCodOrientacaoNis(String erro) {
        switch (erro) {
            case "1": {
                return COD_ORIENTACAO_NIS_INSS;
            }
            case "2": {
                return COD_ORIENTACAO_NIS_CAIXA;
            }
            case "3": {
                return COD_ORIENTACAO_NIS_BRASIL;
            }
        }
        throw new IllegalArgumentException("Valor inv\u00e1lido: " + erro);
    }

    public static ESocialQualificacaoCadastralErro of(int index) {
        return ESocialQualificacaoCadastralErroCadastro.values()[index - 4];
    }

    public static ESocialQualificacaoCadastralErro of(int index, String value) {
        if ((index -= 4) == 16) {
            return ESocialQualificacaoCadastralErroCadastro.getCodOrientacaoNis(value);
        }
        return ESocialQualificacaoCadastralErroCadastro.values()[index];
    }
}

