/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DuracaoLicencaPremioPK;
import br.com.fiorilli.sip.persistence.entity.VinculoRais;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="DURACAO_LICENCA_PREMIO")
@Audited
public class DuracaoLicencaPremio
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_ENTIDADE_RAIS = "SELECT d FROM DuracaoLicencaPremio d WHERE d.duracaoLicencaPremioPK.entidade = :entidadeId AND d.duracaoLicencaPremioPK.rais = :vinculoRais ORDER BY d.duracaoLicencaPremioPK.item";
    public static final String FIND_BY_RAIS_AND_TIPO = "SELECT d FROM DuracaoLicencaPremio d WHERE d.duracaoLicencaPremioPK.entidade = :entidadeCodigo AND d.duracaoLicencaPremioPK.rais = :vinculoRais AND d.duracaoLicencaPremioPK.tipoFalta = :tipo ORDER BY d.duracaoLicencaPremioPK.item";
    public static final String GET_NEXT_ITEM = "SELECT COALESCE(MAX(d.duracaoLicencaPremioPK.item), 0) + 1 FROM DuracaoLicencaPremio d WHERE d.duracaoLicencaPremioPK.entidade = :entidadeCodigo AND d.duracaoLicencaPremioPK.rais = :vinculoRais AND d.duracaoLicencaPremioPK.tipoFalta = :tipoFalta";
    @EmbeddedId
    protected DuracaoLicencaPremioPK duracaoLicencaPremioPK;
    @Column(name="DE")
    private Short de;
    @Column(name="ATE")
    private Short ate;
    @Column(name="DIAS")
    private Short dias;
    @Column(name="RAIS", insertable=false, updatable=false)
    private String vinculoRais;
    @Transient
    private boolean remover;

    public DuracaoLicencaPremio() {
    }

    public DuracaoLicencaPremio(DuracaoLicencaPremioPK duracaoLicencaPremioPK) {
        this.duracaoLicencaPremioPK = duracaoLicencaPremioPK;
    }

    public DuracaoLicencaPremio(String entidade, String rais, int tipoFalta, short item) {
        this.duracaoLicencaPremioPK = new DuracaoLicencaPremioPK(entidade, rais, tipoFalta, item);
    }

    public DuracaoLicencaPremioPK getDuracaoLicencaPremioPK() {
        return this.duracaoLicencaPremioPK;
    }

    public void setDuracaoLicencaPremioPK(DuracaoLicencaPremioPK duracaoLicencaPremioPK) {
        this.duracaoLicencaPremioPK = duracaoLicencaPremioPK;
    }

    public Short getDe() {
        return this.de;
    }

    public void setDe(Short de) {
        this.de = de;
    }

    public Short getAte() {
        return this.ate;
    }

    public void setAte(Short ate) {
        this.ate = ate;
    }

    public Short getDias() {
        return this.dias;
    }

    public void setDias(Short dias) {
        this.dias = dias;
    }

    public VinculoRais getVinculoRais() {
        return VinculoRais.toEntity(this.vinculoRais);
    }

    public void setVinculoRais(VinculoRais vinculoRais) {
        this.vinculoRais = vinculoRais.getCodigo();
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.duracaoLicencaPremioPK != null ? this.duracaoLicencaPremioPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DuracaoLicencaPremio)) {
            return false;
        }
        DuracaoLicencaPremio other = (DuracaoLicencaPremio)object;
        if (this.duracaoLicencaPremioPK == null && other.duracaoLicencaPremioPK != null || this.duracaoLicencaPremioPK != null && !this.duracaoLicencaPremioPK.equals(other.duracaoLicencaPremioPK)) {
            return false;
        }
        return this.duracaoLicencaPremioPK.getItem() != null || other.duracaoLicencaPremioPK.getItem() != null || this.de == other.de && this.ate == other.ate && this.dias == other.dias;
    }

    public String toString() {
        return "entity.DuracaoLicencaPremio[ duracaoLicencaPremioPK=" + this.duracaoLicencaPremioPK + " ]";
    }

    public boolean isRemover() {
        return this.remover;
    }

    public void setRemover(boolean remover) {
        this.remover = remover;
    }
}

