/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Embeddable
public class DocumentoProrrogacaoConcurso
implements Documento {
    private static final long serialVersionUID = 1L;
    @Column(name="DTDOCPRORROGACAO")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Size(max=16)
    @Column(name="NUMDOCPRORROGACAO")
    private String numeroDocumento;
    @Column(name="TIPODOCPRORROGACAO")
    private Integer tipoDocumentoPorrogacaoCodigo;
    @JoinColumn(name="TIPODOCPRORROGACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoDocumentoProrrogacao;

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoDocumentoProrrogacao;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoDocumentoPorrogacaoCodigo = this.tipoDocumentoProrrogacao != null ? value.getCodigo() : null;
        this.tipoDocumentoProrrogacao = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoDocumentoPorrogacaoCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.data;
    }

    @Override
    public void setData(Date value) {
        this.data = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.numeroDocumento == null ? 0 : this.numeroDocumento.hashCode());
        result = 31 * result + (this.tipoDocumentoPorrogacaoCodigo == null ? 0 : this.tipoDocumentoPorrogacaoCodigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentoProrrogacaoConcurso other = (DocumentoProrrogacaoConcurso)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.numeroDocumento == null ? other.numeroDocumento != null : !this.numeroDocumento.equals(other.numeroDocumento)) {
            return false;
        }
        return !(this.tipoDocumentoPorrogacaoCodigo == null ? other.tipoDocumentoPorrogacaoCodigo != null : !this.tipoDocumentoPorrogacaoCodigo.equals(other.tipoDocumentoPorrogacaoCodigo));
    }

    public String toString() {
        return "DocumentoProrrogacaoConcurso [data=" + this.data + ", numeroDocumento=" + this.numeroDocumento + ", tipoDocumentoPorrogacaoCodigo=" + this.tipoDocumentoPorrogacaoCodigo + "]";
    }
}

