/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.DocumentoMovimentoProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.DocumentoParecerProcedimentoAdiministrativo;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="DOCDIGITALPDF")
@Audited
public class DocumentoDigitalPDF
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_HASH = "SELECT d FROM DocumentoDigitalPDF d WHERE d.hashArquivo = :hashArquivo";
    public static final String FIND_BY_ID = "SELECT d FROM DocumentoDigitalPDF d WHERE d.id = :id";
    public static final String IS_REMOVABLE = "SELECT CASE WHEN (COUNT(d) > 1) THEN false ELSE true END FROM DocumentoDigitalPDF d LEFT JOIN d.documentoDigitalList dd LEFT JOIN d.documentoMovimentoProcedimentoAdministrativoList dm LEFT JOIN d.documentoParecerProcedimentoAdministrativoList dp WHERE d.id = :pdfId";
    public static final String COUNT_DOCDIGITAL = "SELECT COUNT(dd.id) FROM DocumentoDigital dd WHERE dd.documentoDigitalPdf.id = :pdfId";
    public static final String COUNT_DOC_MOV = "SELECT COUNT(dm.documentoMovimentoProcedimentoAdministrativoPK.idPdf) FROM DocumentoMovimentoProcedimentoAdministrativo dm WHERE dm.documentoDigitalPdf.id = :pdfId";
    public static final String COUNT_DOC_PAR = "SELECT COUNT(dp.documentoParecerProcedimentoAdiministrativoPK.idPdf) FROM DocumentoParecerProcedimentoAdiministrativo dp WHERE dp.documentoDigitalPdf.id = :pdfId";
    public static final String GENERATOR = "GEN_DOCDIGITALPDF";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="IDPDF")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=60)
    @Column(name="NOMEARQ")
    private String nomeArquivo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=32)
    @Column(name="HASHARQ")
    private String hashArquivo;
    @Lob
    @Column(name="PDF")
    private byte[] pdf;
    @OneToMany(mappedBy="documentoDigitalPdf", fetch=FetchType.LAZY)
    private List<DocumentoDigital> documentoDigitalList;
    @OneToMany(mappedBy="documentoDigitalPdf", fetch=FetchType.LAZY)
    private List<DocumentoMovimentoProcedimentoAdministrativo> documentoMovimentoProcedimentoAdministrativoList;
    @OneToMany(mappedBy="documentoDigitalPdf", fetch=FetchType.LAZY)
    private List<DocumentoParecerProcedimentoAdiministrativo> documentoParecerProcedimentoAdministrativoList;

    public DocumentoDigitalPDF() {
    }

    public DocumentoDigitalPDF(Integer idpdf) {
        this.id = idpdf;
    }

    public DocumentoDigitalPDF(Integer idpdf, String nomearq, String hasharq) {
        this.id = idpdf;
        this.nomeArquivo = nomearq;
        this.hashArquivo = hasharq;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer idpdf) {
        this.id = idpdf;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomearq) {
        this.nomeArquivo = nomearq;
    }

    public String getHashArquivo() {
        return this.hashArquivo;
    }

    public void setHashArquivo(String hasharq) {
        this.hashArquivo = hasharq;
    }

    public byte[] getPdf() {
        return this.pdf;
    }

    public void setPdf(byte[] pdf) {
        this.pdf = pdf;
    }

    public List<DocumentoDigital> getDocumentoDigitalList() {
        return this.documentoDigitalList;
    }

    public void setDocumentoDigitalList(List<DocumentoDigital> docdigitalList) {
        this.documentoDigitalList = docdigitalList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DocumentoDigitalPDF)) {
            return false;
        }
        DocumentoDigitalPDF other = (DocumentoDigitalPDF)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.Docdigitalpdf[ idpdf=" + this.id + " ]";
    }

    public List<DocumentoMovimentoProcedimentoAdministrativo> getDocumentoMovimentoProcedimentoAdministrativoList() {
        return this.documentoMovimentoProcedimentoAdministrativoList;
    }

    public void setDocumentoMovimentoProcedimentoAdministrativoList(List<DocumentoMovimentoProcedimentoAdministrativo> documentoMovimentoProcedimentoAdministrativoList) {
        this.documentoMovimentoProcedimentoAdministrativoList = documentoMovimentoProcedimentoAdministrativoList;
    }
}

