/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ConcursoEdital;
import br.com.fiorilli.sip.persistence.entity.DocumentoDescricao;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigitalPDF;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.LocalPublicacao;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="DOCDIGITAL")
@Audited
public class DocumentoDigital
implements Serializable,
Documento,
Filterable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_NUMERO = "SELECT dd FROM DocumentoDigital dd LEFT JOIN FETCH dd.tipoLegal LEFT JOIN FETCH dd.localPublicacao WHERE dd.numeroDocumento like :numeroDocumento";
    public static final String GET_DOCUMENTO_DIGITAL_FETCHED = "SELECT dd FROM DocumentoDigital dd LEFT JOIN FETCH dd.veiculoPublicacao v LEFT JOIN FETCH dd.localPublicacao l LEFT JOIN FETCH dd.tipoLegal t LEFT JOIN FETCH dd.documentoDigitalPdf dg WHERE dd.id = :id";
    public static final String GENERATOR = "GEN_DOCDIGITAL";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="IDDOCDIGITAL")
    private Integer id;
    @FilterConfig(label="N\u00famero do Documento")
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @FilterConfig(label="Data Documento", condition=FilterCondition.INTERVALO, inputType=FilterInputType.CALENDAR)
    @Basic(optional=false)
    @NotNull
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @FilterConfig(label="Data Publica\u00e7\u00e3o", condition=FilterCondition.INTERVALO, inputType=FilterInputType.CALENDAR)
    @Column(name="DATAPUBLICACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataPublicacao;
    @FilterConfig(label="In\u00edcio Vig\u00eancia", condition=FilterCondition.INTERVALO, inputType=FilterInputType.CALENDAR)
    @Basic(optional=false)
    @NotNull
    @Column(name="DTINIVIGENCIA")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicioVigencia;
    @Size(max=512)
    @Column(name="OBS")
    private String obs;
    @Size(min=1, max=3)
    @Column(name="EMPRESA", nullable=false)
    private String entidadeCodigo;
    @Column(name="TIPOLEGAL", nullable=false)
    private Integer tipoLegalCodigo;
    @JoinColumn(name="VEICULOPUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private VeiculoPublicacao veiculoPublicacao;
    @Column(name="VEICULOPUBLICACAO")
    private Integer veiculoPublicacaoCodigo;
    @JoinColumn(name="LOCALPUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private LocalPublicacao localPublicacao;
    @Column(name="LOCALPUBLICACAO")
    private Integer localPublicacaoCodigo;
    @FilterConfigJoin(fetch=true, type=FilterJoinType.LEFT)
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @JoinColumn(name="IDPDF", referencedColumnName="IDPDF")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private DocumentoDigitalPDF documentoDigitalPdf;
    @Type(type="BooleanTypeSip")
    @Column(name="ENVIAR_AUDESP")
    private Boolean enviarParaAudesp;
    @JoinColumn(name="CPF_RESPONSAVEL", referencedColumnName="CPF")
    @ManyToOne(fetch=FetchType.LAZY)
    private Pessoa responsavel;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="docDigitalAposentadoria")
    private List<Trabalhador> trabalhadoresAposentadoria;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="docDigitalPensao")
    private List<Trabalhador> trabalhadoresPensao;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="documentoDigital")
    private List<ConcursoEdital> editaisConcurso;
    public static final String COUNT_BY_IDPDF = "SELECT         COUNT(dg.id) FROM         DocumentoDigital dg WHERE         dg.documentoDigitalPdf IS NOT NULL AND     dg.documentoDigitalPdf.id        = :idPdf";

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    public DocumentoDigital() {
    }

    public DocumentoDigital(Integer iddocdigital) {
        this.id = iddocdigital;
    }

    public DocumentoDigital(Integer iddocdigital, String numdoc, Date datadoc, Date dtinivigencia) {
        this.id = iddocdigital;
        this.numeroDocumento = numdoc;
        this.dataDocumento = datadoc;
        this.dataInicioVigencia = dtinivigencia;
    }

    public String getDescricao() {
        return new DocumentoDescricao(this.getTipoLegal(), this.getNumeroDocumento(), this.getDataDocumento()).getDescricao();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer iddocdigital) {
        this.id = iddocdigital;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    public Date getDataPublicacao() {
        return this.dataPublicacao;
    }

    public void setDataPublicacao(Date datapublicacao) {
        this.dataPublicacao = datapublicacao;
    }

    public Date getDataInicioVigencia() {
        return this.dataInicioVigencia;
    }

    public void setDataInicioVigencia(Date dtinivigencia) {
        this.dataInicioVigencia = dtinivigencia;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculopublicacao) {
        this.veiculoPublicacao = veiculopublicacao;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegalCodigo = tipoLegal != null ? tipoLegal.getCodigo() : null;
        this.tipoLegal = tipoLegal;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidadeCodigo = entidade != null ? entidade.getCodigo() : null;
        this.entidade = entidade;
    }

    public DocumentoDigitalPDF getDocumentoDigitalPdf() {
        return this.documentoDigitalPdf;
    }

    public void setDocumentoDigitalPdf(DocumentoDigitalPDF documentoDigitalPdf) {
        this.documentoDigitalPdf = documentoDigitalPdf;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    public Boolean getEnviarParaAudesp() {
        return this.enviarParaAudesp;
    }

    public void setEnviarParaAudesp(Boolean enviarParaAudesp) {
        this.enviarParaAudesp = enviarParaAudesp;
    }

    public Pessoa getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Pessoa responsavel) {
        this.responsavel = responsavel;
    }

    public List<Trabalhador> getTrabalhadoresAposentadoria() {
        return this.trabalhadoresAposentadoria;
    }

    public void setTrabalhadoresAposentadoria(List<Trabalhador> trabalhadoresAposentadoria) {
        this.trabalhadoresAposentadoria = trabalhadoresAposentadoria;
    }

    public List<Trabalhador> getTrabalhadoresPensao() {
        return this.trabalhadoresPensao;
    }

    public void setTrabalhadoresPensao(List<Trabalhador> trabalhadoresPensao) {
        this.trabalhadoresPensao = trabalhadoresPensao;
    }

    public List<ConcursoEdital> getEditaisConcurso() {
        return this.editaisConcurso;
    }

    public void setEditaisConcurso(List<ConcursoEdital> editaisConcurso) {
        this.editaisConcurso = editaisConcurso;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DocumentoDigital)) {
            return false;
        }
        DocumentoDigital other = (DocumentoDigital)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "DocumentoDigital [id=" + this.id + "]";
    }

    @Override
    public Date getData() {
        return this.dataDocumento;
    }

    public String getItemLabel() {
        return this.numeroDocumento;
    }

    public String getItemId() {
        return Integer.toString(this.id);
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.id);
    }

    public Integer getVeiculoPublicacaoCodigo() {
        return this.veiculoPublicacaoCodigo;
    }

    public void setVeiculoPublicacaoCodigo(Integer veiculoPublicacaoCodigo) {
        this.veiculoPublicacaoCodigo = veiculoPublicacaoCodigo;
    }

    public LocalPublicacao getLocalPublicacao() {
        return this.localPublicacao;
    }

    public void setLocalPublicacao(LocalPublicacao localPublicacao) {
        this.localPublicacao = localPublicacao;
    }

    public Integer getLocalPublicacaoCodigo() {
        return this.localPublicacaoCodigo;
    }

    public void setLocalPublicacaoCodigo(Integer localPublicacaoCodigo) {
        this.localPublicacaoCodigo = localPublicacaoCodigo;
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }
}

