/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DocumentoDescricao {
    private static final String S_N = "S/N";
    private static final String N = "n\u00ba ";
    private static final String DATE_SEPARATOR = "de ";
    private static final String DOCUMENTO_INDEFINIDO = "Documento Indefinido";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/YYYY");
    private final String descricao;

    public DocumentoDescricao(TipoDocumentoLegal tipoLegal, String numeroDocumento, Date dataDocumento) {
        if (tipoLegal == null && numeroDocumento == null && dataDocumento == null) {
            this.descricao = "";
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.buildTipoDocumento(tipoLegal)).append(" ");
            sb.append(this.buildNumeroDocumento(numeroDocumento)).append(" ");
            sb.append(this.buildDataDocumento(dataDocumento));
            this.descricao = sb.toString();
        }
    }

    private String buildDataDocumento(Date dataDocumento) {
        if (dataDocumento != null) {
            return DATE_SEPARATOR + sdf.format(dataDocumento);
        }
        return null;
    }

    private String buildNumeroDocumento(String numeroDocumento) {
        if (!StringUtils.isEmpty((CharSequence)numeroDocumento)) {
            return N + numeroDocumento;
        }
        return S_N;
    }

    private String buildTipoDocumento(TipoDocumentoLegal tipoLegal) {
        if (tipoLegal != null) {
            return tipoLegal.getNome();
        }
        return DOCUMENTO_INDEFINIDO;
    }

    public String getDescricao() {
        return this.descricao;
    }
}

