/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Embeddable
public class DocumentoCriacaoLotacao
implements Documento {
    private static final long serialVersionUID = 1L;
    @Column(name="DTCRIACAO")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Size(max=16)
    @Column(name="NUMDOC_CRIACAO")
    private String numeroDocumento;
    @JoinColumn(name="TIPOLEGAL_CRIACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipolegalCriacao;
    @Column(name="TIPOLEGAL_CRIACAO")
    private Integer tipoLegalCodigo;

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipolegalCriacao;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = this.tipolegalCriacao != null ? value.getCodigo() : null;
        this.tipolegalCriacao = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.data;
    }

    @Override
    public void setData(Date value) {
        this.data = value;
    }

    public String toString() {
        return "DocumentoCriacaoBasic [data=" + this.data + ", numeroDocumento=" + this.numeroDocumento + ", tipolegalCriacao=" + this.tipolegalCriacao + ", tipoLegalCodigo=" + this.tipoLegalCodigo + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.numeroDocumento == null ? 0 : this.numeroDocumento.hashCode());
        result = 31 * result + (this.tipoLegalCodigo == null ? 0 : this.tipoLegalCodigo.hashCode());
        result = 31 * result + (this.tipolegalCriacao == null ? 0 : this.tipolegalCriacao.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentoCriacaoLotacao other = (DocumentoCriacaoLotacao)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.numeroDocumento == null ? other.numeroDocumento != null : !this.numeroDocumento.equals(other.numeroDocumento)) {
            return false;
        }
        if (this.tipoLegalCodigo == null ? other.tipoLegalCodigo != null : !this.tipoLegalCodigo.equals(other.tipoLegalCodigo)) {
            return false;
        }
        return !(this.tipolegalCriacao == null ? other.tipolegalCriacao != null : !this.tipolegalCriacao.equals(other.tipolegalCriacao));
    }
}

