/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Embeddable
public class DocumentoCriacaoConcurso
implements Documento {
    private static final long serialVersionUID = 1L;
    @Basic(optional=false)
    @Size(min=1, max=16)
    @Column(name="NUMDOC")
    private String numeroDocumentoCriacao;
    @Basic(optional=false)
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumentoCriacao;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegalCriacao;
    @Column(name="TIPOLEGAL")
    private Integer tipoDocumentoCriacaoCodigo;

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoDocumentoCriacaoCodigo = this.tipoLegalCriacao != null ? value.getCodigo() : null;
        this.tipoLegalCriacao = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoDocumentoCriacaoCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumentoCriacao;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumentoCriacao = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumentoCriacao);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumentoCriacao);
    }

    @Override
    public Date getData() {
        return this.dataDocumentoCriacao;
    }

    @Override
    public void setData(Date value) {
        this.dataDocumentoCriacao = value;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegalCriacao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataDocumentoCriacao == null ? 0 : this.dataDocumentoCriacao.hashCode());
        result = 31 * result + (this.numeroDocumentoCriacao == null ? 0 : this.numeroDocumentoCriacao.hashCode());
        result = 31 * result + (this.tipoDocumentoCriacaoCodigo == null ? 0 : this.tipoDocumentoCriacaoCodigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentoCriacaoConcurso other = (DocumentoCriacaoConcurso)obj;
        if (this.dataDocumentoCriacao == null ? other.dataDocumentoCriacao != null : !this.dataDocumentoCriacao.equals(other.dataDocumentoCriacao)) {
            return false;
        }
        if (this.numeroDocumentoCriacao == null ? other.numeroDocumentoCriacao != null : !this.numeroDocumentoCriacao.equals(other.numeroDocumentoCriacao)) {
            return false;
        }
        return !(this.tipoDocumentoCriacaoCodigo == null ? other.tipoDocumentoCriacaoCodigo != null : !this.tipoDocumentoCriacaoCodigo.equals(other.tipoDocumentoCriacaoCodigo));
    }

    public String toString() {
        return "DocumentoCriacaoConcurso [numeroDocumentoCriacao=" + this.numeroDocumentoCriacao + ", dataDocumentoCriacao=" + this.dataDocumentoCriacao + ", tipoDocumentoCriacaoCodigo=" + this.tipoDocumentoCriacaoCodigo + "]";
    }
}

