/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DocumentoAdmissaoPK;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="DOCUMENTO_ADMISSAO")
@Audited
public class DocumentoAdmissao
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private DocumentoAdmissaoPK documentoAdmissaoPK;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Column(name="DOCDIGITAL", insertable=false, updatable=false)
    private Integer documentoDigitalId;
    @JoinColumn(name="DOCDIGITAL", referencedColumnName="IDDOCDIGITAL", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private DocumentoDigital documentoDigital;

    public static DocumentoAdmissao createInitialized(String entidadeCodigo, String registro) {
        DocumentoAdmissao d = new DocumentoAdmissao();
        d.setDocumentoAdmissaoPK(new DocumentoAdmissaoPK());
        d.getDocumentoAdmissaoPK().setEntidade(entidadeCodigo);
        d.getDocumentoAdmissaoPK().setRegistro(registro);
        return d;
    }

    public DocumentoAdmissao() {
    }

    public DocumentoAdmissao(String entidade, String registro, Integer documentoDigitalId) {
        this.documentoAdmissaoPK = new DocumentoAdmissaoPK(entidade, registro, documentoDigitalId);
    }

    public DocumentoAdmissao(DocumentoAdmissaoPK documentoAdmissaoPK) {
        this.documentoAdmissaoPK = documentoAdmissaoPK;
    }

    public DocumentoAdmissaoPK getDocumentoAdmissaoPK() {
        return this.documentoAdmissaoPK;
    }

    public void setDocumentoAdmissaoPK(DocumentoAdmissaoPK documentoAdmissaoPK) {
        this.documentoAdmissaoPK = documentoAdmissaoPK;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public DocumentoDigital getDocumentoDigital() {
        if (this.documentoDigital == null) {
            this.documentoDigital = new DocumentoDigital();
        }
        return this.documentoDigital;
    }

    public void setDocumentoDigital(DocumentoDigital documentoDigital) {
        if (documentoDigital != null) {
            this.documentoDigitalId = documentoDigital.getId();
            this.getDocumentoAdmissaoPK().setDocumentoDigitalId(this.documentoDigitalId);
        } else {
            this.documentoDigitalId = null;
            this.getDocumentoAdmissaoPK().setDocumentoDigitalId(null);
        }
        this.documentoDigital = documentoDigital;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.documentoAdmissaoPK == null ? 0 : this.documentoAdmissaoPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentoAdmissao other = (DocumentoAdmissao)obj;
        return !(this.documentoAdmissaoPK == null ? other.documentoAdmissaoPK != null : !this.documentoAdmissaoPK.equals(other.documentoAdmissaoPK));
    }

    public String toString() {
        return "DocumentoAdmissao [documentoAdmissaoPK=" + this.documentoAdmissaoPK + "]";
    }

    public Integer getDocumentoDigitalId() {
        return this.documentoDigitalId;
    }

    public void setDocumentoDigitalId(Integer documentoDigitalId) {
        this.documentoDigitalId = documentoDigitalId;
    }
}

